/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.gt.ingredients.operations;

import ptolemy.actor.gt.GTIngredient;
import ptolemy.actor.gt.GTIngredientElement;
import ptolemy.actor.gt.GTIngredientList;
import ptolemy.actor.gt.Pattern;
import ptolemy.actor.gt.Replacement;
import ptolemy.actor.gt.ValidationException;
import ptolemy.actor.gt.data.MatchResult;
import ptolemy.actor.gt.ingredients.operations.Operation;
import ptolemy.actor.gt.ingredients.operations.OperationElement;
import ptolemy.actor.gt.ingredients.operations.StringOperationElement;
import ptolemy.kernel.Entity;
import ptolemy.kernel.util.ChangeRequest;
import ptolemy.kernel.util.NamedObj;
import ptolemy.moml.MoMLChangeRequest;

public class RenameOperation
extends Operation {
    private static final OperationElement[] _ELEMENTS = new OperationElement[]{new StringOperationElement("name", false, true)};
    private String _name;

    public RenameOperation(GTIngredientList owner) {
        this(owner, "");
    }

    public RenameOperation(GTIngredientList owner, String values) {
        super(owner, 1);
        this.setValues(values);
    }

    @Override
    public ChangeRequest getChangeRequest(Pattern pattern, Replacement replacement, MatchResult matchResult, Entity patternEntity, Entity replacementEntity, Entity hostEntity) {
        if (this.isNameEnabled()) {
            NamedObj parent = hostEntity.getContainer();
            String moml = "<entity name=\"" + hostEntity.getName() + "\"><rename name=\"" + this._name + "\"/></entity>";
            return new MoMLChangeRequest(this, parent, moml, null);
        }
        return null;
    }

    @Override
    public GTIngredientElement[] getElements() {
        return _ELEMENTS;
    }

    public String getName() {
        return this._name;
    }

    @Override
    public Object getValue(int index) {
        switch (index) {
            case 0: {
                return this._name;
            }
        }
        return null;
    }

    @Override
    public String getValues() {
        StringBuffer buffer = new StringBuffer();
        this._encodeStringField(buffer, 0, this._name);
        return buffer.toString();
    }

    public boolean isNameEnabled() {
        return this.isEnabled(0);
    }

    @Override
    public void setValue(int index, Object value) {
        switch (index) {
            case 0: {
                this._name = (String)value;
            }
        }
    }

    @Override
    public void setValues(String values) {
        GTIngredient.FieldIterator fieldIterator = new GTIngredient.FieldIterator(values);
        this._name = this._decodeStringField(0, fieldIterator);
    }

    @Override
    public void validate() throws ValidationException {
        if (this._name.equals("")) {
            throw new ValidationException("Name must not be empty.");
        }
        if (this._name.contains(".")) {
            throw new ValidationException("Name must not have period (\".\") in it.");
        }
    }
}

