/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.gui;

import java.awt.Component;
import java.awt.Container;
import java.io.IOException;
import java.io.Writer;
import javax.swing.JFrame;
import ptolemy.actor.TypedAtomicActor;
import ptolemy.actor.gui.Placeable;
import ptolemy.actor.gui.SizeAttribute;
import ptolemy.actor.gui.WindowPropertiesAttribute;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;

public abstract class AbstractPlaceableActor
extends TypedAtomicActor
implements Placeable {
    protected JFrame _frame;
    protected SizeAttribute _paneSize;
    protected WindowPropertiesAttribute _windowProperties = new WindowPropertiesAttribute(this, "_windowProperties");

    public AbstractPlaceableActor(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this._windowProperties.setPersistent(true);
        this._paneSize = new SizeAttribute(this, "_paneSize");
        this._paneSize.setPersistent(true);
    }

    @Override
    public abstract void place(Container var1);

    public void setFrame(JFrame frame) {
        this._frame = frame;
        this._windowProperties.setProperties(this._frame);
        Component[] components = this._frame.getContentPane().getComponents();
        if (components.length > 0) {
            this._paneSize.setSize(components[0]);
        }
    }

    @Override
    protected void _exportMoMLContents(Writer output, int depth) throws IOException {
        if (this._frame != null) {
            this._windowProperties.recordProperties(this._frame);
            Component[] components = this._frame.getContentPane().getComponents();
            if (components.length > 0) {
                this._paneSize.recordSize(components[0]);
            }
        }
        super._exportMoMLContents(output, depth);
    }
}

