/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.gui;

import diva.graph.GraphController;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.Action;
import ptolemy.actor.Actor;
import ptolemy.actor.IOPort;
import ptolemy.actor.gui.ColorAttribute;
import ptolemy.data.BooleanToken;
import ptolemy.data.expr.SingletonParameter;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.Location;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Settable;
import ptolemy.moml.MoMLChangeRequest;
import ptolemy.vergil.actor.ActorInstanceController;
import ptolemy.vergil.basic.NamedObjController;
import ptolemy.vergil.basic.NodeControllerFactory;
import ptolemy.vergil.icon.EditorIcon;
import ptolemy.vergil.kernel.attributes.RectangleAttribute;
import ptolemy.vergil.kernel.attributes.TextAttribute;
import ptolemy.vergil.toolbox.FigureAction;
import ptolemy.vergil.toolbox.MenuActionFactory;
import ptolemy.vergil.toolbox.MenuItemFactory;

public class DependencyHighlighter
extends NodeControllerFactory {
    public ColorAttribute highlightColor = new ColorAttribute((NamedObj)((Object)this), "highlightColor");

    public DependencyHighlighter(NamedObj container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.highlightColor.setExpression("{1.0, 0.0, 0.0, 1.0}");
        SingletonParameter _hideName = new SingletonParameter((NamedObj)((Object)this), "_hideName");
        _hideName.setToken(BooleanToken.TRUE);
        _hideName.setVisibility(Settable.EXPERT);
        EditorIcon _icon = new EditorIcon((NamedObj)((Object)this), "_icon");
        RectangleAttribute rectangle = new RectangleAttribute((NamedObj)_icon, "rectangle");
        rectangle.width.setExpression("155.0");
        rectangle.height.setExpression("20.0");
        rectangle.fillColor.setExpression("{1.0, 0.7, 0.7, 1.0}");
        Location _location = new Location((NamedObj)rectangle, "_location");
        _location.setExpression("-5.0, -15.0");
        TextAttribute text = new TextAttribute((NamedObj)_icon, "text");
        text.text.setExpression("DependencyHighlighter");
    }

    public NamedObjController create(GraphController controller) {
        return new DependencyController(controller);
    }

    private void _addHighlights(NamedObj actor, StringBuffer moml, HashSet<NamedObj> visited, boolean forward, boolean clear) {
        if (visited.contains(actor)) {
            return;
        }
        if (actor instanceof Actor) {
            moml.append("<entity name=\"");
            moml.append(actor.getName());
            moml.append("\">");
            if (!clear) {
                moml.append(this.highlightColor.exportMoML("_highlightColor"));
            } else if (actor.getAttribute("_highlightColor") != null) {
                moml.append("<deleteProperty name=\"_highlightColor\"/>");
            }
            moml.append("</entity>");
            visited.add(actor);
            Iterator ports = forward ? ((Actor)((Object)actor)).outputPortList().iterator() : ((Actor)((Object)actor)).inputPortList().iterator();
            while (ports.hasNext()) {
                IOPort port = (IOPort)ports.next();
                for (IOPort otherPort : port.connectedPortList()) {
                    if (port.isInput() && !otherPort.isOutput() || port.isOutput() && !otherPort.isInput()) continue;
                    NamedObj higherActor = otherPort.getContainer();
                    this._addHighlights(higherActor, moml, visited, forward, clear);
                }
            }
        }
    }

    private class HighlightDependents
    extends FigureAction {
        private boolean _forward;
        private boolean _clear;

        public HighlightDependents(String commandName, boolean forward, boolean clear) {
            super(commandName);
            this._forward = forward;
            this._clear = clear;
        }

        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            NamedObj actor = this.getTarget();
            StringBuffer moml = new StringBuffer("<group>");
            HashSet visited = new HashSet();
            DependencyHighlighter.this._addHighlights(actor, moml, visited, this._forward, this._clear);
            moml.append("</group>");
            actor.requestChange(new MoMLChangeRequest((Object)this, actor.getContainer(), moml.toString()));
        }
    }

    public class DependencyController
    extends ActorInstanceController {
        public DependencyController(GraphController controller) {
            super(controller);
            HighlightDependents highlight = new HighlightDependents("Highlight dependents", true, false);
            this._menuFactory.addMenuItemFactory((MenuItemFactory)new MenuActionFactory((Action)((Object)highlight)));
            HighlightDependents clear1 = new HighlightDependents("Clear dependents", true, true);
            this._menuFactory.addMenuItemFactory((MenuItemFactory)new MenuActionFactory((Action)((Object)clear1)));
            HighlightDependents prerequisites = new HighlightDependents("Highlight prerequisites", false, false);
            this._menuFactory.addMenuItemFactory((MenuItemFactory)new MenuActionFactory((Action)((Object)prerequisites)));
            HighlightDependents clear2 = new HighlightDependents("Clear prerequisites", false, true);
            this._menuFactory.addMenuItemFactory((MenuItemFactory)new MenuActionFactory((Action)((Object)clear2)));
        }
    }
}

