/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.gui;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Iterator;
import ptolemy.actor.gui.Effigy;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Workspace;
import ptolemy.util.ClassUtilities;

public class EffigyFactory
extends CompositeEntity {
    public EffigyFactory(Workspace workspace) {
        super(workspace);
    }

    public EffigyFactory(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
    }

    public boolean canCreateBlankEffigy() {
        for (EffigyFactory factory : this.entityList(EffigyFactory.class)) {
            if (!factory.canCreateBlankEffigy()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkForDTD(URL input, String dtdStart, String dtdEndRegExp) throws IOException {
        InputStream stream = null;
        try {
            stream = input.openStream();
        }
        catch (IOException ex) {
            URL anotherURL = ClassUtilities.jarURLEntryResource(input.toExternalForm());
            if (anotherURL == null) {
                throw ex;
            }
            stream = anotherURL.openStream();
        }
        boolean foundDTD = false;
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(stream));
            for (int lineCount = 0; lineCount < 5; ++lineCount) {
                String contents = reader.readLine();
                if (contents == null) {
                } else {
                    if (dtdEndRegExp == null) continue;
                    if (!contents.startsWith(dtdStart) || !contents.matches(dtdEndRegExp)) continue;
                    foundDTD = true;
                }
                break;
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return foundDTD;
    }

    public Effigy createEffigy(CompositeEntity container) throws Exception {
        return this.createEffigy(container, null, null);
    }

    public Effigy createEffigy(CompositeEntity container, URL base, URL in) throws Exception {
        Effigy effigy = null;
        Iterator factories = this.entityList(EffigyFactory.class).iterator();
        while (factories.hasNext() && effigy == null) {
            EffigyFactory factory = (EffigyFactory)factories.next();
            effigy = factory.createEffigy(container, base, in);
        }
        return effigy;
    }

    public static String getExtension(URL url) {
        String filename = url.getFile();
        int dotIndex = filename.lastIndexOf(".");
        if (dotIndex < 0) {
            return "";
        }
        try {
            int slashIndex = filename.lastIndexOf("/");
            if (slashIndex > 0 && slashIndex > dotIndex) {
                return "";
            }
            return filename.substring(dotIndex + 1);
        }
        catch (IndexOutOfBoundsException ex) {
            return "";
        }
    }
}

