/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.gui;

import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import ptolemy.actor.CompositeActor;
import ptolemy.actor.Director;
import ptolemy.actor.Manager;
import ptolemy.actor.gui.MoMLApplication;
import ptolemy.actor.gui.MoMLSimpleApplication;
import ptolemy.data.expr.Variable;
import ptolemy.kernel.attributes.VersionAttribute;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Settable;
import ptolemy.kernel.util.Workspace;
import ptolemy.moml.MoMLParser;
import ptolemy.moml.StreamErrorHandler;
import ptolemy.util.StringUtilities;

public class MoMLSimpleStatisticalApplication
extends MoMLSimpleApplication {
    protected String[] _commandFlags = new String[]{"-help", "-test", "-version"};
    protected String[][] _commandOptions = new String[][]{{"-class", "<classname>"}, {"-<parameter name>", "<parameter value>"}};
    protected String _commandTemplate = "java -classpath $PTII ptolemy.actor.gui.MoMLSimpleStatisticalApplication [ options ] [file ...]";
    protected MoMLParser _parser;
    protected CompositeActor _toplevel;
    protected static boolean _test = false;
    private boolean _expectingClass = false;
    private List _parameterNames = new LinkedList();
    private List _parameterValues = new LinkedList();

    public MoMLSimpleStatisticalApplication(String[] args) throws Exception {
        this._parser = new MoMLParser();
        MoMLParser.setErrorHandler(new StreamErrorHandler());
        System.gc();
        Thread.sleep(1000L);
        long startTime = System.currentTimeMillis();
        this._parseArgs(args);
        Manager manager = new Manager(this._toplevel.workspace(), "MoMLSimpleStatisticalApplication");
        this._toplevel.setManager(manager);
        this._toplevel.addChangeListener(this);
        Runtime runtime = Runtime.getRuntime();
        long totalMemory1 = runtime.totalMemory() / 1024L;
        long freeMemory1 = runtime.freeMemory() / 1024L;
        String modelName = this._toplevel.getName();
        System.out.println(modelName + ": Stats before execution:    " + Manager.timeAndMemory(startTime, totalMemory1, freeMemory1));
        manager.execute();
        long totalMemory2 = runtime.totalMemory() / 1024L;
        long freeMemory2 = runtime.freeMemory() / 1024L;
        String standardStats = Manager.timeAndMemory(startTime, totalMemory2, freeMemory2);
        System.out.println(modelName + ": Execution stats:           " + standardStats);
        System.gc();
        Thread.sleep(1000L);
        long totalMemory3 = runtime.totalMemory() / 1024L;
        long freeMemory3 = runtime.freeMemory() / 1024L;
        System.out.println(modelName + ": After Garbage Collection:  " + Manager.timeAndMemory(startTime, totalMemory3, freeMemory3));
        System.out.println(modelName + ": construction size:         " + totalMemory1 + "K - " + freeMemory1 + "K = " + (totalMemory1 - freeMemory1) + "K");
        System.out.println(modelName + ": model alloc. while exec. : " + freeMemory1 + "K - " + freeMemory3 + "K = " + (freeMemory1 - freeMemory3) + "K");
        System.out.println(modelName + ": model alloc. runtime data: " + freeMemory3 + "K - " + freeMemory2 + "K = " + (freeMemory3 - freeMemory2) + "K");
        System.out.println(standardStats + " Stat: " + (totalMemory1 - freeMemory1) + "K StatRT: " + (freeMemory1 - freeMemory3) + "K DynRT: " + (freeMemory3 - freeMemory2) + "K");
    }

    protected boolean _parseArg(String arg) throws Exception {
        if (arg.equals("-class")) {
            this._expectingClass = true;
        } else if (arg.equals("-help")) {
            System.out.println(this._usage());
            StringUtilities.exit(0);
        } else if (arg.equals("-test")) {
            _test = true;
        } else if (arg.equals("-version")) {
            System.out.println("Version " + VersionAttribute.CURRENT_VERSION + ", Build $Id: MoMLSimpleStatisticalApplication.java,v 1.38 2007/12/07 06:24:57 cxh Exp $");
            StringUtilities.exit(0);
        } else if (!arg.equals("")) {
            if (this._expectingClass) {
                this._expectingClass = false;
                Class<?> newClass = Class.forName(arg);
                Workspace workspace = new Workspace();
                Class[] argTypes = new Class[]{workspace.getClass()};
                Constructor<?> constructor = newClass.getConstructor(argTypes);
                Object[] args = new Object[]{workspace};
                constructor.newInstance(args);
            } else if (!arg.startsWith("-")) {
                URL inURL;
                URL base = inURL = MoMLApplication.specToURL(arg);
                this._parser.reset();
                long startTime = System.currentTimeMillis();
                this._toplevel = (CompositeActor)this._parser.parse(base, inURL);
                long endTime = System.currentTimeMillis();
                if (endTime - startTime > 10000L) {
                    System.out.println("Opened \"" + base + "\": " + Manager.timeAndMemory(startTime));
                }
            } else {
                return false;
            }
        }
        return true;
    }

    protected void _parseArgs(String[] args) throws Exception {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (this._parseArg(arg)) continue;
            if (arg.trim().startsWith("-")) {
                if (i >= args.length - 1) {
                    throw new IllegalActionException("Cannot set parameter " + arg + " when no value is " + "given.");
                }
                this._parameterNames.add(arg.substring(1));
                this._parameterValues.add(args[i + 1]);
                ++i;
                continue;
            }
            throw new IllegalActionException("Unrecognized option: " + arg);
        }
        if (this._expectingClass) {
            throw new IllegalActionException("Missing classname.");
        }
        Iterator names = this._parameterNames.iterator();
        Iterator values = this._parameterValues.iterator();
        while (names.hasNext() && values.hasNext()) {
            Director director;
            String name = (String)names.next();
            String value = (String)values.next();
            boolean match = false;
            CompositeActor model = this._toplevel;
            System.out.println("model = " + model.getFullName());
            Attribute attribute = ((NamedObj)model).getAttribute(name);
            if (attribute instanceof Settable) {
                match = true;
                ((Settable)((Object)attribute)).setExpression(value);
                if (attribute instanceof Variable) {
                    ((Variable)attribute).getToken();
                }
            }
            if (model instanceof CompositeActor && (director = model.getDirector()) != null && (attribute = director.getAttribute(name)) instanceof Settable) {
                match = true;
                ((Settable)((Object)attribute)).setExpression(value);
                if (attribute instanceof Variable) {
                    ((Variable)attribute).getToken();
                }
            }
            if (match) continue;
            throw new IllegalActionException("Unrecognized option: No parameter exists with name " + name);
        }
    }

    public static void main(String[] args) {
        try {
            new MoMLSimpleStatisticalApplication(args);
        }
        catch (Exception ex) {
            System.err.println("Command failed: " + ex);
            ex.printStackTrace();
        }
    }

    protected String _usage() {
        int i;
        StringBuffer result = new StringBuffer("Usage: " + this._commandTemplate + "\n\n" + "Options that take values:\n");
        for (i = 0; i < this._commandOptions.length; ++i) {
            result.append(" " + this._commandOptions[i][0] + " " + this._commandOptions[i][1] + "\n");
        }
        result.append("\nBoolean flags:\n");
        for (i = 0; i < this._commandFlags.length; ++i) {
            result.append(" " + this._commandFlags[i]);
        }
        return result.toString();
    }
}

