/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.gui;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import ptolemy.actor.gui.Effigy;
import ptolemy.actor.gui.EffigyFactory;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Workspace;
import ptolemy.plot.PlotBox;

public class PlotEffigy
extends Effigy {
    private PlotBox _plot;

    public PlotEffigy(Workspace workspace) {
        super(workspace);
    }

    public PlotEffigy(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
    }

    public PlotBox getPlot() {
        return this._plot;
    }

    public void setPlot(PlotBox plot) {
        this._plot = plot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeFile(File file) throws IOException {
        if (this._plot != null) {
            FileOutputStream stream = null;
            try {
                stream = new FileOutputStream(file);
                this._plot.write(stream);
            }
            finally {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable throwable) {
                        System.out.println("Ignoring failure to close stream on " + file);
                        throwable.printStackTrace();
                    }
                }
            }
        }
    }

    public static class Factory
    extends EffigyFactory {
        public Factory(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
            super(container, name);
        }

        @Override
        public boolean canCreateBlankEffigy() {
            return false;
        }

        @Override
        public Effigy createEffigy(CompositeEntity container, URL base, URL input) throws Exception {
            if (input != null) {
                String extension = Factory.getExtension(input);
                if (extension.equals("xml")) {
                    if (Factory.checkForDTD(input, "<!DOCTYPE plot PUBLIC \"-//UC Berkeley//DTD PlotML", null)) {
                        PlotEffigy effigy = new PlotEffigy(container, container.uniqueName("effigy"));
                        effigy.uri.setURL(input);
                        return effigy;
                    }
                } else if (extension.equals("plt") || extension.equals("plot")) {
                    PlotEffigy effigy = new PlotEffigy(container, container.uniqueName("effigy"));
                    effigy.uri.setURL(input);
                    return effigy;
                }
            }
            return null;
        }
    }
}

