/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.gui;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import ptolemy.actor.TypedCompositeActor;
import ptolemy.actor.gui.Configuration;
import ptolemy.actor.gui.Effigy;
import ptolemy.actor.gui.EffigyFactory;
import ptolemy.actor.gui.ModelDirectory;
import ptolemy.kernel.ComponentEntity;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.attributes.URIAttribute;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.ChangeListener;
import ptolemy.kernel.util.ChangeRequest;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Workspace;
import ptolemy.moml.MoMLParser;
import ptolemy.moml.ParserAttribute;
import ptolemy.util.ClassUtilities;
import ptolemy.util.MessageHandler;
import ptolemy.util.StringUtilities;

public class PtolemyEffigy
extends Effigy
implements ChangeListener {
    private NamedObj _model;

    public PtolemyEffigy(Workspace workspace) {
        super(workspace);
    }

    public PtolemyEffigy(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
    }

    @Override
    public void changeExecuted(ChangeRequest change) {
    }

    @Override
    public void changeFailed(ChangeRequest change, Exception exception) {
        if (change == null) {
            MessageHandler.error("Change failed: ", exception);
        } else if (!change.isErrorReported()) {
            change.setErrorReported(true);
            MessageHandler.error("Change failed: " + change.getDescription(), exception);
        }
    }

    @Override
    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        PtolemyEffigy newObject = (PtolemyEffigy)super.clone(workspace);
        if (this._model != null && !(this._model instanceof Configuration)) {
            newObject._model = (NamedObj)this._model.clone(new Workspace());
        }
        return newObject;
    }

    public NamedObj getModel() {
        return this._model;
    }

    @Override
    public Effigy masterEffigy() {
        if (this._model != null) {
            NamedObj toplevel = this._model.toplevel();
            if (toplevel == this._model) {
                return this;
            }
            Effigy effigyForToplevel = Configuration.findEffigy(toplevel);
            if (effigyForToplevel != null) {
                return effigyForToplevel;
            }
        }
        return super.masterEffigy();
    }

    public void setModel(NamedObj model) {
        if (this._model != null) {
            this._model.toplevel().removeChangeListener(this);
        }
        this._model = model;
        if (model != null) {
            this._model.toplevel().addChangeListener(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeFile(File file) throws IOException {
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(file);
            String name = this.getModel().getName();
            String filename = file.getName();
            int period = filename.indexOf(".");
            name = period > 0 ? filename.substring(0, period) : filename;
            NamedObj model = this.getModel();
            if (model.getContainer() != null) {
                fileWriter.write("<?xml version=\"1.0\" standalone=\"no\"?>\n<!DOCTYPE " + this._elementName + " PUBLIC " + "\"-//UC Berkeley//DTD MoML 1//EN\"\n" + "    \"http://ptolemy.eecs.berkeley.edu" + "/xml/dtd/MoML_1.dtd\">\n");
            }
            model.exportMoML(fileWriter, 0, name);
        }
        finally {
            if (fileWriter != null) {
                fileWriter.close();
            }
        }
    }

    @Override
    protected void _checkContainer(CompositeEntity container) throws IllegalActionException {
        if (container != null && !(container instanceof ModelDirectory) && !(container instanceof PtolemyEffigy)) {
            throw new IllegalActionException((Nameable)this, container, "The container can only be set to an instance of ModelDirectory or PtolemyEffigy.");
        }
    }

    public static class FactoryWithoutNew
    extends Factory {
        public FactoryWithoutNew(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
            super(container, name);
        }

        @Override
        public boolean canCreateBlankEffigy() {
            return false;
        }
    }

    public static class Factory
    extends EffigyFactory {
        public Factory(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
            super(container, name);
        }

        @Override
        public boolean canCreateBlankEffigy() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Effigy createEffigy(CompositeEntity container, URL base, URL input) throws Exception {
            NamedObj toplevel;
            PtolemyEffigy effigy;
            block26: {
                PtolemyEffigy ptolemyEffigy;
                block27: {
                    if (input == null) {
                        NamedObj newModel;
                        PtolemyEffigy effigy2 = this._newEffigy(container, container.uniqueName("effigy"));
                        ComponentEntity entity = this.getEntity("blank");
                        Attribute attribute = this.getAttribute("blank");
                        if (entity != null) {
                            newModel = (NamedObj)((NamedObj)entity).clone(new Workspace());
                            newModel.setDeferringChangeRequests(false);
                        } else if (attribute != null) {
                            newModel = (NamedObj)attribute.clone(new Workspace());
                            newModel.setDeferringChangeRequests(false);
                        } else {
                            newModel = new TypedCompositeActor(new Workspace());
                        }
                        ParserAttribute.getParser(newModel);
                        newModel.setName("");
                        effigy2.setModel(newModel);
                        return effigy2;
                    }
                    String extension = Factory.getExtension(input).toLowerCase();
                    if (!extension.equals("xml") && !extension.equals("moml")) {
                        if (extension.equals("hsif")) {
                            System.out.println("Warning: Could not open up '" + input + "' because it ends with '.hsif'.\n" + "Try running " + "$PTII/bin/vergil -hyvisual " + input);
                        }
                        return null;
                    }
                    if (!Factory.checkForDTD(input, "<!DOCTYPE", ".*PUBLIC \"-//UC Berkeley//DTD MoML.*")) {
                        return null;
                    }
                    effigy = this._newEffigy(container, container.uniqueName("effigy"));
                    MoMLParser parser = new MoMLParser();
                    parser.reset();
                    toplevel = null;
                    long startTime = 0L;
                    long endTime = 0L;
                    try {
                        startTime = System.currentTimeMillis();
                        toplevel = parser.parse(base, input);
                        endTime = System.currentTimeMillis();
                    }
                    catch (IOException io) {
                        URL anotherURL = ClassUtilities.jarURLEntryResource(input.toString());
                        if (anotherURL != null) {
                            startTime = System.currentTimeMillis();
                            toplevel = parser.parse(base, anotherURL);
                            endTime = System.currentTimeMillis();
                        }
                        throw io;
                    }
                    if (toplevel == null) break block26;
                    String entityClassName = StringUtilities.getProperty("entityClassName");
                    if ((entityClassName.length() > 0 || endTime > startTime + 10000L) && toplevel instanceof CompositeEntity) {
                        System.out.println("Opened " + input + " in " + (System.currentTimeMillis() - startTime) + " ms.");
                        System.out.println(((CompositeEntity)toplevel).statistics(entityClassName));
                    }
                    effigy.setModel(toplevel);
                    effigy.setModified(MoMLParser.isModified());
                    MoMLParser.setModified(false);
                    URIAttribute uriAttribute = new URIAttribute(toplevel, "_uri");
                    URI inputURI = null;
                    try {
                        inputURI = new URI(input.toExternalForm());
                    }
                    catch (URISyntaxException ex) {
                        String inputExternalFormFixed = StringUtilities.substitute(input.toExternalForm(), " ", "%20");
                        try {
                            inputURI = new URI(inputExternalFormFixed);
                        }
                        catch (Exception ex2) {
                            throw new Exception("Failed to generate a URI from '" + input.toExternalForm() + "' and from '" + inputExternalFormFixed + "'", ex);
                        }
                    }
                    uriAttribute.setURI(inputURI);
                    effigy.uri.setURI(inputURI);
                    ptolemyEffigy = effigy;
                    if (toplevel != null) break block27;
                    effigy.setContainer(null);
                }
                return ptolemyEffigy;
            }
            try {
                try {
                    effigy.setContainer(null);
                }
                catch (Throwable throwable2) {
                    StackOverflowError throwable2;
                    if (throwable2 instanceof StackOverflowError) {
                        StackOverflowError newThrowable = new StackOverflowError("StackOverflowError: Which often indicates that a class could not be found, but there was possibly a moml file with that same name in the directory that referred to the class, so we got into a loop.For example: We had actor/lib/joystick/Joystick.java and actor/lib/joystick/joystick.xml, but the .class file would not load because of a classpath problem, so we kept loading joystick.xml which referred to Joystick and because of Windows filename case insensitivity, we found joystick.xml, which put us in a loop.");
                        newThrowable.initCause(throwable2);
                        throwable2 = newThrowable;
                    }
                    throwable2.printStackTrace();
                    ModelDirectory dir = (ModelDirectory)effigy.topEffigy().getContainer();
                    List effigies = dir.entityList(Effigy.class);
                    if (effigies.size() <= 3) {
                        String errorMessage = "Failed to read " + input;
                        System.err.println(errorMessage);
                        throwable2.printStackTrace();
                        MessageHandler.error(errorMessage, throwable2);
                    }
                    if (throwable2 instanceof Exception) {
                        throw (Exception)((Object)throwable2);
                    }
                    throw new Exception(throwable2);
                }
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (toplevel == null) {
                    effigy.setContainer(null);
                }
            }
            return null;
        }

        protected PtolemyEffigy _newEffigy(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
            return new PtolemyEffigy(container, name);
        }
    }
}

