/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.gui.style;

import java.io.File;
import java.net.URI;
import ptolemy.actor.gui.PtolemyQuery;
import ptolemy.actor.gui.style.ParameterEditorStyle;
import ptolemy.data.BooleanToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.kernel.attributes.URIAttribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Settable;
import ptolemy.kernel.util.StringAttribute;
import ptolemy.kernel.util.Workspace;

public class FileChooserStyle
extends ParameterEditorStyle {
    public FileChooserStyle() {
    }

    public FileChooserStyle(Workspace workspace) {
        super(workspace);
    }

    public FileChooserStyle(NamedObj container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
    }

    @Override
    public boolean acceptable(Settable param) {
        return param instanceof StringAttribute;
    }

    @Override
    public void addEntry(PtolemyQuery query) throws IllegalActionException {
        Settable container = (Settable)((Object)this.getContainer());
        String name = container.getName();
        String defaultValue = container.getExpression();
        defaultValue = container.getExpression();
        URI modelURI = URIAttribute.getModelURI(this);
        File directory = null;
        if (modelURI != null && modelURI.getScheme().equals("file")) {
            File modelFile = new File(modelURI);
            directory = modelFile.getParentFile();
        }
        boolean allowFiles = true;
        boolean allowDirectories = false;
        if (container instanceof NamedObj) {
            Token value;
            Parameter marker = (Parameter)((NamedObj)((Object)container)).getAttribute("allowFiles", Parameter.class);
            if (marker != null && (value = marker.getToken()) instanceof BooleanToken) {
                allowFiles = ((BooleanToken)value).booleanValue();
            }
            if ((marker = (Parameter)((NamedObj)((Object)container)).getAttribute("allowDirectories", Parameter.class)) != null && (value = marker.getToken()) instanceof BooleanToken) {
                allowDirectories = ((BooleanToken)value).booleanValue();
            }
        }
        if (!allowFiles && !allowDirectories) {
            return;
        }
        query.addFileChooser(name, container.getDisplayName(), defaultValue, modelURI, directory, allowFiles, allowDirectories, PtolemyQuery.preferredBackgroundColor(container), PtolemyQuery.preferredForegroundColor(container));
        query.attachParameter(container, name);
    }
}

