/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib;

import ptolemy.actor.TypedAtomicActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.data.IntToken;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;

public class Counter
extends TypedAtomicActor {
    public TypedIOPort increment = new TypedIOPort(this, "increment", true, false);
    public TypedIOPort decrement;
    public TypedIOPort output;
    private int _count = 0;
    private int _latestCount = 0;
    private boolean _consumed;

    public Counter(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.increment.setTypeEquals(BaseType.GENERAL);
        this.decrement = new TypedIOPort(this, "decrement", true, false);
        this.decrement.setTypeEquals(BaseType.GENERAL);
        this.output = new TypedIOPort(this, "output", false, true);
        this.output.setTypeEquals(BaseType.INT);
    }

    @Override
    public void fire() throws IllegalActionException {
        int i;
        super.fire();
        this._latestCount = this._count;
        this._consumed = false;
        for (i = 0; i < this.increment.getWidth(); ++i) {
            if (!this.increment.hasToken(i)) continue;
            this.increment.get(i);
            ++this._latestCount;
            this._consumed = true;
        }
        for (i = 0; i < this.decrement.getWidth(); ++i) {
            if (!this.decrement.hasToken(i)) continue;
            this.decrement.get(i);
            --this._latestCount;
            this._consumed = true;
        }
        if (this._consumed) {
            IntToken out = new IntToken(this._latestCount);
            this.output.send(0, out);
        }
    }

    @Override
    public void initialize() throws IllegalActionException {
        super.initialize();
        this._count = 0;
    }

    @Override
    public boolean postfire() throws IllegalActionException {
        this._count = this._latestCount;
        return super.postfire();
    }
}

