/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib;

import ptolemy.actor.lib.SequenceSource;
import ptolemy.data.ArrayToken;
import ptolemy.data.DoubleToken;
import ptolemy.data.IntToken;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.ArrayType;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.math.Interpolation;

public class Interpolator
extends SequenceSource {
    public Parameter indexes;
    public Parameter order;
    public Parameter period;
    public Parameter values;
    private transient int[] _indexes;
    private int _iterationCount = 0;
    private Interpolation _interpolation = new Interpolation();
    private transient double[] _values;

    public Interpolator(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.indexes = new Parameter(this, "indexes");
        this.indexes.setExpression("{0, 1}");
        this.indexes.setTypeEquals(new ArrayType(BaseType.INT));
        this.attributeChanged(this.indexes);
        this.values = new Parameter(this, "values");
        this.values.setExpression("{1.0, 0.0}");
        this.values.setTypeEquals(new ArrayType(BaseType.DOUBLE));
        int defOrder = this._interpolation.getOrder();
        IntToken defOrderToken = new IntToken(defOrder);
        this.order = new Parameter((NamedObj)this, "order", defOrderToken);
        this.order.setTypeEquals(BaseType.INT);
        int defPeriod = this._interpolation.getPeriod();
        IntToken defPeriodToken = new IntToken(defPeriod);
        this.period = new Parameter((NamedObj)this, "period", defPeriodToken);
        this.period.setTypeEquals(BaseType.INT);
        this.output.setTypeEquals(BaseType.DOUBLE);
    }

    @Override
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.values) {
            ArrayToken valuesValue = (ArrayToken)this.values.getToken();
            this._values = new double[valuesValue.length()];
            for (int i = 0; i < valuesValue.length(); ++i) {
                this._values[i] = ((DoubleToken)valuesValue.getElement(i)).doubleValue();
            }
            this._interpolation.setValues(this._values);
        } else if (attribute == this.indexes) {
            ArrayToken indexesValue = (ArrayToken)this.indexes.getToken();
            this._indexes = new int[indexesValue.length()];
            int previous = 0;
            for (int i = 0; i < indexesValue.length(); ++i) {
                this._indexes[i] = ((IntToken)indexesValue.getElement(i)).intValue();
                if (this._indexes[i] < previous) {
                    throw new IllegalActionException((Nameable)this, "Value of indexes is not nondecreasing and nonnegative.");
                }
                previous = this._indexes[i];
            }
            this._interpolation.setIndexes(this._indexes);
        } else if (attribute == this.period) {
            int newPeriod = ((IntToken)this.period.getToken()).intValue();
            this._interpolation.setPeriod(newPeriod);
        } else if (attribute == this.order) {
            int newOrder = ((IntToken)this.order.getToken()).intValue();
            this._interpolation.setOrder(newOrder);
        } else {
            super.attributeChanged(attribute);
        }
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        double result = this._interpolation.interpolate(this._iterationCount);
        this.output.send(0, new DoubleToken(result));
    }

    @Override
    public void initialize() throws IllegalActionException {
        super.initialize();
        this._iterationCount = 0;
    }

    @Override
    public boolean postfire() throws IllegalActionException {
        ++this._iterationCount;
        return super.postfire();
    }
}

