/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib;

import java.util.ArrayList;
import ptolemy.actor.lib.NonStrictTest;
import ptolemy.actor.lib.PublisherNonStrictTest;
import ptolemy.data.ArrayToken;
import ptolemy.data.BooleanToken;
import ptolemy.data.RecordToken;
import ptolemy.data.Token;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;

public class PublisherTest
extends PublisherNonStrictTest {
    public PublisherTest(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.input.setMultiport(true);
    }

    @Override
    public void fire() throws IllegalActionException {
        Token[] reference;
        super.fire();
        int width = this.input.getWidth();
        boolean training = ((BooleanToken)this.trainingMode.getToken()).booleanValue();
        if (training) {
            if (this._trainingTokens == null) {
                this._trainingTokens = new ArrayList();
            }
            System.out.println("PublisherTest: width: " + width + " " + this.input.hasToken(0));
            if (width == 1) {
                if (this.input.hasToken(0)) {
                    Token token = this.input.get(0);
                    this.output.send(0, token);
                    if (token instanceof ArrayToken) {
                        Token[] innerArrayToken = new Token[]{token};
                        this._trainingTokens.add(innerArrayToken);
                    } else {
                        this._trainingTokens.add(token);
                    }
                }
            } else {
                ArrayList<Token> arrayList = new ArrayList<Token>();
                for (int i = 0; i < width; ++i) {
                    if (!this.input.hasToken(i)) continue;
                    Token token = this.input.get(i);
                    arrayList.add(token);
                    this.output.send(i, token);
                }
                this._trainingTokens.add(arrayList);
            }
            return;
        }
        if (this._numberOfInputTokensSeen >= ((ArrayToken)this.correctValues.getToken()).length()) {
            for (int i = 0; i < width; ++i) {
                if (!this.input.hasToken(i)) continue;
                Token token = this.input.get(i);
                this.output.send(i, token);
            }
            this.output.send(0, new BooleanToken(true));
            return;
        }
        Token referenceToken = ((ArrayToken)this.correctValues.getToken()).getElement(this._numberOfInputTokensSeen);
        if (width == 1 && !(referenceToken instanceof ArrayToken)) {
            reference = new Token[]{referenceToken};
        } else {
            try {
                reference = ((ArrayToken)referenceToken).arrayValue();
            }
            catch (ClassCastException ex) {
                throw new IllegalActionException((Nameable)this, "Test fails in iteration " + this._numberOfInputTokensSeen + ".\n" + "Width of input is " + width + ", but correctValues parameter " + "is not an array " + "of arrays.");
            }
            if (width != reference.length) {
                throw new IllegalActionException((Nameable)this, "Test fails in iteration " + this._numberOfInputTokensSeen + ".\n" + "Width of input is " + width + ", which does not match " + "the  width of the " + this._numberOfInputTokensSeen + "-th element of" + " correctValues, " + reference.length);
            }
        }
        for (int i = 0; i < width; ++i) {
            boolean isClose;
            if (!this.input.hasToken(i)) {
                throw new IllegalActionException((Nameable)this, "Test fails in iteration " + this._numberOfInputTokensSeen + ".\n" + "Empty input on channel " + i);
            }
            Token token = this.input.get(i);
            try {
                boolean bl = isClose = token.isCloseTo(reference[i], this._tolerance).booleanValue() || token.isNil() && reference[i].isNil();
                if (token instanceof ArrayToken && reference[i] instanceof ArrayToken) {
                    isClose |= NonStrictTest._isCloseToIfNilArrayElement(token, reference[i], this._tolerance);
                }
                if (token instanceof RecordToken && reference[i] instanceof RecordToken) {
                    isClose |= NonStrictTest._isCloseToIfNilRecordElement(token, reference[i], this._tolerance);
                }
            }
            catch (IllegalActionException ex) {
                throw new IllegalActionException((Nameable)this, ex, "Test fails in iteration " + this._numberOfInputTokensSeen + ".\n" + "Value was: " + token + ". Should have been: " + reference[i]);
            }
            if (!isClose) {
                throw new IllegalActionException((Nameable)this, "Test fails in iteration " + this._numberOfInputTokensSeen + ".\n" + "Value was: " + token + ". Should have been: " + reference[i]);
            }
            this.output.send(i, token);
        }
        ++this._numberOfInputTokensSeen;
    }

    @Override
    public boolean postfire() {
        return true;
    }
}

