/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.StringTokenizer;
import ptolemy.actor.lib.Source;
import ptolemy.data.BooleanToken;
import ptolemy.data.DoubleToken;
import ptolemy.data.StringToken;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;

public class Reader
extends Source {
    public Parameter sourceURL;
    public Parameter refresh;
    private BufferedReader _reader = null;
    private static BufferedReader _stdIn = null;
    private String _source;
    private double[] _data;
    private int _dataSize;

    public Reader(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.output.setMultiport(true);
        this.output.setTypeEquals(BaseType.DOUBLE);
        this.sourceURL = new Parameter((NamedObj)this, "sourceURL", new StringToken(""));
        this.sourceURL.setTypeEquals(BaseType.STRING);
        this.refresh = new Parameter((NamedObj)this, "refresh", new BooleanToken(false));
        this.refresh.setTypeEquals(BaseType.BOOLEAN);
        if (_stdIn == null) {
            _stdIn = new BufferedReader(new InputStreamReader(System.in));
        }
        this.setReader(_stdIn);
    }

    @Override
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.sourceURL) {
            try {
                StringToken URLToken = (StringToken)this.sourceURL.getToken();
                if (URLToken == null) {
                    this._source = null;
                    this.setReader(null);
                } else {
                    this._source = URLToken.stringValue();
                    if (this._source.equals("")) {
                        this.setReader(null);
                    } else {
                        URL url = new URL(this._source);
                        BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
                        this.setReader(reader);
                    }
                }
            }
            catch (IOException ex) {
                throw new IllegalActionException((Nameable)this, ex, "attributeChanged(" + attribute + ") failed");
            }
        }
        super.attributeChanged(attribute);
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        for (int i = 0; i < this._dataSize; ++i) {
            this.output.send(i, new DoubleToken(this._data[i]));
        }
    }

    @Override
    public void initialize() throws IllegalActionException {
        System.out.println("actor.lib.Reader is obsolete, use actor.lib.io.ExpressionReader instead");
        this._dataSize = this.output.getWidth();
        this._data = new double[this._dataSize];
        this.attributeChanged(this.sourceURL);
    }

    @Override
    public boolean prefire() throws IllegalActionException {
        try {
            String oneRow;
            this._dataSize = this.output.getWidth();
            if (this._data.length != this._dataSize) {
                this._data = new double[this._dataSize];
            }
            if ((oneRow = this._reader.readLine()) == null) {
                return false;
            }
            StringTokenizer tokenizer = new StringTokenizer(oneRow);
            int columnCount = tokenizer.countTokens();
            if (this._dataSize > columnCount) {
                this._dataSize = columnCount;
            }
            for (int i = 0; i < this._dataSize; ++i) {
                this._data[i] = Double.valueOf(tokenizer.nextToken());
            }
            return super.prefire();
        }
        catch (IOException ex) {
            throw new IllegalActionException((Nameable)this, ex, "prefire() failed");
        }
    }

    public void setReader(BufferedReader reader) throws IllegalActionException {
        try {
            if (this._reader != null && this._reader != _stdIn) {
                this._reader.close();
            }
        }
        catch (IOException ex) {
            throw new IllegalActionException((Nameable)this, ex, "setReader(" + reader + ") failed");
        }
        this._reader = reader != null ? reader : _stdIn;
    }

    @Override
    public void wrapup() throws IllegalActionException {
        try {
            if (this._reader != null && this._reader != _stdIn) {
                this._reader.close();
            }
        }
        catch (IOException ex) {
            throw new IllegalActionException((Nameable)this, ex, "wrapup(" + this._reader + ") failed");
        }
    }
}

