/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib;

import ptolemy.actor.TypedIOPort;
import ptolemy.actor.lib.Source;
import ptolemy.data.DoubleToken;
import ptolemy.data.Token;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Workspace;

public class WallClockTime
extends Source {
    public TypedIOPort passThrough;
    private long _startTime;

    public WallClockTime(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.output.setTypeEquals(BaseType.DOUBLE);
        this.passThrough = new TypedIOPort(this, "passThrough", false, true);
        this.passThrough.setTypeAtLeast(this.trigger);
        this.passThrough.setMultiport(true);
    }

    @Override
    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        WallClockTime newObject = (WallClockTime)super.clone(workspace);
        newObject.passThrough.setTypeAtLeast(newObject.trigger);
        return newObject;
    }

    @Override
    public void fire() throws IllegalActionException {
        if (this._debugging) {
            this._debug("Called fire()");
        }
        this.output.broadcast(new DoubleToken(this._getCurrentTime()));
        for (int i = 0; i < this.trigger.getWidth(); ++i) {
            if (!this.trigger.hasToken(i)) continue;
            Token token = this.trigger.get(i);
            if (i >= this.passThrough.getWidth()) continue;
            this.passThrough.send(i, token);
        }
    }

    @Override
    public void initialize() throws IllegalActionException {
        super.initialize();
        this._startTime = System.currentTimeMillis();
    }

    protected double _getCurrentTime() {
        long elapsedTime = System.currentTimeMillis() - this._startTime;
        return (double)elapsedTime / 1000.0;
    }
}

