/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.LinkedList;
import javax.swing.SwingUtilities;
import ptolemy.actor.TypedIOPort;
import ptolemy.actor.gui.AbstractPlaceableActor;
import ptolemy.actor.gui.Configuration;
import ptolemy.actor.gui.Effigy;
import ptolemy.actor.gui.MatrixPane;
import ptolemy.actor.gui.MatrixTokenTableau;
import ptolemy.actor.gui.TableauFrame;
import ptolemy.actor.gui.TokenEffigy;
import ptolemy.actor.gui.TokenTableau;
import ptolemy.data.IntToken;
import ptolemy.data.MatrixToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.KernelException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Workspace;

public class MatrixViewer
extends AbstractPlaceableActor {
    public TypedIOPort input = new TypedIOPort(this, "input", true, false);
    public Parameter width;
    public Parameter height;
    private Container _container = null;
    private TokenEffigy _effigy;
    private int _height;
    private MatrixPane _pane = null;
    private TokenTableau _tableau;
    private int _width;

    public MatrixViewer(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.input.setTypeEquals(BaseType.MATRIX);
        this.width = new Parameter((NamedObj)this, "width", new IntToken(500));
        this.width.setTypeEquals(BaseType.INT);
        this.height = new Parameter((NamedObj)this, "height", new IntToken(300));
        this.height.setTypeEquals(BaseType.INT);
    }

    @Override
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.width) {
            this._width = ((IntToken)this.width.getToken()).intValue();
        } else if (attribute == this.height) {
            this._height = ((IntToken)this.height.getToken()).intValue();
        } else {
            super.attributeChanged(attribute);
        }
    }

    @Override
    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        MatrixViewer newObject = (MatrixViewer)super.clone(workspace);
        newObject._container = null;
        newObject._effigy = null;
        newObject._frame = null;
        newObject._pane = null;
        newObject._tableau = null;
        return newObject;
    }

    @Override
    public void initialize() throws IllegalActionException {
        super.initialize();
        if (this._container == null) {
            if (this._tableau == null) {
                Effigy containerEffigy = Configuration.findEffigy(this.toplevel());
                if (containerEffigy == null) {
                    throw new IllegalActionException((Nameable)this, "Cannot find effigy for top level: " + this.toplevel().getFullName());
                }
                try {
                    this._effigy = new TokenEffigy(containerEffigy, containerEffigy.uniqueName("tokenEffigy"));
                    this._effigy.identifier.setExpression(this.getFullName());
                    this._frame = new TableauFrame(null, null, this);
                    this._tableau = new MatrixTokenTableau(this._effigy, "tokenTableau", (TableauFrame)this._frame);
                    ((TableauFrame)this._frame).setTableau(this._tableau);
                    this.setFrame(this._frame);
                    this._tableau.show();
                }
                catch (Exception ex) {
                    throw new IllegalActionException(this, null, ex, "Error creating effigy and tableau");
                }
            } else {
                this._effigy.clear();
                if (this._frame != null) {
                    this._frame.toFront();
                }
            }
        }
    }

    @Override
    public void place(Container container) {
        if (this._container != null && this._pane != null) {
            this._container.remove(this._pane);
            this._container = null;
        }
        if (this._frame != null) {
            this._frame.dispose();
            this._frame = null;
        }
        this._container = container;
        if (container == null) {
            if (this._tableau != null) {
                try {
                    this._tableau.setContainer(null);
                }
                catch (KernelException ex) {
                    throw new InternalErrorException(ex);
                }
            }
            this._tableau = null;
            this._effigy = null;
            this._pane = null;
            return;
        }
        if (this._pane == null) {
            this._pane = new MatrixPane();
            Dimension size = new Dimension(this._width, this._height);
            this._pane.setPreferredSize(size);
            this._pane.setSize(size);
        }
        this._container.add((Component)this._pane, "Center");
    }

    @Override
    public boolean postfire() throws IllegalActionException {
        if (this.input.hasToken(0)) {
            Token in = this.input.get(0);
            if (this._frame != null) {
                LinkedList<Token> tokens = new LinkedList<Token>();
                tokens.add(in);
                this._effigy.setTokens(tokens);
            } else if (this._pane != null) {
                this._pane.display((MatrixToken)in);
            }
        }
        return super.postfire();
    }

    @Override
    public void setContainer(CompositeEntity container) throws IllegalActionException, NameDuplicationException {
        super.setContainer(container);
        if (container == null) {
            this._remove();
        }
    }

    private void _remove() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (MatrixViewer.this._container != null && MatrixViewer.this._pane != null) {
                    MatrixViewer.this._container.remove(MatrixViewer.this._pane);
                    MatrixViewer.this._container = null;
                }
                if (MatrixViewer.this._frame != null) {
                    MatrixViewer.this._frame.dispose();
                    MatrixViewer.this._frame = null;
                }
            }
        });
    }
}

