/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.gui;

import ptolemy.actor.lib.gui.SequencePlotter;
import ptolemy.data.IntToken;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.plot.Plot;

public class SequenceScope
extends SequencePlotter {
    public Parameter width = new Parameter((NamedObj)this, "width", new IntToken(10));
    public Parameter persistence;

    public SequenceScope(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.width.setTypeEquals(BaseType.INT);
        this.persistence = new Parameter((NamedObj)this, "persistence", new IntToken(10));
        this.persistence.setTypeEquals(BaseType.INT);
    }

    @Override
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if ((attribute == this.width || attribute == this.xUnit || attribute == this.xInit) && this.plot != null) {
            super.attributeChanged(attribute);
            int widthValue = ((IntToken)this.width.getToken()).intValue();
            this.plot.setXRange(this._xInit, this._xUnit * (double)widthValue + this._xInit);
        } else if (attribute == this.persistence && this.plot != null) {
            int persValue = ((IntToken)this.persistence.getToken()).intValue();
            ((Plot)this.plot).setPointsPersistence(persValue);
        } else {
            super.attributeChanged(attribute);
        }
    }

    @Override
    public void initialize() throws IllegalActionException {
        super.initialize();
        int widthValue = ((IntToken)this.width.getToken()).intValue();
        this.plot.setXRange(this._xInit, this._xUnit * (double)widthValue + this._xInit);
        this.plot.setWrap(true);
        int persValue = ((IntToken)this.persistence.getToken()).intValue();
        ((Plot)this.plot).setPointsPersistence(persValue);
        if (((Plot)this.plot).getMarksStyle().equals("none")) {
            ((Plot)this.plot).setMarksStyle("pixels");
        }
        this.plot.repaint();
    }

    @Override
    public boolean postfire() throws IllegalActionException {
        boolean result = super.postfire();
        Thread.yield();
        return result;
    }
}

