/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.hoc;

import java.util.Iterator;
import ptolemy.actor.Actor;
import ptolemy.actor.Director;
import ptolemy.actor.IOPort;
import ptolemy.actor.Mailbox;
import ptolemy.actor.NoRoomException;
import ptolemy.actor.NoTokenException;
import ptolemy.actor.Receiver;
import ptolemy.actor.lib.hoc.Case;
import ptolemy.actor.lib.hoc.Refinement;
import ptolemy.actor.parameters.ParameterPort;
import ptolemy.actor.parameters.PortParameter;
import ptolemy.actor.util.Time;
import ptolemy.data.Token;
import ptolemy.kernel.ComponentEntity;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;

public class CaseDirector
extends Director {
    public CaseDirector(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
    }

    @Override
    public void fireAt(Actor actor, Time time) throws IllegalActionException {
        NamedObj container = this.getContainer();
        if (container instanceof Actor) {
            Actor modalModel = (Actor)((Object)container);
            Director executiveDirector = modalModel.getExecutiveDirector();
            if (executiveDirector != null) {
                executiveDirector.fireAt(modalModel, time);
            } else {
                this.setModelTime(time);
            }
        }
    }

    @Override
    public void fire() throws IllegalActionException {
        if (this._debugging) {
            this._debug("Calling fire()");
        }
        Case container = (Case)this.getContainer();
        if (container._current == null) {
            throw new IllegalActionException((Nameable)container, "Has no current refinement");
        }
        container._current.fire();
        if (this._debugging) {
            this._debug("Called fire()");
        }
    }

    @Override
    public Receiver newReceiver() {
        return new Mailbox(){

            @Override
            public boolean hasRoom() {
                return true;
            }

            @Override
            public void put(Token token) {
                try {
                    if (this.hasToken()) {
                        this.get();
                    }
                    super.put(token);
                }
                catch (NoRoomException ex) {
                    throw new InternalErrorException("One-place buffer: " + ex.getMessage());
                }
                catch (NoTokenException ex) {
                    throw new InternalErrorException("One-place buffer: " + ex.getMessage());
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean prefire() throws IllegalActionException {
        if (this._debugging) {
            this._debug("Calling prefire()");
        }
        try {
            this._workspace.getReadAccess();
            super.prefire();
            Case container = (Case)this.getContainer();
            for (PortParameter portParameter : container.attributeList(PortParameter.class)) {
                portParameter.update();
            }
            String controlValue = container.control.getToken().toString();
            ComponentEntity refinement = container.getEntity(controlValue);
            if (!(refinement instanceof Refinement)) {
                refinement = container._default;
            }
            container._current = (Refinement)refinement;
            Iterator inputPorts = container.inputPortList().iterator();
            while (inputPorts.hasNext() && !this._stopRequested) {
                IOPort port = (IOPort)inputPorts.next();
                if (port instanceof ParameterPort) continue;
                Receiver[][] insideReceivers = port.deepGetReceivers();
                for (int i = 0; i < port.getWidth(); ++i) {
                    if (!port.hasToken(i)) continue;
                    Token token = port.get(i);
                    if (insideReceivers == null || insideReceivers[i] == null) continue;
                    for (int j = 0; j < insideReceivers[i].length; ++j) {
                        if (insideReceivers[i][j].getContainer().getContainer() != refinement) continue;
                        insideReceivers[i][j].put(token);
                        if (!this._debugging) continue;
                        this._debug(this.getFullName(), "transferring input from " + port.getFullName() + " to " + insideReceivers[i][j].getContainer().getFullName());
                    }
                }
            }
            if (this._stopRequested) {
                boolean bl = false;
                return bl;
            }
            boolean bl = container._current.prefire();
            return bl;
        }
        finally {
            this._workspace.doneReading();
        }
    }

    @Override
    public boolean postfire() throws IllegalActionException {
        if (this._debugging) {
            this._debug("Calling postfire()");
        }
        Case container = (Case)this.getContainer();
        return container._current.postfire();
    }
}

