/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.hoc;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import ptolemy.actor.IOPort;
import ptolemy.actor.TypedCompositeActor;
import ptolemy.actor.parameters.ParameterPort;
import ptolemy.actor.parameters.PortParameter;
import ptolemy.data.StringToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Variable;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.ChangeRequest;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Settable;
import ptolemy.kernel.util.Workspace;

public class LifeCycleManager
extends TypedCompositeActor {
    public LifeCycleManager() {
    }

    public LifeCycleManager(Workspace workspace) {
        super(workspace);
    }

    public LifeCycleManager(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeChangeRequests() {
        Object object = this._changeLock;
        synchronized (object) {
            if (this._changeRequests != null && this._changeRequests.size() > 0) {
                LinkedList copy = new LinkedList(this._changeRequests);
                this._changeRequests.clear();
                Iterator requests = copy.iterator();
                boolean previousDeferStatus = this.isDeferringChangeRequests();
                try {
                    this._workspace.getWriteAccess();
                    previousDeferStatus = this.setDeferringChangeRequests(true);
                    while (requests.hasNext()) {
                        ChangeRequest change = (ChangeRequest)requests.next();
                        change.setListeners(this._changeListeners);
                        if (this._debugging) {
                            this._debug("-- Executing change request with description: " + change.getDescription());
                        }
                        LinkedList changeListeners = new LinkedList();
                        for (NamedObj container = this.getContainer(); container != null; container = container.getContainer()) {
                            List list = container.getChangeListeners();
                            if (list == null) continue;
                            changeListeners.addAll(list);
                        }
                        change.setListeners(changeListeners);
                        change.execute();
                    }
                }
                finally {
                    this._workspace.doneWriting();
                    this.setDeferringChangeRequests(previousDeferStatus);
                }
                this.executeChangeRequests();
            }
        }
    }

    @Override
    public boolean isOpaque() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestChange(ChangeRequest change) {
        Object object = this._changeLock;
        synchronized (object) {
            if (this._changeRequests == null) {
                this._changeRequests = new LinkedList();
            }
            this._changeRequests.add(change);
            if (!this.isDeferringChangeRequests()) {
                this.executeChangeRequests();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int _executeInsideModel() throws IllegalActionException {
        try {
            this.setDeferringChangeRequests(true);
            this._readInputs();
            if (this._stopRequested) {
                int n = 0;
                return n;
            }
            super.initialize();
            this._debug("-- Beginning to iterate.");
            int lastIterateResult = 0;
            while (!this._stopRequested) {
                this.executeChangeRequests();
                if (super.prefire()) {
                    this._fireInsideModel();
                    if (super.postfire()) continue;
                    lastIterateResult = 2;
                    break;
                }
                lastIterateResult = 1;
                break;
            }
            int n = lastIterateResult;
            return n;
        }
        finally {
            try {
                this.executeChangeRequests();
                super.wrapup();
            }
            finally {
                this.setDeferringChangeRequests(false);
            }
            if (!this._stopRequested) {
                this._writeOutputs();
            }
            if (this._debugging) {
                this._debug("---- Firing is complete.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _fireInsideModel() throws IllegalActionException {
        if (this._debugging) {
            this._debug("Firing the inside model.");
        }
        try {
            this._workspace.getReadAccess();
            if (!this._stopRequested) {
                this.getDirector().fire();
            }
        }
        finally {
            this._workspace.doneReading();
        }
        if (this._debugging) {
            this._debug("Done firing inside model.");
        }
    }

    protected void _readInputs() throws IllegalActionException {
        if (this._debugging) {
            this._debug("** Reading inputs (if any).");
        }
        for (IOPort port : this.inputPortList()) {
            if (port instanceof ParameterPort) {
                PortParameter parameter = ((ParameterPort)port).getParameter();
                if (this._debugging) {
                    this._debug("** Updating PortParameter: " + port.getName());
                }
                parameter.update();
                continue;
            }
            if (port.getWidth() <= 0 || !port.hasToken(0)) continue;
            Token token = port.get(0);
            Attribute attribute = this.getAttribute(port.getName());
            if (attribute instanceof Variable) {
                if (this._debugging) {
                    this._debug("** Transferring input to parameter: " + port.getName());
                }
                ((Variable)attribute).setToken(token);
                continue;
            }
            if (!(attribute instanceof Settable)) continue;
            if (this._debugging) {
                this._debug("** Transferring input as string to parameter: " + port.getName());
            }
            ((Settable)((Object)attribute)).setExpression(token.toString());
        }
    }

    protected void _writeOutputs() throws IllegalActionException {
        if (this._debugging) {
            this._debug("** Writing outputs (if any).");
        }
        for (IOPort port : this.outputPortList()) {
            if (port.getWidth() <= 0) continue;
            Attribute attribute = this.getAttribute(port.getName());
            if (attribute instanceof Variable) {
                if (this._debugging) {
                    this._debug("** Transferring parameter to output: " + port.getName());
                }
                port.send(0, ((Variable)attribute).getToken());
                continue;
            }
            if (!(attribute instanceof Settable)) continue;
            if (this._debugging) {
                this._debug("** Transferring parameter as string to output: " + port.getName());
            }
            port.send(0, new StringToken(((Settable)((Object)attribute)).getExpression()));
        }
    }
}

