/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.hoc;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import ptolemy.actor.Actor;
import ptolemy.actor.Director;
import ptolemy.actor.IOPort;
import ptolemy.actor.NoTokenException;
import ptolemy.actor.QueueReceiver;
import ptolemy.actor.Receiver;
import ptolemy.actor.lib.hoc.MirrorComposite;
import ptolemy.actor.util.Time;
import ptolemy.data.DoubleToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.ComponentEntity;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.Settable;
import ptolemy.util.MessageHandler;

public class RealTimeComposite
extends MirrorComposite {
    public Parameter delay;
    private double _delayValue = 0.0;
    private List<Time> _fireAtTimes = Collections.synchronizedList(new LinkedList());
    private DelayQueue<InputFrame> _inputFrames = new DelayQueue();
    private List<OutputFrame> _outputFrames = Collections.synchronizedList(new LinkedList());
    private long _realStartTime = 0L;
    private Queue<Time> _responseTimes = new LinkedList<Time>();

    public RealTimeComposite(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.setClassName("ptolemy.actor.lib.hoc.RealTimeComposite");
        new RealTimeDirector(this, "RealTimeDirector");
        Parameter UNDEFINED = new Parameter(this, "UNDEFINED");
        UNDEFINED.setVisibility(Settable.EXPERT);
        UNDEFINED.setPersistent(false);
        UNDEFINED.setExpression("-1.0");
        this.delay = new Parameter(this, "delay");
        this.delay.setTypeEquals(BaseType.DOUBLE);
        this.delay.setExpression("UNDEFINED");
    }

    @Override
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.delay) {
            this._delayValue = ((DoubleToken)this.delay.getToken()).doubleValue();
        } else {
            super.attributeChanged(attribute);
        }
    }

    public boolean fireContainedActors() throws IllegalActionException {
        Iterator actors = this.entityList().iterator();
        boolean postfireReturns = true;
        block0: while (actors.hasNext() && !this._stopRequested) {
            Actor actor = (Actor)actors.next();
            if (!((ComponentEntity)((Object)actor)).isOpaque()) {
                throw new IllegalActionException((Nameable)this, "Inside actor is not opaque (perhaps it needs a director).");
            }
            int result = 0;
            while (result != 1) {
                if (this._debugging) {
                    this._debug("Iterating actor: " + actor.getFullName());
                }
                if (this._debugging) {
                    this._debug("---- Iterating actor in associated thread: " + actor.getFullName());
                }
                result = actor.iterate(1);
                boolean outOfData = true;
                block2: for (IOPort port : actor.inputPortList()) {
                    for (int i = 0; i < port.getWidth(); ++i) {
                        if (!port.hasToken(i)) continue;
                        outOfData = false;
                        continue block2;
                    }
                }
                if (outOfData) continue block0;
                if (result != 2) continue;
                if (this._debugging) {
                    this._debug("---- Actor requests halt: " + actor.getFullName());
                }
                postfireReturns = false;
                continue block0;
            }
        }
        return postfireReturns;
    }

    private class RealTimeDirector
    extends Director {
        private List<QueuedToken> _inputTokens;
        private Thread _thread;

        public RealTimeDirector(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
            super(container, name);
            this.setPersistent(false);
        }

        @Override
        public void fire() throws IllegalActionException {
            if (RealTimeComposite.this._realStartTime < 0L) {
                RealTimeComposite.this._realStartTime = System.currentTimeMillis();
            }
            Time environmentTime = RealTimeComposite.this.getExecutiveDirector().getModelTime();
            if (RealTimeComposite.this._delayValue == 0.0) {
                long modelTimeMillis;
                long realTimeMillis = System.currentTimeMillis() - RealTimeComposite.this._realStartTime;
                if (realTimeMillis < (modelTimeMillis = Math.round(environmentTime.getDoubleValue() * 1000.0))) {
                    try {
                        Thread.sleep(modelTimeMillis - realTimeMillis);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                super.fire();
            } else {
                Time responseTime;
                if (RealTimeComposite.this._delayValue > 0.0 && (responseTime = (Time)RealTimeComposite.this._responseTimes.peek()) != null && responseTime.equals(environmentTime)) {
                    RealTimeComposite.this._responseTimes.poll();
                    long realTimeMillis = System.currentTimeMillis() - RealTimeComposite.this._realStartTime;
                    long modelTimeMillis = Math.round(environmentTime.getDoubleValue() * 1000.0);
                    if (realTimeMillis < modelTimeMillis) {
                        try {
                            Thread.sleep(modelTimeMillis - realTimeMillis);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                    }
                }
                if (RealTimeComposite.this._outputFrames.size() > 0) {
                    OutputFrame frame = (OutputFrame)RealTimeComposite.this._outputFrames.get(0);
                    if (frame.time.equals(environmentTime)) {
                        for (QueuedToken token : frame.tokens) {
                            if (token.channel >= token.port.getWidth()) continue;
                            token.port.send(token.channel, token.token);
                        }
                    }
                }
                Thread.yield();
            }
        }

        @Override
        public void fireAt(Actor actor, Time time) throws IllegalActionException {
            Director director = RealTimeComposite.this.getExecutiveDirector();
            if (director != null) {
                if (RealTimeComposite.this._debugging) {
                    RealTimeComposite.this._debug("---- Actor requests firing at time " + time + ": " + actor.getFullName());
                }
                director.fireAt((Actor)RealTimeComposite.this, time);
            }
            if (actor != RealTimeComposite.this) {
                RealTimeComposite.this._fireAtTimes.add(time);
            }
        }

        @Override
        public void fireAtCurrentTime(Actor actor) throws IllegalActionException {
            Time environmentTime = RealTimeComposite.this.getExecutiveDirector().getModelTime();
            RealTimeComposite.this._inputFrames.put(new InputFrame(environmentTime, new LinkedList<QueuedToken>()));
            Director director = RealTimeComposite.this.getExecutiveDirector();
            if (director != null) {
                Time time = new Time((Director)this, (double)(System.currentTimeMillis() - RealTimeComposite.this._realStartTime) / 1000.0);
                if (RealTimeComposite.this._debugging) {
                    RealTimeComposite.this._debug("----- fireAtCurrentTime() request by actor " + actor.getFullName() + ". Model time is " + environmentTime + ", and real time is " + time);
                }
                director.fireAt((Actor)RealTimeComposite.this, time);
            }
        }

        @Override
        public Time getModelTime() {
            if (RealTimeComposite.this._delayValue == 0.0) {
                return ((Actor)((Object)this.getContainer())).getExecutiveDirector().getModelTime();
            }
            return this._currentTime;
        }

        @Override
        public void initialize() throws IllegalActionException {
            RealTimeComposite.this._fireAtTimes.clear();
            super.initialize();
            RealTimeComposite.this._realStartTime = -1L;
            if (RealTimeComposite.this._delayValue != 0.0) {
                RealTimeComposite.this._inputFrames.clear();
                RealTimeComposite.this._outputFrames.clear();
                RealTimeComposite.this._responseTimes.clear();
                this._thread = new RealTimeThread();
                this._thread.setPriority(10);
                this._thread.start();
            }
        }

        @Override
        public Receiver newReceiver() {
            return new QueueReceiver();
        }

        @Override
        public boolean prefire() throws IllegalActionException {
            Time environmentTime = RealTimeComposite.this.getExecutiveDirector().getModelTime();
            if (RealTimeComposite.this._debugging) {
                RealTimeComposite.this._debug("----- Current environment time is: " + environmentTime);
            }
            if (RealTimeComposite.this._delayValue != 0.0) {
                this._inputTokens = new LinkedList<QueuedToken>();
                return this._thread.isAlive();
            }
            return true;
        }

        @Override
        public boolean postfire() throws IllegalActionException {
            boolean result = super.postfire();
            Time environmentTime = RealTimeComposite.this.getExecutiveDirector().getModelTime();
            if (RealTimeComposite.this._delayValue != 0.0) {
                Time fireAtTime;
                if (this._inputTokens.size() > 0) {
                    if (RealTimeComposite.this._debugging) {
                        RealTimeComposite.this._debug("Queueing input tokens for the associated thread: " + this._inputTokens.toString() + " to be processed at time " + environmentTime);
                    }
                    RealTimeComposite.this._inputFrames.put(new InputFrame(environmentTime, this._inputTokens));
                    if (RealTimeComposite.this._delayValue > 0.0) {
                        Time responseTime = environmentTime.add(RealTimeComposite.this._delayValue);
                        this.fireAt((Actor)RealTimeComposite.this, responseTime);
                        RealTimeComposite.this._responseTimes.add(responseTime);
                    }
                }
                if (RealTimeComposite.this._fireAtTimes.size() > 0 && (fireAtTime = (Time)RealTimeComposite.this._fireAtTimes.get(0)).equals(environmentTime)) {
                    RealTimeComposite.this._fireAtTimes.remove(0);
                    if (this._inputTokens.size() == 0) {
                        if (RealTimeComposite.this._debugging) {
                            RealTimeComposite.this._debug("Queueing pure event for the associated thread,  to be processed at time " + environmentTime);
                        }
                        RealTimeComposite.this._inputFrames.put(new InputFrame(environmentTime, this._inputTokens));
                        if (RealTimeComposite.this._delayValue > 0.0) {
                            Time responseTime = environmentTime.add(RealTimeComposite.this._delayValue);
                            this.fireAt((Actor)RealTimeComposite.this, responseTime);
                            RealTimeComposite.this._responseTimes.add(responseTime);
                        }
                    }
                }
                if (RealTimeComposite.this._outputFrames.size() > 0) {
                    OutputFrame frame = (OutputFrame)RealTimeComposite.this._outputFrames.get(0);
                    if (frame.time.equals(environmentTime)) {
                        RealTimeComposite.this._outputFrames.remove(0);
                    }
                }
                result = this._thread.isAlive();
            }
            return result;
        }

        @Override
        public void stop() {
            Time environmentTime = RealTimeComposite.this.getExecutiveDirector().getModelTime();
            if (RealTimeComposite.this._delayValue != 0.0) {
                if (RealTimeComposite.this._debugging) {
                    RealTimeComposite.this._debug("Queueing a stop-frame token for the associated thread with time: " + environmentTime);
                }
                RealTimeComposite.this._inputFrames.put(new InputFrame(environmentTime, null));
            } else {
                super.stop();
            }
        }

        @Override
        public boolean transferInputs(IOPort port) throws IllegalActionException {
            if (RealTimeComposite.this._delayValue == 0.0) {
                return super.transferInputs(port);
            }
            boolean result = false;
            for (int i = 0; i < port.getWidth(); ++i) {
                try {
                    if (!port.isKnown(i) || !port.hasToken(i)) continue;
                    Token token = port.get(i);
                    this._inputTokens.add(new QueuedToken(port, i, token));
                    if (RealTimeComposite.this._debugging) {
                        RealTimeComposite.this._debug(this.getName(), "transferring input from " + port.getName());
                    }
                    result = true;
                    continue;
                }
                catch (NoTokenException ex) {
                    throw new InternalErrorException(this, (Throwable)ex, null);
                }
            }
            return result;
        }

        @Override
        public boolean transferOutputs(IOPort port) throws IllegalActionException {
            if (RealTimeComposite.this._delayValue == 0.0) {
                return super.transferOutputs(port);
            }
            Time environmentTime = RealTimeComposite.this.getExecutiveDirector().getModelTime();
            double realTimeInSeconds = (double)(System.currentTimeMillis() - RealTimeComposite.this._realStartTime) / 1000.0;
            if (environmentTime.getDoubleValue() >= realTimeInSeconds) {
                return super.transferOutputs(port);
            }
            environmentTime = new Time((Director)this, realTimeInSeconds);
            LinkedList<QueuedToken> outputTokens = new LinkedList<QueuedToken>();
            for (int i = 0; i < port.getWidth(); ++i) {
                try {
                    if (!port.isKnownInside(i) || !port.hasTokenInside(i)) continue;
                    Token token = port.getInside(i);
                    outputTokens.add(new QueuedToken(port, i, token));
                    if (!RealTimeComposite.this._debugging) continue;
                    RealTimeComposite.this._debug(this.getName(), "transferring output from " + port.getName() + " with value " + token);
                    continue;
                }
                catch (NoTokenException ex) {
                    throw new InternalErrorException(this, (Throwable)ex, null);
                }
            }
            if (outputTokens.size() > 0) {
                OutputFrame frame = new OutputFrame(environmentTime, outputTokens);
                RealTimeComposite.this._outputFrames.add(frame);
                this.fireAt((Actor)RealTimeComposite.this, environmentTime);
            }
            return false;
        }

        @Override
        public void wrapup() throws IllegalActionException {
            if (RealTimeComposite.this._delayValue != 0.0) {
                Time environmentTime = RealTimeComposite.this.getExecutiveDirector().getModelTime();
                if (RealTimeComposite.this._debugging) {
                    RealTimeComposite.this._debug("Queueing a stop-frame token for the associated thread with time: " + environmentTime);
                }
                RealTimeComposite.this._inputFrames.put(new InputFrame(environmentTime, null));
                try {
                    if (RealTimeComposite.this._debugging) {
                        RealTimeComposite.this._debug("Waiting for associated thread to stop.");
                    }
                    this._thread.join();
                    if (RealTimeComposite.this._debugging) {
                        RealTimeComposite.this._debug("Associated thread has stopped.");
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            super.wrapup();
        }

        private class RealTimeThread
        extends Thread {
            public RealTimeThread() {
                super("RealTimeThread");
            }

            @Override
            public void run() {
                while (!RealTimeDirector.this._stopRequested) {
                    try {
                        if (RealTimeComposite.this._debugging) {
                            RealTimeComposite.this._debug("---- Waiting for inputs in the associated thread.");
                        }
                        InputFrame frame = (InputFrame)RealTimeComposite.this._inputFrames.take();
                        if (frame.tokens == null) {
                            if (!RealTimeComposite.this._debugging) break;
                            RealTimeComposite.this._debug("---- Read a stop frame in associated thread.");
                            break;
                        }
                        if (RealTimeComposite.this._debugging) {
                            RealTimeComposite.this._debug("---- Reading input tokens in associated thread with time " + frame.time + " and value " + frame.tokens);
                        }
                        RealTimeDirector.this._currentTime = frame.time;
                        for (QueuedToken token : frame.tokens) {
                            if (token.channel >= token.port.getWidthInside()) continue;
                            token.port.sendInside(token.channel, token.token);
                        }
                        boolean postfireReturnsTrue = RealTimeComposite.this.fireContainedActors();
                        if (RealTimeComposite.this._delayValue != 0.0) {
                            for (IOPort port : RealTimeComposite.this.outputPortList()) {
                                boolean hasOutputs = false;
                                for (int i = 0; i < port.getWidth(); ++i) {
                                    if (!port.isKnownInside(i) || !port.hasTokenInside(i)) continue;
                                    hasOutputs = true;
                                }
                                if (!hasOutputs) continue;
                                RealTimeDirector.this.transferOutputs(port);
                            }
                        }
                        if (postfireReturnsTrue) continue;
                        break;
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                    catch (IllegalActionException ex) {
                        MessageHandler.error("Error in real-time thread.", ex);
                    }
                }
            }
        }
    }

    private static class OutputFrame {
        public final Time time;
        public final List<QueuedToken> tokens;

        public OutputFrame(Time theTime, List<QueuedToken> theTokens) {
            this.tokens = theTokens;
            this.time = theTime;
        }
    }

    private static class QueuedToken {
        public final int channel;
        public final Token token;
        public final IOPort port;

        public QueuedToken(IOPort thePort, int theChannel, Token theToken) {
            this.token = theToken;
            this.channel = theChannel;
            this.port = thePort;
        }

        public String toString() {
            return "token " + this.token + " for port " + this.port.getFullName() + "(" + this.channel + ")";
        }
    }

    private class InputFrame
    implements Delayed {
        public final Time time;
        public final List<QueuedToken> tokens;

        public InputFrame(Time theTime, List<QueuedToken> theTokens) {
            this.tokens = theTokens;
            this.time = theTime;
        }

        @Override
        public long getDelay(TimeUnit unit) {
            long elapsedTime = System.currentTimeMillis() - RealTimeComposite.this._realStartTime;
            double elapsedTimeInSeconds = (double)elapsedTime / 1000.0;
            long timeToWait = (long)(this.time.subtract(elapsedTimeInSeconds).getDoubleValue() * 1000.0);
            return unit.convert(timeToWait, TimeUnit.MILLISECONDS);
        }

        @Override
        public int compareTo(Delayed frame) {
            return this.time.compareTo(((InputFrame)frame).time);
        }
    }
}

