/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.image;

import java.awt.Image;
import ptolemy.actor.lib.Transformer;
import ptolemy.actor.lib.image.Transform;
import ptolemy.data.AWTImageToken;
import ptolemy.data.ImageToken;
import ptolemy.data.IntToken;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;

public class ImageRotate
extends Transformer {
    public Parameter rotationInDegrees;

    public ImageRotate(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.input.setTypeEquals(BaseType.OBJECT);
        this.output.setTypeEquals(BaseType.OBJECT);
        this.rotationInDegrees = new Parameter((NamedObj)this, "rotationInDegrees", new IntToken(90));
        this.rotationInDegrees.setTypeEquals(BaseType.INT);
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        int width = this.input.getWidth();
        int rotation = ((IntToken)this.rotationInDegrees.getToken()).intValue();
        for (int i = 0; i < width; ++i) {
            if (!this.input.hasToken(i)) continue;
            ImageToken imageToken = (ImageToken)this.input.get(i);
            Image image = imageToken.asAWTImage();
            Image rotatedImage = Transform.rotate(image, rotation);
            this.output.broadcast(new AWTImageToken(rotatedImage));
        }
    }
}

