/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.image;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;

public class Transform {
    public static Image rotate(Image originalImage, int rotate) {
        int width = originalImage.getWidth(null);
        int height = originalImage.getHeight(null);
        int newWidth = width;
        int newHeight = height;
        if (rotate == 90 || rotate == 270) {
            newWidth = height;
            newHeight = width;
        }
        BufferedImage outputImage = new BufferedImage(newWidth, newHeight, 1);
        AffineTransform rotateAffineTransform = new AffineTransform();
        rotateAffineTransform.rotate((double)rotate * (Math.PI / 180), width / 2, height / 2);
        if (rotate != 180 && rotate != 360) {
            rotateAffineTransform.translate(width / 2 - height / 2, width / 2 - height / 2);
        }
        Graphics2D graphics2d = outputImage.createGraphics();
        graphics2d.drawImage(originalImage, rotateAffineTransform, null);
        graphics2d.dispose();
        return outputImage;
    }

    public static Image scale(Image originalImage, int maximumDimension) {
        double scale = (double)maximumDimension / (double)originalImage.getHeight(null);
        if (originalImage.getWidth(null) > originalImage.getHeight(null)) {
            scale = (double)maximumDimension / (double)originalImage.getWidth(null);
        }
        int scaledWidth = (int)(scale * (double)originalImage.getWidth(null));
        int scaledHeight = (int)(scale * (double)originalImage.getHeight(null));
        BufferedImage outputImage = new BufferedImage(scaledWidth, scaledHeight, 1);
        AffineTransform scaleAffineTransform = new AffineTransform();
        scaleAffineTransform.scale(scale, scale);
        Graphics2D graphics2d = outputImage.createGraphics();
        graphics2d.drawImage(originalImage, scaleAffineTransform, null);
        graphics2d.dispose();
        return outputImage;
    }
}

