/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.javasound;

import java.io.IOException;
import ptolemy.actor.TypedIOPort;
import ptolemy.actor.lib.javasound.LiveSoundActor;
import ptolemy.data.DoubleToken;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.media.javasound.LiveSound;

public class AudioCapture
extends LiveSoundActor {
    public TypedIOPort trigger;
    public TypedIOPort output;
    public Parameter output_tokenProductionRate;
    private double[][] _audioInDoubleArray;
    private DoubleToken[] _audioSendArray = new DoubleToken[1];

    public AudioCapture(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.trigger = new TypedIOPort(this, "trigger", true, false);
        this.trigger.setTypeEquals(BaseType.DOUBLE);
        this.trigger.setMultiport(true);
        this.output = new TypedIOPort(this, "output", false, true);
        this.output.setTypeEquals(BaseType.DOUBLE);
        this.output.setMultiport(true);
        this.output_tokenProductionRate = new Parameter(this.output, "tokenProductionRate");
        this.output_tokenProductionRate.setTypeEquals(BaseType.INT);
        this.output_tokenProductionRate.setExpression("transferSize");
    }

    @Override
    public void initialize() throws IllegalActionException {
        super.initialize();
        if (LiveSound.isCaptureActive()) {
            throw new IllegalActionException((Nameable)this, "This actor cannot start audio capture because another actor currently has access to the audio capture resource. Only one AudioCapture actor may be used at a time.");
        }
        try {
            this._initializeAudio();
            LiveSound.startCapture(this);
        }
        catch (IOException ex) {
            throw new IllegalActionException((Nameable)this, ex, "Cannot initialize audio capture.");
        }
    }

    @Override
    public boolean postfire() throws IllegalActionException {
        for (int i = 0; i < this.trigger.getWidth(); ++i) {
            if (!this.trigger.hasToken(i)) continue;
            this.trigger.get(i);
        }
        int count = this._transferSize;
        if (count > this._audioSendArray.length) {
            this._audioSendArray = new DoubleToken[count];
        }
        try {
            this._audioInDoubleArray = LiveSound.getSamples(this);
        }
        catch (Exception ex) {
            throw new IllegalActionException((Nameable)this, ex, "Cannot capture audio.");
        }
        for (int j = 0; j < this._channels; ++j) {
            for (int element = 0; element < count; ++element) {
                this._audioSendArray[element] = new DoubleToken(this._audioInDoubleArray[j][element]);
            }
            this.output.send(j, this._audioSendArray, count);
        }
        return true;
    }

    @Override
    public void wrapup() throws IllegalActionException {
        super.wrapup();
        if (LiveSound.isCaptureActive()) {
            try {
                LiveSound.stopCapture(this);
            }
            catch (IOException ex) {
                throw new IllegalActionException((Nameable)this, ex, "Error stopping audio capture.");
            }
        }
    }
}

