/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.javasound;

import java.io.IOException;
import ptolemy.actor.lib.Transformer;
import ptolemy.data.DoubleToken;
import ptolemy.data.IntToken;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.StringAttribute;
import ptolemy.media.javasound.SoundReader;

public class AudioReadBuffer
extends Transformer {
    public StringAttribute sourceURL;
    public Parameter bufferLength;
    private SoundReader _soundReader;
    private boolean _safeToInitialize = false;
    private double[] _audioBuffer;
    private boolean _postfireReturn = true;

    public AudioReadBuffer(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.output.setTypeEquals(BaseType.DOUBLE);
        this.output.setMultiport(true);
        this.sourceURL = new StringAttribute(this, "sourceURL");
        this.bufferLength = new Parameter((NamedObj)this, "bufferLength", new IntToken(8000));
        this.sourceURL.setExpression("file:///tmp/test.wav");
    }

    @Override
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.sourceURL) {
            if (this._safeToInitialize) {
                try {
                    this._initializeReader();
                }
                catch (IOException ex) {
                    throw new IllegalActionException((Nameable)this, "Cannot read audio:\n" + ex);
                }
            }
        } else if (attribute == this.bufferLength) {
            if (this._safeToInitialize) {
                try {
                    this._initializeReader();
                }
                catch (IOException ex) {
                    throw new IllegalActionException((Nameable)this, "Cannot read audio:\n" + ex);
                }
            }
        } else {
            super.attributeChanged(attribute);
            return;
        }
    }

    @Override
    public void initialize() throws IllegalActionException {
        super.initialize();
        try {
            this._initializeReader();
        }
        catch (IOException ex) {
            throw new IllegalActionException((Nameable)this, "Cannot open the specified URL: " + ex);
        }
        this._safeToInitialize = true;
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        if (this.input.hasToken(0)) {
            int in = ((IntToken)this.input.get(0)).intValue();
            if (in < 0) {
                this.output.send(0, new DoubleToken(0.0));
            } else if (in > this._audioBuffer.length - 1) {
                this._postfireReturn = false;
                this.output.send(0, new DoubleToken(0.0));
            } else {
                double sampleValue = this._audioBuffer[in];
                this.output.send(0, new DoubleToken(sampleValue));
            }
        }
    }

    @Override
    public boolean postfire() throws IllegalActionException {
        return this._postfireReturn;
    }

    @Override
    public void wrapup() throws IllegalActionException {
        if (this._soundReader != null) {
            try {
                this._soundReader.closeFile();
            }
            catch (IOException ex) {
                throw new IllegalActionException((Nameable)this, "Problem closing sound file: \n" + ex.getMessage());
            }
        }
    }

    private synchronized void _initializeReader() throws IOException, IllegalActionException {
        if (this._soundReader != null) {
            this._soundReader.closeFile();
        }
        String theURL = this.sourceURL.getExpression();
        int getSamplesArraySize = 1;
        this._soundReader = new SoundReader(theURL, getSamplesArraySize);
        int length = ((IntToken)this.bufferLength.getToken()).intValue();
        this._audioBuffer = new double[length];
        boolean done = false;
        for (int i = 0; i < length; ++i) {
            if (done) continue;
            double[][] samples = this._soundReader.getSamples();
            if (samples != null) {
                this._audioBuffer[i] = samples[0][0];
                continue;
            }
            done = true;
        }
    }
}

