/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.jni;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Iterator;
import java.util.LinkedList;
import ptolemy.actor.IOPort;
import ptolemy.actor.NoTokenException;
import ptolemy.actor.TypedCompositeActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.actor.gui.Configuration;
import ptolemy.actor.gui.Effigy;
import ptolemy.actor.gui.PtolemyEffigy;
import ptolemy.actor.lib.jni.PointerToken;
import ptolemy.actor.parameters.ParameterPort;
import ptolemy.actor.util.DFUtilities;
import ptolemy.data.BooleanToken;
import ptolemy.data.DoubleToken;
import ptolemy.data.IntToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Constants;
import ptolemy.data.expr.FileParameter;
import ptolemy.data.expr.Parameter;
import ptolemy.data.expr.StringParameter;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.attributes.URIAttribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Workspace;
import ptolemy.util.FileUtilities;
import ptolemy.util.MessageHandler;
import ptolemy.util.StringBufferExec;
import ptolemy.util.StringUtilities;

public class CompiledCompositeActor
extends TypedCompositeActor {
    public FileParameter codeDirectory;
    public StringParameter generatorPackage;
    public Parameter inline;
    public Parameter invokeJNI;
    public Parameter overwriteFiles;
    private StringBufferExec _executeCommands;
    private Object _jniWrapper;
    private Method _jniFireMethod;
    private Method _jniInitializeMethod;
    private Method _jniWrapupMethod;
    private String _sanitizedActorName;
    private long _generatedCodeVersion = -1L;
    private long _loadedCodeVersion = -1L;
    private int _version = 0;
    private static int _noEffigyVersion = 0;
    private static boolean _pointerTypeInitialized = false;

    public CompiledCompositeActor() {
        this._init();
    }

    public CompiledCompositeActor(Workspace workspace) {
        super(workspace);
        this._init();
    }

    public CompiledCompositeActor(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this._init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fire() throws IllegalActionException {
        boolean invoked = ((BooleanToken)this.invokeJNI.getToken()).booleanValue();
        if (invoked) {
            if (this._debugging) {
                this._debug("Calling fire()");
            }
            try {
                this._workspace.getReadAccess();
                if (!this.isOpaque()) {
                    throw new IllegalActionException((Nameable)this, "Cannot fire a non-opaque actor.");
                }
                LinkedList<Object> tokensFromAllInputPorts = new LinkedList<Object>();
                Iterator inputPorts = this.inputPortList().iterator();
                while (inputPorts.hasNext() && !this._stopRequested) {
                    IOPort port = (IOPort)inputPorts.next();
                    if (port instanceof ParameterPort) continue;
                    Object tokens = this._transferInputs(port);
                    tokensFromAllInputPorts.add(tokens);
                }
                if (this._stopRequested) {
                    return;
                }
                Object[] tokensToAllOutputPorts = null;
                try {
                    tokensToAllOutputPorts = (Object[])this._jniFireMethod.invoke(this._jniWrapper, tokensFromAllInputPorts.toArray());
                }
                catch (Throwable throwable) {
                    throw new IllegalActionException((Nameable)this, throwable, "Failed to invoke the fire method on the wrapper class.");
                }
                if (this._stopRequested) {
                    return;
                }
                int portNumber = 0;
                Iterator outputPorts = this.outputPortList().iterator();
                while (outputPorts.hasNext() && !this._stopRequested) {
                    IOPort port = (IOPort)outputPorts.next();
                    this._transferOutputs(port, tokensToAllOutputPorts[portNumber++]);
                }
            }
            finally {
                this._workspace.doneReading();
            }
            if (this._debugging) {
                this._debug("Called fire()");
            }
        } else {
            super.fire();
        }
    }

    public String getSanitizedName() {
        return this._sanitizedActorName;
    }

    @Override
    public void initialize() throws IllegalActionException {
        super.initialize();
        boolean invoked = ((BooleanToken)this.invokeJNI.getToken()).booleanValue();
        if (invoked) {
            if (this._generatedCodeVersion != this._workspace.getVersion()) {
                this._updateSanitizedActorName();
                if (this._buildSharedObjectFile()) {
                    if (this._loadedCodeVersion != -1L) {
                        ++this._version;
                        this._updateSanitizedActorName();
                    }
                    this._generateAndCompileJavaCode();
                    this._generateAndCompileCCode();
                    this._generatedCodeVersion = this._workspace.getVersion();
                }
                if (this._generatedCodeVersion == -1L) {
                    this._generatedCodeVersion = this._workspace.getVersion();
                }
                if (this._loadedCodeVersion != this._generatedCodeVersion) {
                    String jniClassName = this._sanitizedActorName;
                    Class<?> jniClass = null;
                    URL url = null;
                    try {
                        url = this.codeDirectory.asFile().toURI().toURL();
                        URL[] urls = new URL[]{url};
                        URLClassLoader classLoader = new URLClassLoader(urls);
                        jniClass = classLoader.loadClass(jniClassName);
                    }
                    catch (MalformedURLException ex) {
                        throw new IllegalActionException((Nameable)this, ex, "The class URL \"" + url + "\" for \"" + jniClassName + "\" is malformed");
                    }
                    catch (UnsupportedClassVersionError ex) {
                        throw new IllegalActionException((Nameable)this, ex, "Unsupported class version in the class \"" + jniClassName + "\" from \"" + url + "\".  Try deleting the \"" + jniClassName + "\" class in \"" + url + "\".\nThis problem can also occur " + "if the version of java that is " + "running Ptolemy and the version " + "of javac used to compile the file " + "to load into Ptolemy are different " + "and java is of a later version." + "\nTo see information about the " + "version of Java used to run " + "Ptolemy, use View -> JVM Properties." + "  To see what version of javac " + "was used, run \"java -version\".");
                    }
                    catch (Throwable ex) {
                        throw new IllegalActionException((Nameable)this, ex, "Cannot load the class \"" + jniClassName + "\" from \"" + url + "\"");
                    }
                    try {
                        this._jniWrapper = jniClass.newInstance();
                    }
                    catch (Throwable throwable) {
                        throw new IllegalActionException((Nameable)this, throwable, "Cannot instantiate the wrapper object.");
                    }
                    Method[] methods = jniClass.getMethods();
                    for (int i = 0; i < methods.length; ++i) {
                        String name = methods[i].getName();
                        if (name.equals("fire")) {
                            this._jniFireMethod = methods[i];
                            continue;
                        }
                        if (name.equals("initialize")) {
                            this._jniInitializeMethod = methods[i];
                            continue;
                        }
                        if (!name.equals("wrapup")) continue;
                        this._jniWrapupMethod = methods[i];
                    }
                    if (this._jniFireMethod == null) {
                        throw new IllegalActionException((Nameable)this, "Cannot find fire method in the jni wrapper class.");
                    }
                    if (this._jniInitializeMethod == null) {
                        throw new IllegalActionException((Nameable)this, "Cannot find initialize method in the jni wrapper class.");
                    }
                    if (this._jniWrapupMethod == null) {
                        throw new IllegalActionException((Nameable)this, "Cannot find wrapup method in the jni wrapper class.");
                    }
                    this._loadedCodeVersion = this._workspace.getVersion();
                }
            }
            try {
                this._jniInitializeMethod.invoke(this._jniWrapper, (Object[])null);
            }
            catch (Throwable throwable) {
                throw new IllegalActionException((Nameable)this, throwable, "Failed to invoke the initialize method onthe wrapper class.");
            }
        }
    }

    @Override
    public void wrapup() throws IllegalActionException {
        super.wrapup();
        boolean invoked = ((BooleanToken)this.invokeJNI.getToken()).booleanValue();
        if (invoked) {
            if (this._jniWrapper == null) {
                return;
            }
            try {
                this._jniWrapupMethod.invoke(this._jniWrapper, (Object[])null);
            }
            catch (Throwable throwable) {
                throw new IllegalActionException((Nameable)this, throwable, "Failed to invoke the wrapup method on the wrapper class.");
            }
        }
    }

    protected void _compileJavaCode() throws IllegalActionException {
        if (this._executeCommands == null) {
            this._executeCommands = new StringBufferExec(true);
        }
        LinkedList<String> commands = new LinkedList<String>();
        commands.add("javac -classpath . " + this._sanitizedActorName + ".java");
        commands.add("javah -classpath . " + this._sanitizedActorName);
        this._executeCommands.setWorkingDirectory(this.codeDirectory.asFile());
        this._executeCommands.setCommands(commands);
        this._executeCommands.start();
        int lastSubprocessReturnCode = this._executeCommands.getLastSubprocessReturnCode();
        if (lastSubprocessReturnCode != 0) {
            throw new IllegalActionException((Nameable)this, "Execution of subcommands failed, last process returned " + lastSubprocessReturnCode + ", which is not 0:\n" + this._executeCommands.buffer.toString());
        }
    }

    protected void _generateAndCompileCCode() throws IllegalActionException {
        this._invokeHelperMethod("generateCode");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _generateAndCompileJavaCode() throws IllegalActionException {
        StringBuffer code = new StringBuffer();
        String sharedObjectPath = this._sharedObjectPath(this._sanitizedActorName);
        code.append("public class " + this._sanitizedActorName + " {\n" + "\n" + "    public native Object[] fire(" + this._getArguments() + ");\n" + "    public native void initialize();\n" + "    public native void wrapup();\n" + "    static {\n" + "        String library = \"" + sharedObjectPath + "\";\n" + "        System.load(library);\n" + "    }\n" + "}\n");
        String codeFileName = this._sanitizedActorName + ".java";
        try {
            File codeDirectoryFile = this.codeDirectory.asFile();
            if (codeDirectoryFile.isFile()) {
                throw new IOException("Error: " + this.codeDirectory.stringValue() + " is a file, " + "it should be a directory.");
            }
            if (!codeDirectoryFile.isDirectory() && !codeDirectoryFile.mkdirs()) {
                throw new IOException("Failed to make the \"" + this.codeDirectory.stringValue() + "\" directory.");
            }
            this.codeDirectory.setBaseDirectory(this.codeDirectory.asFile().toURI());
            File writeFile = new File(codeDirectoryFile, codeFileName);
            if (!((BooleanToken)this.overwriteFiles.getToken()).booleanValue() && writeFile.exists() && !MessageHandler.yesNoQuestion(this.codeDirectory.asFile() + " exists. OK to overwrite?")) {
                return;
            }
            Writer writer = null;
            try {
                System.out.println("Writing \"" + codeFileName + "\" in \"" + this.codeDirectory.getBaseDirectory() + "\"");
                writer = FileUtilities.openForWriting(codeFileName, this.codeDirectory.getBaseDirectory(), false);
                writer.write(code.toString());
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
            }
        }
        catch (Throwable throwable) {
            throw new IllegalActionException((Nameable)this, throwable, "Failed to write \"" + codeFileName + "\" in " + this.codeDirectory.getBaseDirectory());
        }
        this._compileJavaCode();
    }

    private boolean _buildSharedObjectFile() throws IllegalActionException {
        String message = "CompiledCompositeActor: Building shared object: ";
        long fileDependenciesModificationTime = (Long)this._invokeHelperMethod("copyFilesToCodeDirectory");
        File sharedObjectFile = new File(this._sharedObjectPath(this._sanitizedActorName));
        if (sharedObjectFile == null || !sharedObjectFile.canRead()) {
            System.out.println(message + "Can't read the shared object file.");
            return true;
        }
        Effigy effigy = Configuration.findEffigy(this.toplevel());
        if (effigy != null && effigy.isModified()) {
            System.out.println(message + "The effigy " + effigy + "(model : " + ((PtolemyEffigy)effigy).getModel() + ") says the model was modified and thus it does not matter " + "if the shared object file is newer than the model file " + "because the model file is out of date.");
            return true;
        }
        URI modelURI = URIAttribute.getModelURI(this);
        if (modelURI == null) {
            System.out.println(message + "This model does not have a _uri parameter.");
            return true;
        }
        String modelPath = modelURI.getPath();
        File modelFile = null;
        try {
            modelFile = new File(modelPath);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (modelFile == null || sharedObjectFile.lastModified() < modelFile.lastModified()) {
            System.out.println(message + "The sharedObjectFile has a modification time " + "that is earlier than the modelFile modification time.");
            return true;
        }
        if (modelFile == null || sharedObjectFile.lastModified() < fileDependenciesModificationTime) {
            System.out.println(message + "The sharedObjectFile has a modification time " + "that is earlier than modification time of one of the " + "files in the fileDependency block.");
            return true;
        }
        if (effigy == null) {
            System.out.println(message + "No effigy.  This can happen when " + "CodeGenerator.generateCode() is called from within " + "the test suite.  The code will be recompiled.");
            this._version = ++_noEffigyVersion;
            this._updateSanitizedActorName();
            return true;
        }
        return false;
    }

    private String _sharedObjectPath(String sanitizedActorName) throws IllegalActionException {
        String sharedObjectPath = null;
        try {
            String fileName = "";
            String osName = StringUtilities.getProperty("os.name");
            if (osName != null) {
                fileName = osName.startsWith("Windows") ? sanitizedActorName + ".dll" : "lib" + sanitizedActorName + ".so";
            }
            sharedObjectPath = this.codeDirectory.asFile().getCanonicalPath() + File.separator + fileName;
            sharedObjectPath = sharedObjectPath.replace("\\", "/");
        }
        catch (IOException ex) {
            throw new IllegalActionException((Nameable)this, ex, "Cannot generate library path.");
        }
        return sharedObjectPath;
    }

    private String _getArguments() {
        StringBuffer arguments = new StringBuffer();
        Iterator inputPorts = this.inputPortList().iterator();
        int i = 0;
        while (inputPorts.hasNext()) {
            IOPort inputPort = (IOPort)inputPorts.next();
            if (inputPort instanceof ParameterPort) continue;
            if (i != 0) {
                arguments.append(", ");
            }
            ++i;
            Type type = ((TypedIOPort)inputPort).getType();
            String typeName = ((Object)type).toString();
            if (typeName.equals("unknown") || typeName.equals("Pointer")) {
                typeName = "int";
            }
            arguments.append(typeName + "[][] " + inputPort.getName());
        }
        return arguments.toString();
    }

    private Object _invokeHelperMethod(String methodName) throws IllegalActionException {
        String packageName = this.generatorPackage.stringValue();
        String helperClassName = this.getClass().getName().replaceFirst("ptolemy", packageName);
        Class<?> helperClass = null;
        try {
            helperClass = Class.forName(helperClassName);
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalActionException((Nameable)this, ex, "Cannot find helper class " + helperClassName);
        }
        Method generateMethod = null;
        try {
            generateMethod = helperClass.getMethod(methodName, TypedCompositeActor.class);
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalActionException((Nameable)this, ex, "Cannot find the \"" + methodName + "\" method in \"" + helperClassName + "\".");
        }
        try {
            return generateMethod.invoke(null, this);
        }
        catch (InvocationTargetException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof InvocationTargetException) {
                cause = cause.getCause();
            }
            throw new IllegalActionException((Nameable)this, cause, "Failed to invoke the \"" + methodName + "\" method in \"" + helperClassName + "\".");
        }
        catch (Throwable throwable) {
            throw new IllegalActionException((Nameable)this, throwable, "Failed to invoke the \"" + methodName + "\" method in \"" + helperClassName + "\".");
        }
    }

    private void _init() {
        this.setClassName("ptolemy.codegen.c.actor.CompiledCompositeActor");
        if (!_pointerTypeInitialized) {
            Constants.add("pointer", new PointerToken());
            _pointerTypeInitialized = true;
        }
        try {
            this.generatorPackage = new StringParameter(this, "generatorPackage");
            this.generatorPackage.setExpression("ptolemy.codegen.c");
            this.inline = new Parameter(this, "inline");
            this.inline.setTypeEquals(BaseType.BOOLEAN);
            this.inline.setExpression("false");
            this.codeDirectory = new FileParameter(this, "codeDirectory");
            this.codeDirectory.setExpression("$HOME/codegen/");
            this.codeDirectory.setBaseDirectory(this.codeDirectory.asFile().toURI());
            new Parameter((NamedObj)this.codeDirectory, "allowFiles", BooleanToken.FALSE);
            new Parameter((NamedObj)this.codeDirectory, "allowDirectories", BooleanToken.TRUE);
            this.invokeJNI = new Parameter(this, "invokeJNI");
            this.invokeJNI.setTypeEquals(BaseType.BOOLEAN);
            this.invokeJNI.setExpression("true");
            this.overwriteFiles = new Parameter(this, "overwriteFiles");
            this.overwriteFiles.setTypeEquals(BaseType.BOOLEAN);
            this.overwriteFiles.setExpression("true");
        }
        catch (Exception ex) {
            throw new InternalErrorException(this, (Throwable)ex, "Problem setting up coSimulation parameter");
        }
    }

    private Object _transferInputs(IOPort port) throws IllegalActionException {
        int numberOfChannels;
        int rate = DFUtilities.getTokenConsumptionRate(port);
        Type type = ((TypedIOPort)port).getType();
        Object tokenHolder = null;
        int n = numberOfChannels = port.getWidth() < port.getWidthInside() ? port.getWidth() : port.getWidthInside();
        if (type == BaseType.INT) {
            tokenHolder = new int[numberOfChannels][];
        } else if (type == BaseType.DOUBLE) {
            tokenHolder = new double[numberOfChannels][];
        } else if (type == PointerToken.POINTER) {
            tokenHolder = new int[numberOfChannels][];
        } else if (type == BaseType.BOOLEAN) {
            tokenHolder = new boolean[numberOfChannels][];
        }
        for (int i = 0; i < port.getWidth(); ++i) {
            try {
                if (i < port.getWidthInside()) {
                    if (port.hasToken(i, rate)) {
                        int k;
                        int[] intTokens;
                        Token[] tokens = port.get(i, rate);
                        if (this._debugging) {
                            this._debug(this.getName(), "transferring input from " + port.getName());
                        }
                        if (type == BaseType.INT) {
                            intTokens = new int[rate];
                            for (k = 0; k < rate; ++k) {
                                intTokens[k] = ((IntToken)tokens[k]).intValue();
                            }
                            ((int[][])tokenHolder)[i] = intTokens;
                            continue;
                        }
                        if (type == BaseType.DOUBLE) {
                            double[] doubleTokens = new double[rate];
                            for (k = 0; k < rate; ++k) {
                                doubleTokens[k] = ((DoubleToken)tokens[k]).doubleValue();
                            }
                            ((double[][])tokenHolder)[i] = doubleTokens;
                            continue;
                        }
                        if (type == PointerToken.POINTER) {
                            intTokens = new int[rate];
                            for (k = 0; k < rate; ++k) {
                                intTokens[k] = ((PointerToken)tokens[k]).getValue();
                            }
                            ((int[][])tokenHolder)[i] = intTokens;
                            continue;
                        }
                        if (type != BaseType.BOOLEAN) continue;
                        boolean[] booleanTokens = new boolean[rate];
                        for (k = 0; k < rate; ++k) {
                            booleanTokens[k] = ((BooleanToken)tokens[k]).booleanValue();
                        }
                        ((boolean[][])tokenHolder)[i] = booleanTokens;
                        continue;
                    }
                    throw new IllegalActionException((Nameable)this, port, "Port should consume " + rate + " tokens, but there were not " + " enough tokens available.");
                }
                if (this._debugging) {
                    this._debug(this.getName(), "Dropping single input from " + port.getName());
                }
                if (!port.hasToken(i)) continue;
                port.get(i);
                continue;
            }
            catch (NoTokenException ex) {
                throw new InternalErrorException(this, (Throwable)ex, null);
            }
        }
        return tokenHolder;
    }

    private void _transferOutputs(IOPort port, Object outputTokens) throws IllegalActionException {
        block9: {
            Type type;
            int rate;
            block11: {
                block10: {
                    block8: {
                        rate = DFUtilities.getTokenProductionRate(port);
                        type = ((TypedIOPort)port).getType();
                        if (type != BaseType.INT) break block8;
                        int[][] tokens = (int[][])outputTokens;
                        for (int i = 0; i < port.getWidthInside(); ++i) {
                            for (int k = 0; k < rate; ++k) {
                                IntToken token = new IntToken(tokens[i][k]);
                                port.send(i, token);
                            }
                        }
                        break block9;
                    }
                    if (type != BaseType.DOUBLE) break block10;
                    double[][] tokens = (double[][])outputTokens;
                    for (int i = 0; i < port.getWidthInside(); ++i) {
                        for (int k = 0; k < rate; ++k) {
                            DoubleToken token = new DoubleToken(tokens[i][k]);
                            port.send(i, token);
                        }
                    }
                    break block9;
                }
                if (type != PointerToken.POINTER) break block11;
                int[][] tokens = (int[][])outputTokens;
                for (int i = 0; i < port.getWidthInside(); ++i) {
                    for (int k = 0; k < rate; ++k) {
                        PointerToken token = new PointerToken(tokens[i][k]);
                        port.send(i, token);
                    }
                }
                break block9;
            }
            if (type != BaseType.BOOLEAN) break block9;
            boolean[][] tokens = (boolean[][])outputTokens;
            for (int i = 0; i < port.getWidthInside(); ++i) {
                for (int k = 0; k < rate; ++k) {
                    BooleanToken token = new BooleanToken(tokens[i][k]);
                    port.send(i, token);
                }
            }
        }
    }

    private void _updateSanitizedActorName() {
        this._sanitizedActorName = StringUtilities.sanitizeName(this.getFullName());
        this._sanitizedActorName = this._sanitizedActorName.replace("_", "") + this._version;
    }
}

