/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.security;

import java.security.Key;
import java.security.KeyStoreException;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import ptolemy.actor.TypedIOPort;
import ptolemy.actor.lib.security.KeyStoreActor;
import ptolemy.actor.lib.security.KeyToken;
import ptolemy.data.BooleanToken;
import ptolemy.data.expr.Parameter;
import ptolemy.data.expr.StringParameter;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Settable;

public class KeyReader
extends KeyStoreActor {
    public Parameter getPublicKey = new Parameter((NamedObj)this, "getPublicKey", new BooleanToken(true));
    public TypedIOPort output = null;
    public TypedIOPort trigger = null;
    public StringParameter signatureAlgorithm;
    public Parameter verifyCertificate;
    private boolean _getPublicKey;
    private Key _key;
    private boolean _updateKeyNeeded = true;
    private boolean _verifyCertificate;

    public KeyReader(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.getPublicKey.setTypeEquals(BaseType.BOOLEAN);
        this.output = new TypedIOPort(this, "output", false, true);
        this.output.setTypeEquals(KeyToken.KEY);
        this.trigger = new TypedIOPort(this, "trigger", true, false);
        this.trigger.setMultiport(true);
        this.signatureAlgorithm = new StringParameter(this, "signatureAlgorithm");
        this.signatureAlgorithm.setExpression("Unknown, will be set after first run");
        this.signatureAlgorithm.setVisibility(Settable.NOT_EDITABLE);
        this.signatureAlgorithm.setPersistent(false);
        this.verifyCertificate = new Parameter((NamedObj)this, "verifyCertificate", new BooleanToken(true));
        this.verifyCertificate.setTypeEquals(BaseType.BOOLEAN);
    }

    @Override
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.getPublicKey) {
            this._updateKeyNeeded = true;
            this._getPublicKey = ((BooleanToken)this.getPublicKey.getToken()).booleanValue();
        } else if (attribute == this.verifyCertificate) {
            this._updateKeyNeeded = true;
            this._verifyCertificate = ((BooleanToken)this.verifyCertificate.getToken()).booleanValue();
        } else {
            super.attributeChanged(attribute);
        }
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        this._updateKey();
        for (int i = 0; i < this.trigger.getWidth(); ++i) {
            if (!this.trigger.hasToken(i)) continue;
            this.trigger.get(i);
        }
        this.output.broadcast(new KeyToken(this._key));
    }

    protected void _updateKey() throws IllegalActionException {
        if (this._updateKeyNeeded) {
            this._loadKeyStoreNeeded = true;
            this._loadKeyStore();
            try {
                if (!this._verifyCertificate) {
                    if (this._getPublicKey) {
                        throw new IllegalActionException((Nameable)this, "To get the public key, one must use certificates, so the verifyCertificate parameter must be set to true if the getPublicKey parameter is true.");
                    }
                } else {
                    Certificate certificate = this._keyStore.getCertificate(this._alias);
                    if (certificate == null) {
                        throw new KeyStoreException("Failed to get certificate for alias '" + this._alias + "' from  " + this.fileOrURLDescription());
                    }
                    PublicKey publicKey = certificate.getPublicKey();
                    certificate.verify(publicKey);
                    if (certificate instanceof X509Certificate) {
                        this.signatureAlgorithm.setExpression(((X509Certificate)certificate).getSigAlgName());
                    } else {
                        this.signatureAlgorithm.setExpression("Unknown, certificate was not a X509 cert.");
                    }
                    this._key = publicKey;
                }
                if (!this._getPublicKey) {
                    this._key = this._keyStore.getKey(this._alias, this._keyPassword.toCharArray());
                }
            }
            catch (Throwable throwable) {
                throw new IllegalActionException((Nameable)this, throwable, "Failed to get key store alias '" + this._alias + "' or certificate from " + this.fileOrURLDescription());
            }
        }
    }
}

