/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.string;

import ptolemy.actor.TypedAtomicActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.actor.parameters.PortParameter;
import ptolemy.data.BooleanToken;
import ptolemy.data.IntToken;
import ptolemy.data.StringToken;
import ptolemy.data.expr.Parameter;
import ptolemy.data.expr.SingletonParameter;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;

public class StringIndexOf
extends TypedAtomicActor {
    public Parameter ignoreCase;
    public PortParameter inText;
    public TypedIOPort output;
    public PortParameter searchFor = new PortParameter(this, "searchFor");
    public Parameter searchForwards;
    public PortParameter startIndex;

    public StringIndexOf(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.searchFor.setStringMode(true);
        this.searchFor.setExpression("");
        new SingletonParameter(this.searchFor.getPort(), "_showName").setToken(BooleanToken.TRUE);
        this.inText = new PortParameter(this, "inText");
        this.inText.setStringMode(true);
        this.inText.setExpression("");
        new SingletonParameter(this.inText.getPort(), "_showName").setToken(BooleanToken.TRUE);
        this.ignoreCase = new Parameter(this, "ignoreCase");
        this.ignoreCase.setTypeEquals(BaseType.BOOLEAN);
        this.ignoreCase.setToken(new BooleanToken(false));
        this.startIndex = new PortParameter(this, "startIndex");
        this.startIndex.setTypeEquals(BaseType.INT);
        this.startIndex.setExpression("0");
        new SingletonParameter(this.startIndex.getPort(), "_showName").setToken(BooleanToken.TRUE);
        this.searchForwards = new Parameter(this, "searchForwards");
        this.searchForwards.setTypeEquals(BaseType.BOOLEAN);
        this.searchForwards.setExpression("true");
        this.output = new TypedIOPort(this, "output", false, true);
        this.output.setTypeEquals(BaseType.INT);
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        this.searchFor.update();
        this.inText.update();
        this.startIndex.update();
        String searchForString = ((StringToken)this.searchFor.getToken()).stringValue();
        String inTextString = ((StringToken)this.inText.getToken()).stringValue();
        int startIndexValue = ((IntToken)this.startIndex.getToken()).intValue();
        boolean forwards = ((BooleanToken)this.searchForwards.getToken()).booleanValue();
        if (((BooleanToken)this.ignoreCase.getToken()).booleanValue()) {
            searchForString = searchForString.toLowerCase();
            inTextString = inTextString.toLowerCase();
        }
        int returnValue = forwards ? inTextString.indexOf(searchForString, startIndexValue) : inTextString.lastIndexOf(searchForString, startIndexValue);
        this.output.send(0, new IntToken(returnValue));
    }
}

