/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.string;

import ptolemy.actor.lib.Transformer;
import ptolemy.actor.parameters.PortParameter;
import ptolemy.data.BooleanToken;
import ptolemy.data.IntToken;
import ptolemy.data.StringToken;
import ptolemy.data.expr.SingletonParameter;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;

public class StringSubstring
extends Transformer {
    public PortParameter start = new PortParameter(this, "start");
    public PortParameter stop;

    public StringSubstring(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.start.setExpression("0");
        this.start.setTypeEquals(BaseType.INT);
        new SingletonParameter(this.start.getPort(), "_showName").setToken(BooleanToken.TRUE);
        this.stop = new PortParameter(this, "stop");
        this.stop.setExpression("0");
        this.stop.setTypeEquals(BaseType.INT);
        new SingletonParameter(this.start.getPort(), "_showName").setToken(BooleanToken.TRUE);
        this.input.setTypeEquals(BaseType.STRING);
        this.output.setTypeEquals(BaseType.STRING);
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        this.start.update();
        this.stop.update();
        if (this.input.hasToken(0)) {
            StringToken inputToken = (StringToken)this.input.get(0);
            String value = inputToken.stringValue();
            int startValue = ((IntToken)this.start.getToken()).intValue();
            int stopValue = ((IntToken)this.stop.getToken()).intValue();
            String substringValue = stopValue == -1 ? value.substring(startValue) : value.substring(startValue, stopValue);
            this.output.send(0, new StringToken(substringValue));
        }
    }
}

