/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.vhdl;

import ptolemy.actor.TypedIOPort;
import ptolemy.actor.lib.vhdl.SynchronousFixTransformer;
import ptolemy.data.FixToken;
import ptolemy.data.expr.Parameter;
import ptolemy.data.expr.StringParameter;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.math.Precision;

public class FixComparator
extends SynchronousFixTransformer {
    public TypedIOPort A = new TypedIOPort(this, "A", true, false);
    public TypedIOPort B;
    public Parameter operation;

    public FixComparator(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.A.setTypeEquals(BaseType.FIX);
        this.B = new TypedIOPort(this, "B", true, false);
        this.B.setTypeEquals(BaseType.FIX);
        this.operation = new StringParameter(this, "operation");
        this.operation.setExpression("=");
        this.operation.addChoice("=");
        this.operation.addChoice("!=");
        this.operation.addChoice("<");
        this.operation.addChoice("<=");
        this.operation.addChoice(">");
        this.operation.addChoice(">=");
        this._setAndHideQuantizationParameters("U1.0", "CLIP", "HALF_EVEN");
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        FixToken result = null;
        Precision precision = new Precision(0, 1, 0);
        if (this.A.isKnown() && this.B.isKnown()) {
            result = new FixToken(0.0, precision);
            FixToken inputA = new FixToken();
            FixToken inputB = new FixToken();
            if (this.A.hasToken(0)) {
                inputA = (FixToken)this.A.get(0);
            }
            if (this.B.hasToken(0)) {
                inputB = (FixToken)this.B.get(0);
            }
            if (inputA.fixValue().getPrecision().getNumberOfBits() != inputB.fixValue().getPrecision().getNumberOfBits()) {
                throw new IllegalActionException((Nameable)this, "Input A has different width than Input B port");
            }
            if (this.operation.getExpression().equals("=")) {
                if (inputA.equals(inputB)) {
                    result = new FixToken(1.0, precision);
                }
            } else if (this.operation.getExpression().equals("!=")) {
                if (!inputA.equals(inputB)) {
                    result = new FixToken(1.0, precision);
                }
            } else if (this.operation.getExpression().equals("<")) {
                if (inputA.isLessThan(inputB).booleanValue()) {
                    result = new FixToken(1.0, precision);
                }
            } else if (this.operation.getExpression().equals("<=")) {
                if (inputA.equals(inputB) || inputA.isLessThan(inputB).booleanValue()) {
                    result = new FixToken(1.0, precision);
                }
            } else if (this.operation.getExpression().equals(">")) {
                if (inputA.isGreaterThan(inputB).booleanValue()) {
                    result = new FixToken(1.0, precision);
                }
            } else if (this.operation.getExpression().equals(">=") && (inputA.equals(inputB) || inputA.isGreaterThan(inputB).booleanValue())) {
                result = new FixToken(1.0, precision);
            }
            this.sendOutput(this.output, 0, result);
        } else {
            this.output.resend(0);
        }
    }

    @Override
    public void pruneDependencies() {
        super.pruneDependencies();
        this.removeDependency(this.A, this.output);
        this.removeDependency(this.B, this.output);
    }
}

