/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.vhdl;

import ptolemy.actor.TypedIOPort;
import ptolemy.actor.lib.vhdl.SynchronousFixTransformer;
import ptolemy.data.ArrayToken;
import ptolemy.data.FixToken;
import ptolemy.data.ScalarToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.math.FixPoint;

public class ROM
extends SynchronousFixTransformer {
    public Parameter values = new Parameter(this, "values");
    public TypedIOPort address;
    private int _addressWidth;
    private int _capacity;

    public ROM(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.values.setExpression("{1}");
        this.address = new TypedIOPort(this, "address", true, false);
        this.address.setTypeEquals(BaseType.FIX);
    }

    @Override
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        super.attributeChanged(attribute);
        if (attribute == this.values) {
            this._capacity = ((ArrayToken)this.values.getToken()).length();
            this._addressWidth = (int)Math.floor(Math.log(this._capacity) / Math.log(2.0));
        }
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        if (this.address.isKnown(0)) {
            if (!this.address.hasToken(0)) {
                return;
            }
            FixToken addressToken = (FixToken)this.address.get(0);
            FixPoint addressFixValue = addressToken.fixValue();
            this._checkFixTokenWidth(addressToken, this._addressWidth);
            int addressValue = addressFixValue.getUnscaledValue().intValue();
            if (addressValue >= this._capacity) {
                throw new IllegalActionException((Nameable)this, "Address is out of range.");
            }
            ArrayToken valuesArray = (ArrayToken)this.values.getToken();
            FixPoint value = new FixPoint(((ScalarToken)valuesArray.getElement(addressValue)).intValue());
            Token result = new FixToken(value);
            if (result == null) {
                result = Token.NIL;
            }
            this.sendOutput(this.output, 0, result);
        } else {
            this.output.resend(0);
        }
    }

    @Override
    public void pruneDependencies() {
        super.pruneDependencies();
        this.removeDependency(this.address, this.output);
    }
}

