/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.xslt;

import ptolemy.actor.lib.Transformer;
import ptolemy.actor.parameters.PortParameter;
import ptolemy.data.ArrayToken;
import ptolemy.data.StringToken;
import ptolemy.data.Token;
import ptolemy.data.XMLToken;
import ptolemy.data.expr.StringParameter;
import ptolemy.data.type.ArrayType;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;

public class XMLInclusion
extends Transformer {
    public PortParameter template;
    public StringParameter headerParameter;

    public XMLInclusion(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.input.setTypeEquals(new ArrayType(BaseType.XMLTOKEN));
        this.input.setMultiport(true);
        this.template = new PortParameter(this, "template");
        this.template.setStringMode(true);
        this.headerParameter = new StringParameter(this, "headerParameter");
        this.headerParameter.setExpression("<?xml version=\"1.0\" standalone=\"no\"?>");
        this.output.setTypeEquals(BaseType.XMLTOKEN);
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        this.template.update();
        String outputString = this.removeHeader(this.template.getToken());
        String all = "";
        for (int j = 0; j < this.input.getWidth(); ++j) {
            ArrayToken a = (ArrayToken)this.input.get(j);
            String allInArray = "";
            for (int i = 0; i < a.length(); ++i) {
                String elemInArray = this.removeHeader(a.getElement(i));
                allInArray = i == 0 ? allInArray.concat(elemInArray) : allInArray.concat('\n' + elemInArray);
                String elemTag = "$input" + Integer.toString(j) + ',' + Integer.toString(i);
                outputString = outputString.replace(elemTag, elemInArray);
            }
            String arrayTag = "$input" + Integer.toString(j) + ",n";
            outputString = outputString.replace(arrayTag, allInArray);
            all = j == 0 ? all.concat(allInArray) : all.concat('\n' + allInArray);
        }
        outputString = outputString.replace("$inputn", all);
        String ADDheader = this.headerParameter.stringValue() + "\n";
        ADDheader = ADDheader.concat(outputString);
        try {
            XMLToken out = new XMLToken(ADDheader);
            this.output.broadcast(out);
        }
        catch (Exception e) {
            throw new InternalErrorException(e);
        }
    }

    private String removeHeader(Token T) {
        String s2;
        String str = "";
        if (T instanceof StringToken) {
            str = ((StringToken)T).stringValue();
        } else if (T instanceof XMLToken) {
            str = T.toString();
        } else {
            throw new InternalErrorException("The token should be either of type StringToken, or of type XMLToken.");
        }
        String s = str.trim();
        int i = 0;
        if (s.startsWith("<?xml")) {
            i = 1;
            s = this.loopThroughHeaders(s);
        }
        if ((s2 = s.trim()).startsWith("<!DOCTYPE")) {
            i = 2;
            s2 = this.loopThroughHeaders(s2);
        }
        if (i == 0) {
            return str;
        }
        if (i == 1) {
            return s;
        }
        return s2;
    }

    private String loopThroughHeaders(String s) {
        int pos;
        boolean inQuote = false;
        for (pos = 0; pos < s.length() && (inQuote || s.charAt(pos) != '>'); ++pos) {
            if (s.charAt(pos) != '\"') continue;
            inQuote = !inQuote;
        }
        if (pos < s.length()) {
            s = s.substring(pos + 1);
        }
        if (s.charAt(0) == '\n') {
            s = s.substring(1);
        }
        return s;
    }
}

