/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.parameters;

import ptolemy.data.DoubleMatrixToken;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.Locatable;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;

public class LocationParameter
extends Parameter
implements Locatable {
    public LocationParameter(NamedObj container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.setTypeEquals(BaseType.DOUBLE_MATRIX);
        this.setExpression("[0.0, 0.0]");
    }

    @Override
    public String getDisplayName() {
        return this.getName();
    }

    @Override
    public double[] getLocation() {
        try {
            DoubleMatrixToken token = (DoubleMatrixToken)this.getToken();
            double[][] value = token.doubleMatrix();
            return value[0];
        }
        catch (IllegalActionException ex) {
            throw new InternalErrorException(ex);
        }
    }

    @Override
    public void setLocation(double[] location) throws IllegalActionException {
        double[][] value = new double[1][2];
        value[0][0] = location[0];
        value[0][1] = location[1];
        this.setToken(new DoubleMatrixToken(value, 1));
        this.propagateValue();
    }
}

