/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.util;

import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class TotallyOrderedSet {
    private final Comparator _comparator;
    private LinkedList _set;

    public TotallyOrderedSet(Comparator comparator) {
        this._comparator = comparator;
        this._set = new LinkedList();
    }

    public Object at(int index) {
        return this._set.get(index);
    }

    public void clear() {
        this._set.clear();
    }

    public boolean contains(Object object) {
        boolean result = false;
        for (Object next : this._set) {
            int comparator = this._comparator.compare(object, next);
            if (comparator == 0) {
                result = true;
                break;
            }
            if (comparator >= 0) continue;
            break;
        }
        return result;
    }

    public List elementList() {
        return this._set;
    }

    public Enumeration elements() {
        return Collections.enumeration(this._set);
    }

    public Object first() {
        if (this.isEmpty()) {
            return null;
        }
        return this._set.getFirst();
    }

    public Comparator getComparator() {
        return this._comparator;
    }

    public int indexOf(Object obj) {
        return this._set.indexOf(obj);
    }

    public void insert(Object obj) {
        int count = 0;
        for (Object next : this._set) {
            int comparisonResult = this._comparator.compare(obj, next);
            if (comparisonResult == 0) {
                return;
            }
            if (comparisonResult < 0) {
                this._set.add(count, obj);
                return;
            }
            ++count;
        }
        this._set.addLast(obj);
    }

    public boolean isEmpty() {
        return this._set.isEmpty();
    }

    public void removeAllLessThan(Object obj) {
        while (!this.isEmpty()) {
            Object first = this.first();
            int com = this._comparator.compare(obj, first);
            if (com <= 0) {
                return;
            }
            this.removeFirst();
        }
    }

    public Object removeAt(int index) {
        return this._set.remove(index);
    }

    public Object removeFirst() {
        return this._set.removeFirst();
    }

    public int size() {
        return this._set.size();
    }

    public Object take() {
        return this._set.removeFirst();
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        Iterator elements = this.elementList().iterator();
        while (elements.hasNext()) {
            result.append(elements.next().toString() + " ");
        }
        return result.toString();
    }
}

