/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.data;

import java.io.Serializable;
import ptolemy.data.BooleanToken;
import ptolemy.data.Token;
import ptolemy.data.type.Type;
import ptolemy.kernel.Entity;
import ptolemy.kernel.util.IllegalActionException;

public class ActorToken
extends Token {
    public static final Type TYPE = new ActorType();
    private Entity _entity;

    public ActorToken(Entity entity) throws IllegalActionException {
        try {
            this._entity = (Entity)entity.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalActionException(null, ex, "Failed to create actor token");
        }
    }

    public Entity getEntity() {
        try {
            return (Entity)this._entity.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException("Failed to clone actor, but I already cloned it once!!!");
        }
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public BooleanToken isEqualTo(Token token) throws IllegalActionException {
        if (token instanceof ActorToken) {
            return new BooleanToken(this == token);
        }
        throw new IllegalActionException("Equality test not supported between " + this.getClass().getName() + " and " + token.getClass().getName() + ".");
    }

    @Override
    public String toString() {
        return "ActorToken(" + this._entity + ")";
    }

    public static class ActorType
    implements Type,
    Serializable {
        @Override
        public Type add(Type rightArgumentType) {
            return this;
        }

        @Override
        public Object clone() {
            return this;
        }

        @Override
        public Token convert(Token token) throws IllegalActionException {
            if (token instanceof ActorToken) {
                return token;
            }
            throw new IllegalActionException("Attempt to convert token " + token + " into a test token, which is not possible.");
        }

        @Override
        public Type divide(Type rightArgumentType) {
            return this;
        }

        @Override
        public Class getTokenClass() {
            return ActorToken.class;
        }

        @Override
        public boolean isAbstract() {
            return false;
        }

        @Override
        public boolean isCompatible(Type type) {
            return type == this;
        }

        @Override
        public boolean isConstant() {
            return true;
        }

        public boolean equals(Type t) {
            return this == t;
        }

        @Override
        public int getTypeHash() {
            return Integer.MIN_VALUE;
        }

        @Override
        public boolean isInstantiable() {
            return true;
        }

        @Override
        public boolean isSubstitutionInstance(Type type) {
            return this == type;
        }

        @Override
        public Type modulo(Type rightArgumentType) {
            return this;
        }

        @Override
        public Type multiply(Type rightArgumentType) {
            return this;
        }

        @Override
        public Type one() {
            return this;
        }

        @Override
        public Type subtract(Type rightArgumentType) {
            return this;
        }

        @Override
        public String toString() {
            return "Actor";
        }

        @Override
        public Type zero() {
            return this;
        }
    }
}

