/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.data.expr;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.List;
import ptolemy.data.expr.ASTPtArrayConstructNode;
import ptolemy.data.expr.ASTPtBitwiseNode;
import ptolemy.data.expr.ASTPtFunctionApplicationNode;
import ptolemy.data.expr.ASTPtFunctionDefinitionNode;
import ptolemy.data.expr.ASTPtFunctionalIfNode;
import ptolemy.data.expr.ASTPtLeafNode;
import ptolemy.data.expr.ASTPtLogicalNode;
import ptolemy.data.expr.ASTPtMatrixConstructNode;
import ptolemy.data.expr.ASTPtMethodCallNode;
import ptolemy.data.expr.ASTPtPowerNode;
import ptolemy.data.expr.ASTPtProductNode;
import ptolemy.data.expr.ASTPtRecordConstructNode;
import ptolemy.data.expr.ASTPtRelationalNode;
import ptolemy.data.expr.ASTPtRootNode;
import ptolemy.data.expr.ASTPtShiftNode;
import ptolemy.data.expr.ASTPtSumNode;
import ptolemy.data.expr.ASTPtUnaryNode;
import ptolemy.data.expr.AbstractParseTreeVisitor;
import ptolemy.data.expr.Token;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.kernel.util.IllegalActionException;

public class ParseTreeWriter
extends AbstractParseTreeVisitor {
    private PrintWriter _writer = new PrintWriter(System.out);

    public void displayParseTree(ASTPtRootNode root) {
        this._writer = new PrintWriter(System.out);
        try {
            root.visit(this);
        }
        catch (IllegalActionException ex) {
            this._writer.println(ex);
            ex.printStackTrace(this._writer);
        }
    }

    public String parseTreeToExpression(ASTPtRootNode root) throws IllegalActionException {
        StringWriter writer = new StringWriter();
        this._writer = new PrintWriter(writer);
        root.visit(this);
        return writer.toString();
    }

    public String printParseTree(ASTPtRootNode root) {
        StringWriter writer = new StringWriter();
        this._writer = new PrintWriter(writer);
        try {
            root.visit(this);
        }
        catch (IllegalActionException ex) {
            this._writer.println(ex);
            ex.printStackTrace(this._writer);
        }
        return writer.toString();
    }

    @Override
    public void visitArrayConstructNode(ASTPtArrayConstructNode node) throws IllegalActionException {
        this._writer.print("{");
        this._printChildrenSeparated((ASTPtRootNode)node, ", ");
        this._writer.print("}");
    }

    @Override
    public void visitBitwiseNode(ASTPtBitwiseNode node) throws IllegalActionException {
        this._writer.print("(");
        this._printChildrenSeparated((ASTPtRootNode)node, node.getOperator().image);
        this._writer.print(")");
    }

    @Override
    public void visitFunctionApplicationNode(ASTPtFunctionApplicationNode node) throws IllegalActionException {
        this._printChild(node, 0);
        this._writer.print("(");
        int n = node.jjtGetNumChildren();
        for (int i = 1; i < n - 1; ++i) {
            this._printChild(node, i);
            this._writer.print(", ");
        }
        if (n > 1) {
            this._printChild(node, n - 1);
        }
        this._writer.print(")");
    }

    @Override
    public void visitFunctionDefinitionNode(ASTPtFunctionDefinitionNode node) throws IllegalActionException {
        this._writer.print("(function(");
        List args = node.getArgumentNameList();
        Type[] argTypes = node.getArgumentTypes();
        int n = args.size();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                this._writer.print(", ");
            }
            this._writer.print((String)args.get(i));
            Type type = argTypes[i];
            if (type == BaseType.GENERAL) continue;
            this._writer.print(":");
            this._writer.print(((Object)type).toString());
        }
        this._writer.print(") ");
        node.getExpressionTree().visit(this);
        this._writer.print(")");
    }

    @Override
    public void visitFunctionalIfNode(ASTPtFunctionalIfNode node) throws IllegalActionException {
        this._writer.print("(");
        this._printChild(node, 0);
        this._writer.print("?");
        this._printChild(node, 1);
        this._writer.print(":");
        this._printChild(node, 2);
        this._writer.print(")");
    }

    @Override
    public void visitLeafNode(ASTPtLeafNode node) throws IllegalActionException {
        if (node.isConstant() && node.isEvaluated()) {
            this._writer.print(node.getToken().toString());
        } else {
            this._writer.print(node.getName());
        }
    }

    @Override
    public void visitLogicalNode(ASTPtLogicalNode node) throws IllegalActionException {
        this._writer.print("(");
        this._printChildrenSeparated((ASTPtRootNode)node, node.getOperator().image);
        this._writer.print(")");
    }

    @Override
    public void visitMatrixConstructNode(ASTPtMatrixConstructNode node) throws IllegalActionException {
        this._writer.print("[");
        int n = 0;
        int rowCount = node.getRowCount();
        int columnCount = node.getColumnCount();
        for (int i = 0; i < rowCount; ++i) {
            for (int j = 0; j < columnCount; ++j) {
                this._printChild(node, n++);
                if (j >= columnCount - 1) continue;
                this._writer.print(", ");
            }
            if (i >= rowCount - 1) continue;
            this._writer.print("; ");
        }
        this._writer.print("]");
    }

    @Override
    public void visitMethodCallNode(ASTPtMethodCallNode node) throws IllegalActionException {
        this._printChild(node, 0);
        this._writer.print(".");
        this._writer.print(node.getMethodName());
        this._writer.print("(");
        if (node.jjtGetNumChildren() > 1) {
            this._printChild(node, 1);
            for (int i = 2; i < node.jjtGetNumChildren(); ++i) {
                this._writer.print(", ");
                this._printChild(node, i);
            }
        }
        this._writer.print(")");
    }

    @Override
    public void visitPowerNode(ASTPtPowerNode node) throws IllegalActionException {
        this._printChildrenSeparated((ASTPtRootNode)node, "^");
    }

    @Override
    public void visitProductNode(ASTPtProductNode node) throws IllegalActionException {
        this._writer.print("(");
        this._printChildrenSeparated((ASTPtRootNode)node, node.getLexicalTokenList());
        this._writer.print(")");
    }

    @Override
    public void visitRecordConstructNode(ASTPtRecordConstructNode node) throws IllegalActionException {
        Iterator names = node.getFieldNames().iterator();
        this._writer.print("{");
        if (node.jjtGetNumChildren() > 0) {
            this._writer.print(names.next());
            this._writer.print("=");
            this._printChild(node, 0);
            for (int i = 1; i < node.jjtGetNumChildren(); ++i) {
                this._writer.print(", ");
                this._writer.print(names.next());
                this._writer.print("=");
                this._printChild(node, i);
            }
        }
        this._writer.print("}");
    }

    @Override
    public void visitRelationalNode(ASTPtRelationalNode node) throws IllegalActionException {
        this._writer.print("(");
        this._printChildrenSeparated((ASTPtRootNode)node, node.getOperator().image);
        this._writer.print(")");
    }

    @Override
    public void visitShiftNode(ASTPtShiftNode node) throws IllegalActionException {
        this._writer.print("(");
        this._printChildrenSeparated((ASTPtRootNode)node, node.getOperator().image);
        this._writer.print(")");
    }

    @Override
    public void visitSumNode(ASTPtSumNode node) throws IllegalActionException {
        this._writer.print("(");
        this._printChildrenSeparated((ASTPtRootNode)node, node.getLexicalTokenList());
        this._writer.print(")");
    }

    @Override
    public void visitUnaryNode(ASTPtUnaryNode node) throws IllegalActionException {
        if (node.isMinus()) {
            this._writer.print("-");
        } else if (node.isNot()) {
            this._writer.print("!");
        } else {
            this._writer.print("~");
        }
        this._printChild(node, 0);
    }

    private void _printChild(ASTPtRootNode node, int index) throws IllegalActionException {
        ASTPtRootNode child = (ASTPtRootNode)node.jjtGetChild(index);
        child.visit(this);
    }

    private void _printChildrenSeparated(ASTPtRootNode node, String string) throws IllegalActionException {
        if (node.jjtGetNumChildren() > 0) {
            this._printChild(node, 0);
            for (int i = 1; i < node.jjtGetNumChildren(); ++i) {
                this._writer.print(string);
                this._printChild(node, i);
            }
        }
    }

    private void _printChildrenSeparated(ASTPtRootNode node, List separatorList) throws IllegalActionException {
        Iterator separators = separatorList.iterator();
        if (node.jjtGetNumChildren() > 0) {
            this._printChild(node, 0);
            for (int i = 1; i < node.jjtGetNumChildren(); ++i) {
                Token separator = (Token)separators.next();
                this._writer.print(separator.image);
                this._printChild(node, i);
            }
        }
    }
}

