/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.data.expr;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;
import ptolemy.data.ArrayToken;
import ptolemy.data.BooleanToken;
import ptolemy.data.ComplexMatrixToken;
import ptolemy.data.ComplexToken;
import ptolemy.data.DoubleMatrixToken;
import ptolemy.data.DoubleToken;
import ptolemy.data.FunctionToken;
import ptolemy.data.IntMatrixToken;
import ptolemy.data.IntToken;
import ptolemy.data.LongMatrixToken;
import ptolemy.data.LongToken;
import ptolemy.data.ObjectToken;
import ptolemy.data.RecordToken;
import ptolemy.data.ScalarToken;
import ptolemy.data.StringToken;
import ptolemy.data.Token;
import ptolemy.data.UnsignedByteToken;
import ptolemy.data.UnsizedArrayToken;
import ptolemy.data.expr.ASTPtRootNode;
import ptolemy.data.expr.Constants;
import ptolemy.data.expr.MatrixParser;
import ptolemy.data.expr.ParseTreeEvaluator;
import ptolemy.data.expr.ParseTreeTypeInference;
import ptolemy.data.expr.PtParser;
import ptolemy.data.type.ArrayType;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.FunctionType;
import ptolemy.data.type.Type;
import ptolemy.data.type.TypeLattice;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.math.ComplexMatrixMath;
import ptolemy.util.StringUtilities;

public class UtilityFunctions {
    private static TokenComparator _ASCENDING = new TokenComparator(true);
    private static TokenComparator _DESCENDING = new TokenComparator(false);
    private static MatrixParser _matrixParser;
    private static Random _random;

    public static ArrayToken arrayType(Token t) {
        return new UnsizedArrayToken(t.getType());
    }

    public static Type arrayTypeReturnType(Type type) {
        return new ArrayType(type);
    }

    public static ArrayToken arrayType(Token t, IntToken numberOfTimes) {
        return UtilityFunctions.repeat(numberOfTimes, t);
    }

    public static Type arrayTypeReturnType(Type type1, Type type2) {
        return new ArrayType(type2);
    }

    public static String asURL(String fileName) {
        File file = new File(fileName);
        try {
            URL url = file.toURI().toURL();
            return url.toString();
        }
        catch (MalformedURLException malformed) {
            throw new RuntimeException("could not convert '" + file + "' to a URL", malformed);
        }
    }

    public static Token cast(Token token1, Token token2) throws IllegalActionException {
        return token1.getType().convert(token2);
    }

    public static ArrayToken concatenate(ArrayToken token1, ArrayToken token2) throws IllegalActionException {
        Token[] array1 = token1.arrayValue();
        Token[] array2 = token2.arrayValue();
        int nElements = array1.length + array2.length;
        Token[] resultArray = new Token[nElements];
        System.arraycopy(array1, 0, resultArray, 0, array1.length);
        System.arraycopy(array2, 0, resultArray, array1.length, array2.length);
        return new ArrayToken(resultArray);
    }

    public static ArrayToken concatenate(ArrayToken token) throws IllegalActionException {
        if (!(token.getElementType() instanceof ArrayType)) {
            throw new IllegalActionException("The argument to concatenate(ArrayToken) must be an array of arrays.");
        }
        int nElements = 0;
        for (int i = 0; i < token.length(); ++i) {
            nElements += ((ArrayToken)token.getElement(i)).length();
        }
        Token[] result = new Token[nElements];
        int cursor = 0;
        for (int i = 0; i < token.length(); ++i) {
            Token[] array = ((ArrayToken)token.getElement(i)).arrayValue();
            System.arraycopy(array, 0, result, cursor, array.length);
            cursor += array.length;
        }
        return new ArrayToken(result);
    }

    public static RecordToken constants() {
        return Constants.constants();
    }

    public static RecordToken emptyRecord() throws IllegalActionException {
        return new RecordToken(new String[0], new Token[0]);
    }

    public static ArrayToken emptyArray(Token prototype) {
        return new ArrayToken(prototype.getType());
    }

    public static ArrayToken filter(FunctionToken predicate, ArrayToken array) throws IllegalActionException {
        return UtilityFunctions.filter(predicate, array, new IntToken(-1));
    }

    public static ArrayToken filter(FunctionToken predicate, ArrayToken array, IntToken sizeLimit) throws IllegalActionException {
        LinkedList<Token> result = new LinkedList<Token>();
        int arity = predicate.getNumberOfArguments();
        if (arity != 1) {
            throw new IllegalActionException("The predicate argument of filter() must be a function that takes one argument.");
        }
        int sizeLimitValue = sizeLimit.intValue();
        for (int i = 0; i < array.length(); ++i) {
            Token element = array.getElement(i);
            Token[] elementList = new Token[]{element};
            Token include = predicate.apply(elementList);
            if (include instanceof BooleanToken && ((BooleanToken)include).booleanValue()) {
                result.add(element);
            }
            if (sizeLimitValue >= 0 && result.size() >= sizeLimitValue) break;
        }
        if (result.size() > 0) {
            Token[] resultArray = new Token[result.size()];
            resultArray = result.toArray(resultArray);
            return new ArrayToken(resultArray);
        }
        return new ArrayToken(array.getElementType());
    }

    public static Type filterReturnType(Type predicateType, Type arrayTokenType) throws IllegalActionException {
        return UtilityFunctions.filterReturnType(predicateType, arrayTokenType, null);
    }

    public static Type filterReturnType(Type predicateType, Type arrayTokenType, Type sizeLimitType) throws IllegalActionException {
        if (predicateType instanceof FunctionType) {
            FunctionType castPredicateType = (FunctionType)predicateType;
            if (castPredicateType.getArgCount() != 1) {
                throw new IllegalActionException("filter() can only be used on functions that take one argument.");
            }
            Type argType = castPredicateType.getArgType(0);
            int comparison = TypeLattice.compare(((ArrayType)arrayTokenType).getElementType(), argType);
            if (comparison != -1 && comparison != 0) {
                throw new IllegalActionException("filter(): specified array element is not compatible with function argument type.");
            }
            return new ArrayType(((ArrayType)arrayTokenType).getElementType());
        }
        return BaseType.UNKNOWN;
    }

    public static ArrayToken find(ArrayToken array) throws IllegalActionException {
        if (array.getElementType() != BaseType.BOOLEAN) {
            throw new IllegalActionException("The argument must be an array of boolean tokens.");
        }
        return UtilityFunctions.find(array, BooleanToken.TRUE);
    }

    public static ArrayToken find(ArrayToken array, Token match) {
        LinkedList<IntToken> result = new LinkedList<IntToken>();
        for (int i = 0; i < array.length(); ++i) {
            if (!array.getElement(i).equals(match)) continue;
            result.add(new IntToken(i));
        }
        if (result.size() > 0) {
            Token[] resultArray = new Token[result.size()];
            resultArray = result.toArray(resultArray);
            try {
                return new ArrayToken(BaseType.INT, resultArray);
            }
            catch (IllegalActionException e) {
                throw new InternalErrorException(e);
            }
        }
        return new ArrayToken(array.getElementType());
    }

    public static String findFile(String name) {
        String curDir;
        File file = new File(name);
        if (file.exists()) {
            try {
                file = new File(file.getCanonicalPath());
            }
            catch (IOException ex) {
                file = file.getAbsoluteFile();
            }
        }
        if (!file.exists()) {
            curDir = StringUtilities.getProperty("user.dir");
            file = new File(curDir, name);
        }
        if (!file.exists()) {
            curDir = StringUtilities.getProperty("user.home");
            file = new File(curDir, name);
        }
        if (!file.exists()) {
            String token;
            String cp = System.getProperty("java.class.path");
            StringTokenizer tokens = new StringTokenizer(cp, System.getProperty("path.separator"));
            while (tokens.hasMoreTokens() && !(file = new File(token = tokens.nextToken(), name)).exists()) {
            }
        }
        if (file.exists()) {
            try {
                return file.getCanonicalPath();
            }
            catch (IOException ex) {
                return file.getAbsolutePath();
            }
        }
        return name;
    }

    public static LongToken freeMemory() {
        return new LongToken(Runtime.getRuntime().freeMemory());
    }

    public static DoubleToken gaussian(double mean, double standardDeviation) {
        if (_random == null) {
            _random = new Random();
        }
        double raw = _random.nextGaussian();
        double result = raw * standardDeviation + mean;
        return new DoubleToken(result);
    }

    public static ArrayToken gaussian(double mean, double standardDeviation, int length) {
        if (_random == null) {
            _random = new Random();
        }
        Token[] result = new DoubleToken[length];
        for (int i = 0; i < length; ++i) {
            double raw = _random.nextGaussian();
            result[i] = new DoubleToken(raw * standardDeviation + mean);
        }
        try {
            return new ArrayToken(BaseType.DOUBLE, result);
        }
        catch (IllegalActionException illegalAction) {
            throw new InternalErrorException("UtilityFunction.gaussian: Cannot create the array that contains Gaussian random numbers.");
        }
    }

    public static DoubleMatrixToken gaussian(double mean, double standardDeviation, int rows, int columns) {
        if (_random == null) {
            _random = new Random();
        }
        double[][] result = new double[rows][columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                double raw = _random.nextGaussian();
                result[i][j] = raw * standardDeviation + mean;
            }
        }
        try {
            return new DoubleMatrixToken(result);
        }
        catch (IllegalActionException illegalAction) {
            throw new InternalErrorException("UtilityFunction.gaussian: Cannot create the DoubleMatrixToken that contains Gaussian random numbers.");
        }
    }

    public static String getProperty(String propertyName) {
        return StringUtilities.getProperty(propertyName);
    }

    public static String inferType(String string) throws IllegalActionException {
        PtParser parser = new PtParser();
        ASTPtRootNode parseTree = parser.generateParseTree(string);
        ParseTreeTypeInference typeInference = new ParseTreeTypeInference();
        return ((Object)typeInference.inferTypes(parseTree)).toString();
    }

    public static Token intersect(RecordToken record1, RecordToken record2) throws IllegalActionException {
        HashSet commonNames = new HashSet(record1.labelSet());
        commonNames.retainAll(record2.labelSet());
        Token[] values = new Token[commonNames.size()];
        String[] names = new String[values.length];
        int i = 0;
        for (String name : commonNames) {
            values[i] = record1.get(name);
            names[i] = name;
            ++i;
        }
        return new RecordToken(names, values);
    }

    public static ArrayToken iterate(FunctionToken function, int length, Token initial) throws IllegalActionException {
        int arity = function.getNumberOfArguments();
        if (arity != 1) {
            throw new IllegalActionException("iterate() can only be used on functions that take one argument.");
        }
        if (length < 2) {
            throw new IllegalActionException("iterate() requires the length argument to be greater than 1.");
        }
        Token[] result = new Token[length];
        Token iterate = initial;
        result[0] = initial;
        for (int i = 1; i < length; ++i) {
            Token[] args = new Token[]{iterate};
            result[i] = iterate = function.apply(args);
        }
        return new ArrayToken(result);
    }

    public static Type iterateReturnType(Type functionType, Type lengthType, Type initialType) throws IllegalActionException {
        if (functionType instanceof FunctionType) {
            FunctionType castFunctionType = (FunctionType)functionType;
            if (castFunctionType.getArgCount() != 1) {
                throw new IllegalActionException("iterate() can only be used on functions that take one argument.");
            }
            Type argType = castFunctionType.getArgType(0);
            int comparison = TypeLattice.compare(initialType, argType);
            if (comparison != -1 && comparison != 0) {
                throw new IllegalActionException("iterate(): specified initial value is not compatible with function argument type.");
            }
            Type resultType = castFunctionType.getReturnType();
            int comparison2 = TypeLattice.compare(resultType, argType);
            if (comparison2 != -1 && comparison2 != 0) {
                throw new IllegalActionException("iterate(): invalid function: function return type is not compatible with function argument type.");
            }
            return new ArrayType(TypeLattice.leastUpperBound(resultType, initialType));
        }
        return BaseType.UNKNOWN;
    }

    public static void loadLibrary(String library) {
        try {
            if (library.indexOf("/") == -1 && library.indexOf("\\") == -1) {
                System.loadLibrary(library);
            } else {
                System.load(library);
            }
        }
        catch (UnsatisfiedLinkError ex) {
            int index;
            String sharedLibrarySuffix = "dll";
            String shortLibraryName = null;
            String osName = StringUtilities.getProperty("os.name");
            if (osName.startsWith("SunOS") || osName.startsWith("Linux") || osName.startsWith("Mac OS X")) {
                sharedLibrarySuffix = osName.startsWith("Mac OS X") ? "dylib" : "so";
                index = library.lastIndexOf("/");
                if (index == -1) {
                    if (!library.startsWith("lib")) {
                        library = "lib" + library;
                    }
                    shortLibraryName = library;
                } else if (!library.substring(index, index + 4).equals("/lib")) {
                    if (osName.startsWith("Mac OS X")) {
                        shortLibraryName = library = library.substring(index + 1);
                    } else {
                        shortLibraryName = "/lib" + library.substring(index + 1);
                        library = library.substring(0, index) + shortLibraryName;
                    }
                }
            } else {
                index = library.lastIndexOf("/");
                if (index != -1) {
                    shortLibraryName = library.substring(index + 1);
                }
            }
            String libraryWithSuffix = library + "." + sharedLibrarySuffix;
            String libraryPath = UtilityFunctions.findFile(libraryWithSuffix);
            boolean libraryPathExists = false;
            try {
                File libraryPathFile = new File(libraryPath);
                if (libraryPathFile.exists()) {
                    libraryPathExists = true;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (libraryPath.equals(libraryWithSuffix) || !libraryPathExists) {
                try {
                    if (shortLibraryName != null) {
                        System.loadLibrary(shortLibraryName);
                    }
                    return;
                }
                catch (UnsatisfiedLinkError ex2) {
                    String userDir = "<<user.dir unknown>>";
                    try {
                        userDir = System.getProperty("user.dir");
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    String userHome = "<<user.home unknown>>";
                    try {
                        userHome = System.getProperty("user.home");
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    String classpath = "<<classpath unknown>>";
                    try {
                        classpath = System.getProperty("java.class.path");
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    UnsatisfiedLinkError error = new UnsatisfiedLinkError("Did not find '" + library + "' in path, searched " + "user.home (" + userDir + ") user.dir (" + userHome + ") and the classpath for '" + libraryPath + "', but that " + "was not found either.\n" + "classpath was: " + classpath + " Also tried loadLibrary(\"" + shortLibraryName + "\", exception for loadLibrary was: " + ex2);
                    error.initCause(ex);
                    throw error;
                }
            }
            System.load(libraryPath);
        }
    }

    public static ArrayToken map(FunctionToken function, ArrayToken array) throws IllegalActionException {
        int arity = function.getNumberOfArguments();
        Token[] result = new Token[array.length()];
        if (arity == 1) {
            for (int i = 0; i < array.length(); ++i) {
                Token arg = array.getElement(i);
                Token[] args = new Token[]{arg};
                result[i] = function.apply(args);
            }
        } else if (arity > 1) {
            for (int i = 0; i < array.length(); ++i) {
                Token args = array.getElement(i);
                if (!(args instanceof ArrayToken)) {
                    throw new IllegalActionException("Invalid arguments to map(): mismatched arity.");
                }
                Token[] invokeArgs = new Token[arity];
                ArrayToken castArgs = (ArrayToken)args;
                if (castArgs.length() != arity) {
                    throw new IllegalActionException("Invalid arguments to map(): mismatched arity.");
                }
                for (int j = 0; j < arity; ++j) {
                    invokeArgs[j] = castArgs.getElement(j);
                }
                result[i] = function.apply(invokeArgs);
            }
        } else {
            throw new IllegalActionException("map() can only be used on functions that take at least one argument.");
        }
        return new ArrayToken(result);
    }

    public static Type mapReturnType(Type functionType, Type arrayTokenType) throws IllegalActionException {
        if (functionType instanceof FunctionType) {
            FunctionType castFunctionType = (FunctionType)functionType;
            if (castFunctionType.getArgCount() == 1) {
                Type argType = castFunctionType.getArgType(0);
                int comparison = TypeLattice.compare(((ArrayType)arrayTokenType).getElementType(), argType);
                if (comparison != -1 && comparison != 0) {
                    throw new IllegalActionException("map(): specified array token is not compatible with function argument type.");
                }
            } else if (castFunctionType.getArgCount() > 1) {
                Type firstArgType = castFunctionType.getArgType(0);
                boolean flag = true;
                for (int i = 1; i < castFunctionType.getArgCount(); ++i) {
                    Type argType = castFunctionType.getArgType(i);
                    if (argType == firstArgType) continue;
                    i = castFunctionType.getArgCount();
                    flag = false;
                    throw new IllegalActionException("map() can only work for functions whose arguments are all of the same type.");
                }
                if (flag) {
                    Type argType = castFunctionType.getArgType(0);
                    Type elementType = ((ArrayType)arrayTokenType).getElementType();
                    if (!(elementType instanceof ArrayType)) {
                        throw new IllegalActionException("map(): specified array token is not compatible with function arity.");
                    }
                    int comparison = TypeLattice.compare(((ArrayType)elementType).getElementType(), argType);
                    if (comparison != -1 && comparison != 0) {
                        throw new IllegalActionException("map(): specified array token is not compatible with function argument type.");
                    }
                }
            }
            Type resultType = castFunctionType.getReturnType();
            return new ArrayType(resultType);
        }
        return BaseType.UNKNOWN;
    }

    public static UnsignedByteToken max(UnsignedByteToken x, UnsignedByteToken y) {
        if (x.intValue() > y.intValue()) {
            return x;
        }
        return y;
    }

    public static ScalarToken max(ArrayToken array) throws IllegalActionException {
        if (array.length() == 0 || !BaseType.SCALAR.isCompatible(array.getElementType())) {
            throw new IllegalActionException("max function can only be applied to arrays of scalars.");
        }
        ScalarToken result = (ScalarToken)array.getElement(0);
        for (int i = 1; i < array.length(); ++i) {
            ScalarToken element = (ScalarToken)array.getElement(i);
            if (!element.isGreaterThan(result).booleanValue()) continue;
            result = element;
        }
        return result;
    }

    public static Type maxReturnType(Type type) {
        if (type instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)type;
            return arrayType.getElementType();
        }
        return BaseType.UNKNOWN;
    }

    public static UnsignedByteToken min(UnsignedByteToken x, UnsignedByteToken y) {
        if (x.intValue() < y.intValue()) {
            return x;
        }
        return y;
    }

    public static ScalarToken min(ArrayToken array) throws IllegalActionException {
        if (array.length() == 0 || !BaseType.SCALAR.isCompatible(array.getElementType())) {
            throw new IllegalActionException("min function can only be applied to arrays of scalars.");
        }
        ScalarToken result = (ScalarToken)array.getElement(0);
        for (int i = 1; i < array.length(); ++i) {
            ScalarToken element = (ScalarToken)array.getElement(i);
            if (!element.isLessThan(result).booleanValue()) continue;
            result = element;
        }
        return result;
    }

    public static Type minReturnType(Type type) {
        if (type instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)type;
            return arrayType.getElementType();
        }
        return BaseType.UNKNOWN;
    }

    public static ObjectToken model(String classname) throws IllegalActionException {
        return new ObjectToken(classname);
    }

    public static StringToken property(String propertyName) {
        return new StringToken(StringUtilities.getProperty(propertyName));
    }

    public static ArrayToken random(int length) {
        Token[] result = new DoubleToken[length];
        for (int i = 0; i < length; ++i) {
            result[i] = new DoubleToken(Math.random());
        }
        try {
            return new ArrayToken(BaseType.DOUBLE, result);
        }
        catch (IllegalActionException illegalAction) {
            throw new InternalErrorException("UtilityFunction.random: Cannot create the array that contains random numbers.");
        }
    }

    public static DoubleMatrixToken random(int rows, int columns) {
        double[][] result = new double[rows][columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                result[i][j] = Math.random();
            }
        }
        try {
            return new DoubleMatrixToken(result);
        }
        catch (IllegalActionException illegalAction) {
            throw new InternalErrorException("UtilityFunction.random: Cannot create the DoubleMatrixToken that contains random numbers.");
        }
    }

    public static Type randomReturnType(Type type) {
        if (((Object)type).equals(BaseType.INT)) {
            return new ArrayType(BaseType.DOUBLE);
        }
        return BaseType.UNKNOWN;
    }

    public static StringToken readFile(String filename) throws IllegalActionException {
        File file = new File(UtilityFunctions.findFile(filename));
        BufferedReader fin = null;
        StringBuffer result = new StringBuffer("");
        String newline = System.getProperty("line.separator");
        try {
            fin = new BufferedReader(new FileReader(file));
            while (true) {
                String line;
                try {
                    line = fin.readLine();
                }
                catch (IOException e) {
                    break;
                }
                if (line == null) {
                    break;
                }
                result.append(line + newline);
            }
        }
        catch (FileNotFoundException ex) {
            throw new IllegalActionException(null, ex, "File not found");
        }
        finally {
            if (fin != null) {
                try {
                    fin.close();
                }
                catch (IOException ex) {
                    throw new IllegalActionException(null, ex, "Problem closing '" + file + "'");
                }
            }
        }
        return new StringToken(result.toString());
    }

    public static DoubleMatrixToken readMatrix(String filename) throws IllegalActionException {
        DoubleMatrixToken returnMatrix = null;
        File file = new File(filename);
        FileReader fin = null;
        Vector k = null;
        int row = -1;
        int column = -1;
        int rowPosition = 0;
        int columnPosition = 0;
        double[][] mtr = null;
        if (file.exists()) {
            try {
                fin = new FileReader(file);
            }
            catch (FileNotFoundException e) {
                throw new IllegalActionException("FIle Not FOUND");
            }
            if (_matrixParser == null) {
                _matrixParser = new MatrixParser(System.in);
            }
            MatrixParser.ReInit(fin);
            k = _matrixParser.readMatrix();
            if (column == -1) {
                column = k.size();
            }
            for (Vector l : k) {
                if (row == -1) {
                    row = l.size();
                    mtr = new double[column][row];
                } else if (row != l.size()) {
                    throw new IllegalActionException(" The Row size needs to be the same for all rows");
                }
                for (Double s : l) {
                    mtr[columnPosition][rowPosition++] = s;
                }
                rowPosition = 0;
                ++columnPosition;
            }
        } else {
            throw new IllegalActionException("ReadMatrix: File " + filename + " not Found");
        }
        k.removeAll(k);
        returnMatrix = new DoubleMatrixToken(mtr);
        return returnMatrix;
    }

    public static StringToken readResource(String name) throws IllegalActionException {
        URL url = ClassLoader.getSystemResource(name);
        StringBuffer result = new StringBuffer("");
        BufferedReader fin = null;
        try {
            InputStream stream = url.openStream();
            String newline = System.getProperty("line.separator");
            fin = new BufferedReader(new InputStreamReader(stream));
            while (true) {
                String line;
                try {
                    line = fin.readLine();
                }
                catch (IOException e) {
                    break;
                }
                if (line == null) {
                    break;
                }
                result.append(line + newline);
            }
        }
        catch (IOException ex) {
            throw new IllegalActionException(null, ex, "File not found");
        }
        finally {
            if (fin != null) {
                try {
                    fin.close();
                }
                catch (IOException ex) {
                    throw new IllegalActionException(null, ex, "Failed to close '" + name + "'");
                }
            }
        }
        return new StringToken(result.toString());
    }

    public static ArrayToken repeat(IntToken numberOfTimes, Token element) {
        ArrayToken arrayToken;
        int length = numberOfTimes.intValue();
        Token[] result = new Token[length];
        for (int i = 0; i < length; ++i) {
            result[i] = element;
        }
        try {
            arrayToken = new ArrayToken(element.getType(), result);
        }
        catch (IllegalActionException illegalAction) {
            throw new InternalErrorException("UtilityFunctions.repeat: Cannot construct ArrayToken. " + illegalAction.getMessage());
        }
        catch (IllegalArgumentException illegalArgument) {
            throw new InternalErrorException("UtilityFunctions.repeat: Cannot construct ArrayToken. " + illegalArgument.getMessage());
        }
        return arrayToken;
    }

    public static Type repeatReturnType(Type type1, Type type2) {
        return new ArrayType(type2);
    }

    public static ArrayToken sort(ArrayToken array) throws IllegalActionException {
        if (array.length() == 0) {
            return array;
        }
        Token[] value = array.arrayValue();
        Arrays.sort(value, _ASCENDING);
        return new ArrayToken(array.getElementType(), value);
    }

    public static Type sortReturnType(Type type) {
        if (type instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)type;
            Type elementType = arrayType.getElementType();
            if (((Object)elementType).equals(BaseType.COMPLEX)) {
                return BaseType.UNKNOWN;
            }
            if (((Object)elementType).equals(BaseType.STRING) || BaseType.SCALAR.isCompatible(elementType)) {
                return type;
            }
        }
        return BaseType.UNKNOWN;
    }

    public static ArrayToken sortAscending(ArrayToken array) throws IllegalActionException {
        return UtilityFunctions.sort(array);
    }

    public static Type sortAscendingReturnType(Type type) {
        return UtilityFunctions.sortReturnType(type);
    }

    public static ArrayToken sortDescending(ArrayToken array) throws IllegalActionException {
        if (array.length() == 0) {
            return array;
        }
        Token[] value = array.arrayValue();
        Arrays.sort(value, _DESCENDING);
        return new ArrayToken(array.getElementType(), value);
    }

    public static Type sortDescendingReturnType(Type type) {
        return UtilityFunctions.sortReturnType(type);
    }

    public static ArrayToken subarray(ArrayToken array, IntToken index, IntToken count) throws IllegalActionException {
        return array.subarray(index.intValue(), count.intValue());
    }

    public static Type subarrayReturnType(Type arrayType, Type indexType, Type countType) {
        return arrayType;
    }

    public static final Token sum(ArrayToken array) throws IllegalActionException {
        if (array == null || array.length() < 1) {
            throw new IllegalActionException("sum() function cannot be applied to an empty array");
        }
        if (array.getElement(0) instanceof StringToken) {
            int length = 0;
            for (int i = 0; i < array.length(); ++i) {
                length += ((StringToken)array.getElement(i)).stringValue().length();
            }
            StringBuffer buffer = new StringBuffer(length);
            for (int i = 0; i < array.length(); ++i) {
                buffer.append(((StringToken)array.getElement(i)).stringValue());
            }
            return new StringToken(buffer.toString());
        }
        Token result = array.getElement(0);
        for (int i = 1; i < array.length(); ++i) {
            result = result.add(array.getElement(i));
        }
        return result;
    }

    public static Type sumReturnType(Type type) {
        if (type instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)type;
            return arrayType.getElementType();
        }
        return BaseType.UNKNOWN;
    }

    public static LongToken totalMemory() {
        return new LongToken(Runtime.getRuntime().totalMemory());
    }

    public static String traceEvaluation(String string) throws IllegalActionException {
        PtParser parser = new PtParser();
        ASTPtRootNode parseTree = parser.generateParseTree(string);
        ParseTreeEvaluator evaluator = new ParseTreeEvaluator();
        return evaluator.traceParseTreeEvaluation(parseTree, null);
    }

    public static BooleanToken within(Token token1, Token token2, double distance) throws IllegalActionException {
        return token1.isCloseTo(token2, distance);
    }

    public static DoubleMatrixToken zeroMatrix(int rows, int columns) {
        return UtilityFunctions.zeroMatrixDouble(rows, columns);
    }

    public static ComplexMatrixToken zeroMatrixComplex(int rows, int columns) {
        try {
            return new ComplexMatrixToken(ComplexMatrixMath.zero(rows, columns));
        }
        catch (IllegalActionException ex) {
            throw new InternalErrorException("UtilityFunctions.zeroMatrixComplex: Cannot create ComplexMatrixToken. " + ex.getMessage());
        }
    }

    public static DoubleMatrixToken zeroMatrixDouble(int rows, int columns) {
        double[][] mtr = new double[rows][columns];
        DoubleMatrixToken result = null;
        try {
            result = new DoubleMatrixToken(mtr, 1);
        }
        catch (IllegalActionException ex) {
            throw new InternalErrorException("UtilityFunctions.zeroMatrixDouble: Cannot create DoubleMatrixToken. " + ex.getMessage());
        }
        return result;
    }

    public static IntMatrixToken zeroMatrixInt(int rows, int columns) {
        int[][] mtr = new int[rows][columns];
        IntMatrixToken result = null;
        try {
            result = new IntMatrixToken(mtr, 1);
        }
        catch (IllegalActionException ex) {
            throw new InternalErrorException("UtilityFunctions.zeroMatrixInt: Cannot create IntMatrixToken. " + ex.getMessage());
        }
        return result;
    }

    public static LongMatrixToken zeroMatrixLong(int rows, int columns) {
        long[][] mtr = new long[rows][columns];
        LongMatrixToken result = null;
        try {
            result = new LongMatrixToken(mtr, 1);
        }
        catch (IllegalActionException ex) {
            throw new InternalErrorException("UtilityFunctions.zeroMatrixLong: Cannot create LongMatrixToken. " + ex.getMessage());
        }
        return result;
    }

    private static class TokenComparator
    implements Comparator {
        private boolean _ascending;

        public TokenComparator(boolean ascending) {
            this._ascending = ascending;
        }

        public int compare(Object arg0, Object arg1) throws ClassCastException {
            if (arg0 instanceof StringToken && arg1 instanceof StringToken) {
                String string0 = ((StringToken)arg0).stringValue();
                String string1 = ((StringToken)arg1).stringValue();
                int result = string0.compareTo(string1);
                if (this._ascending) {
                    return result;
                }
                return -1 * result;
            }
            if (arg0 instanceof ScalarToken && arg1 instanceof ScalarToken && !(arg0 instanceof ComplexToken) && !(arg1 instanceof ComplexToken)) {
                ScalarToken cast0 = (ScalarToken)arg0;
                ScalarToken cast1 = (ScalarToken)arg1;
                try {
                    if (cast0.isEqualTo(cast1).booleanValue()) {
                        return 0;
                    }
                    if (cast0.isLessThan(cast1).booleanValue()) {
                        if (this._ascending) {
                            return -1;
                        }
                        return 1;
                    }
                    if (this._ascending) {
                        return 1;
                    }
                    return -1;
                }
                catch (IllegalActionException ex) {
                    // empty catch block
                }
            }
            throw new ClassCastException("Sorting only works on arrays of strings or non-complex scalars.");
        }
    }
}

