/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.data.expr;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class XMLParser {
    private DocumentBuilderFactory _documentBuilderFactory;
    private DocumentBuilder _documentBuilder;

    public XMLParser() throws Exception {
        if (this._documentBuilderFactory == null) {
            this._documentBuilderFactory = DocumentBuilderFactory.newInstance();
        }
        this._documentBuilder = this._documentBuilderFactory.newDocumentBuilder();
        this._documentBuilder.setEntityResolver(new EntityResolver());
    }

    public Document parser(String str) throws Exception {
        return this._documentBuilder.parse(new InputSource(new StringReader(str)));
    }

    public Document parser(InputStream is) throws Exception {
        return this._documentBuilder.parse(is);
    }

    public static class EntityResolver
    implements org.xml.sax.EntityResolver {
        private static final Hashtable _localResources = new Hashtable();

        @Override
        public InputSource resolveEntity(String publicId, String systemId) {
            if (publicId == null) {
                return null;
            }
            if (_localResources.containsKey(publicId)) {
                String localFile = (String)_localResources.get(publicId);
                InputStream localStream = this.getClass().getResourceAsStream(localFile);
                if (localStream != null) {
                    return new InputSource(localStream);
                }
            }
            try {
                URL url = new URL(systemId);
                return new InputSource(url.openStream());
            }
            catch (IOException e) {
                return null;
            }
        }

        static {
            _localResources.put("-//UC Berkeley//DTD MoML 1//EN", "../../moml/MoML_1.dtd");
        }
    }
}

