/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.data.unit;

import ptolemy.data.unit.EquationVisitor;
import ptolemy.data.unit.Unit;
import ptolemy.data.unit.UnitExpr;
import ptolemy.data.unit.UnitPresentation;
import ptolemy.kernel.util.IllegalActionException;

public class UnitTerm
implements UnitPresentation {
    private static final int _UNIT = 1;
    private static final int _UNITEXPR = 2;
    private static final int _VARIABLE = 3;
    private int _exponent = 1;
    private int _type = -1;
    private Unit _unit = null;
    private UnitExpr _unitExpr = null;
    private String _variable = null;

    public UnitTerm() {
    }

    public UnitTerm(Unit unit) {
        this._type = 1;
        this._unit = unit;
    }

    public UnitTerm copy() {
        UnitTerm retv = new UnitTerm();
        retv.setVariable(this._variable);
        retv.setExponent(this.getExponent());
        retv.setUnit(this._unit);
        retv.setUnitExpr(this._unitExpr);
        retv._setType(this._type);
        return retv;
    }

    @Override
    public String descriptiveForm() {
        String retv = null;
        switch (this._type) {
            case 3: {
                retv = "$" + this._variable;
                break;
            }
            case 1: {
                retv = this._unit.descriptiveForm();
                break;
            }
            case 2: {
                retv = "(" + this._unitExpr.descriptiveForm() + ")";
            }
        }
        if (this.getExponent() != 1) {
            retv = retv + "^" + this.getExponent();
        }
        return retv;
    }

    public int getExponent() {
        return this._exponent;
    }

    public Unit getUnit() {
        if (this._type == 1) {
            return this._unit;
        }
        return null;
    }

    public UnitExpr getUnitExpr() {
        if (this._type == 2) {
            return this._unitExpr;
        }
        return null;
    }

    public String getVariable() {
        if (this._type == 3) {
            return this._variable;
        }
        return null;
    }

    public UnitTerm invert() {
        UnitTerm retv = this.copy();
        switch (this._type) {
            case 1: 
            case 3: {
                retv.setExponent(-this.getExponent());
                break;
            }
            case 2: {
                retv.setUnitExpr(this._unitExpr.invert());
            }
        }
        return retv;
    }

    public boolean isUnit() {
        return this._type == 1;
    }

    public boolean isUnitExpr() {
        return this._type == 2;
    }

    public boolean isVariable() {
        return this._type == 3;
    }

    public void setExponent(int exponent) {
        this._exponent = exponent;
    }

    public void setUnit(Unit unit) {
        this._type = 1;
        this._unit = unit;
    }

    public void setUnitExpr(UnitExpr expr) {
        this._type = 2;
        this._unitExpr = expr;
    }

    public void setVariable(String v) {
        this._type = 3;
        this._variable = v;
    }

    @Override
    public String toString() {
        String retv = null;
        switch (this._type) {
            case 3: {
                retv = this._variable;
                break;
            }
            case 1: {
                retv = this._unit.toString();
                break;
            }
            case 2: {
                retv = "(" + this._unitExpr.toString() + ")";
            }
        }
        if (this.getExponent() != 1) {
            retv = retv + "^" + this.getExponent();
        }
        return retv;
    }

    public Object visit(EquationVisitor visitor) throws IllegalActionException {
        return visitor._visitUnitTerm(this);
    }

    protected void _setType(int type) {
        this._type = type;
    }
}

