/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.ct.lib;

import ptolemy.actor.TypedIOPort;
import ptolemy.actor.lib.Transformer;
import ptolemy.data.StringToken;
import ptolemy.data.expr.Parameter;
import ptolemy.domains.ct.kernel.CTDirector;
import ptolemy.domains.ct.kernel.CTEventGenerator;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Workspace;

public class CTTriggeredSampler
extends Transformer
implements CTEventGenerator {
    public TypedIOPort trigger;

    public CTTriggeredSampler(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.input.setMultiport(true);
        new Parameter((NamedObj)this.input, "signalType", new StringToken("CONTINUOUS"));
        this.output.setMultiport(true);
        this.output.setTypeAtLeast(this.input);
        new Parameter((NamedObj)this.output, "signalType", new StringToken("DISCRETE"));
        this.trigger = new TypedIOPort(this, "trigger", true, false);
        this.trigger.setMultiport(false);
        new Parameter((NamedObj)this.trigger, "signalType", new StringToken("DISCRETE"));
        this._attachText("_iconDescription", "<svg>\n<rect x=\"-30\" y=\"-20\" width=\"60\" height=\"40\" style=\"fill:white\"/>\n<polyline points=\"-30,10 2,10 2,0\"/>\n<polyline points=\"-30,-10 -20,-10 -20,0 -10,0 10,-7\"/>\n<polyline points=\"10,0 30,0\"/>\n</svg>\n");
    }

    @Override
    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        CTTriggeredSampler newObject = (CTTriggeredSampler)super.clone(workspace);
        newObject.output.setTypeAtLeast(newObject.input);
        return newObject;
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        CTDirector director = (CTDirector)this.getDirector();
        if (director.isDiscretePhase() && this.hasCurrentEvent()) {
            this.trigger.get(0);
            for (int i = 0; i < Math.min(this.input.getWidth(), this.output.getWidth()); ++i) {
                if (!this.input.hasToken(i)) continue;
                this.output.send(i, this.input.get(i));
            }
        }
    }

    @Override
    public boolean hasCurrentEvent() {
        try {
            if (this.trigger.hasToken(0)) {
                return true;
            }
        }
        catch (IllegalActionException e) {
            throw new InternalErrorException("Token mismatch.");
        }
        return false;
    }
}

