/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.ddf.lib;

import ptolemy.actor.TypedAtomicActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.data.BooleanToken;
import ptolemy.data.IntToken;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Settable;
import ptolemy.kernel.util.StringAttribute;
import ptolemy.kernel.util.Workspace;

public class DDFBooleanSelect
extends TypedAtomicActor {
    public TypedIOPort trueInput = new TypedIOPort(this, "trueInput", true, false);
    public TypedIOPort falseInput = new TypedIOPort(this, "falseInput", true, false);
    public TypedIOPort control = new TypedIOPort(this, "control", true, false);
    public TypedIOPort output;
    public Parameter trueInput_tokenConsumptionRate;
    public Parameter falseInput_tokenConsumptionRate;
    public Parameter control_tokenConsumptionRate;
    private boolean _control;
    private boolean _isControlRead;
    private static final IntToken _zero = new IntToken(0);
    private static final IntToken _one = new IntToken(1);

    public DDFBooleanSelect(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.control.setTypeEquals(BaseType.BOOLEAN);
        this.output = new TypedIOPort(this, "output", false, true);
        this.output.setTypeAtLeast(this.trueInput);
        this.output.setTypeAtLeast(this.falseInput);
        this.trueInput_tokenConsumptionRate = new Parameter(this.trueInput, "tokenConsumptionRate");
        this.trueInput_tokenConsumptionRate.setVisibility(Settable.NOT_EDITABLE);
        this.trueInput_tokenConsumptionRate.setTypeEquals(BaseType.INT);
        this.falseInput_tokenConsumptionRate = new Parameter(this.falseInput, "tokenConsumptionRate");
        this.falseInput_tokenConsumptionRate.setVisibility(Settable.NOT_EDITABLE);
        this.falseInput_tokenConsumptionRate.setTypeEquals(BaseType.INT);
        this.control_tokenConsumptionRate = new Parameter(this.control, "tokenConsumptionRate");
        this.control_tokenConsumptionRate.setVisibility(Settable.NOT_EDITABLE);
        this.control_tokenConsumptionRate.setTypeEquals(BaseType.INT);
        StringAttribute controlCardinal = new StringAttribute(this.control, "_cardinal");
        controlCardinal.setExpression("SOUTH");
    }

    @Override
    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        DDFBooleanSelect newObject = (DDFBooleanSelect)super.clone(workspace);
        newObject.output.setTypeAtLeast(newObject.trueInput);
        newObject.output.setTypeAtLeast(newObject.falseInput);
        return newObject;
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        if (this._isControlRead) {
            if (this._control) {
                this.output.send(0, this.trueInput.get(0));
            } else {
                this.output.send(0, this.falseInput.get(0));
            }
            this._isControlRead = false;
        } else {
            this._control = ((BooleanToken)this.control.get(0)).booleanValue();
            this._isControlRead = true;
        }
    }

    @Override
    public void initialize() throws IllegalActionException {
        super.initialize();
        this._isControlRead = false;
        this.trueInput_tokenConsumptionRate.setToken(_zero);
        this.falseInput_tokenConsumptionRate.setToken(_zero);
        this.control_tokenConsumptionRate.setToken(_one);
    }

    @Override
    public boolean postfire() throws IllegalActionException {
        if (this._isControlRead) {
            if (this._control) {
                this.trueInput_tokenConsumptionRate.setToken(_one);
                this.falseInput_tokenConsumptionRate.setToken(_zero);
                this.control_tokenConsumptionRate.setToken(_zero);
            } else {
                this.trueInput_tokenConsumptionRate.setToken(_zero);
                this.falseInput_tokenConsumptionRate.setToken(_one);
                this.control_tokenConsumptionRate.setToken(_zero);
            }
        } else {
            this.trueInput_tokenConsumptionRate.setToken(_zero);
            this.falseInput_tokenConsumptionRate.setToken(_zero);
            this.control_tokenConsumptionRate.setToken(_one);
        }
        return super.postfire();
    }

    @Override
    public boolean prefire() throws IllegalActionException {
        if (this._isControlRead ? (this._control ? !this.trueInput.hasToken(0) : !this.falseInput.hasToken(0)) : !this.control.hasToken(0)) {
            return false;
        }
        return super.prefire();
    }
}

