/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.ddf.lib;

import ptolemy.actor.TypedAtomicActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.data.ArrayToken;
import ptolemy.data.IntToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.ArrayType;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.Port;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.Settable;
import ptolemy.kernel.util.StringAttribute;
import ptolemy.kernel.util.Workspace;

public class DDFSelect
extends TypedAtomicActor {
    public TypedIOPort input = new TypedIOPort(this, "input", true, false);
    public TypedIOPort control;
    public TypedIOPort output;
    public Parameter input_tokenConsumptionRate;
    public Parameter control_tokenConsumptionRate;
    private int _control;
    private boolean _isControlRead;
    private static final IntToken _one = new IntToken(1);
    private static final IntToken _zero = new IntToken(0);
    private ArrayToken[] _rateArray;
    private ArrayToken _rateZero;

    public DDFSelect(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.input.setMultiport(true);
        this.control = new TypedIOPort(this, "control", true, false);
        this.control.setTypeEquals(BaseType.INT);
        this.output = new TypedIOPort(this, "output", false, true);
        this.output.setTypeAtLeast(this.input);
        this.input_tokenConsumptionRate = new Parameter(this.input, "tokenConsumptionRate");
        this.input_tokenConsumptionRate.setVisibility(Settable.NOT_EDITABLE);
        this.input_tokenConsumptionRate.setTypeEquals(new ArrayType(BaseType.INT));
        this.control_tokenConsumptionRate = new Parameter(this.control, "tokenConsumptionRate");
        this.control_tokenConsumptionRate.setVisibility(Settable.NOT_EDITABLE);
        this.control_tokenConsumptionRate.setTypeEquals(BaseType.INT);
        StringAttribute controlCardinal = new StringAttribute(this.control, "_cardinal");
        controlCardinal.setExpression("SOUTH");
    }

    @Override
    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        DDFSelect newObject = (DDFSelect)super.clone(workspace);
        newObject.output.setTypeAtLeast(newObject.input);
        return newObject;
    }

    @Override
    public void connectionsChanged(Port port) {
        super.connectionsChanged(port);
        if (port == this.input) {
            int i;
            this._rateArray = new ArrayToken[this.input.getWidth()];
            Token[] rate = new IntToken[this.input.getWidth()];
            for (i = 0; i < this.input.getWidth(); ++i) {
                rate[i] = _zero;
            }
            try {
                this._rateZero = new ArrayToken(BaseType.INT, rate);
                for (i = 0; i < this.input.getWidth(); ++i) {
                    rate[i] = _one;
                    this._rateArray[i] = new ArrayToken(rate);
                    rate[i] = _zero;
                }
            }
            catch (IllegalActionException ex) {
                throw new InternalErrorException(ex);
            }
        }
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        if (this._isControlRead) {
            this.output.send(0, this.input.get(this._control));
            this._isControlRead = false;
        } else {
            this._control = ((IntToken)this.control.get(0)).intValue();
            if (this._control >= 0 && this._control < this.input.getWidth()) {
                this._isControlRead = true;
            } else {
                throw new IllegalActionException((Nameable)this, "The width of the input port is " + this.input.getWidth() + " , but " + "the value of the received control token: " + this._control + " is out of range.");
            }
        }
    }

    @Override
    public void initialize() throws IllegalActionException {
        super.initialize();
        this._isControlRead = false;
        this.input_tokenConsumptionRate.setToken(this._rateZero);
        this.control_tokenConsumptionRate.setToken(_one);
    }

    @Override
    public boolean postfire() throws IllegalActionException {
        if (this._isControlRead) {
            this.input_tokenConsumptionRate.setToken(this._rateArray[this._control]);
            this.control_tokenConsumptionRate.setToken(_zero);
        } else {
            this.input_tokenConsumptionRate.setToken(this._rateZero);
            this.control_tokenConsumptionRate.setToken(_one);
        }
        return super.postfire();
    }

    @Override
    public boolean prefire() throws IllegalActionException {
        if (this._isControlRead ? !this.input.hasToken(this._control) : !this.control.hasToken(0)) {
            return false;
        }
        return super.prefire();
    }
}

