/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.de.kernel;

import java.util.LinkedList;
import ptolemy.actor.AbstractReceiver;
import ptolemy.actor.Actor;
import ptolemy.actor.CompositeActor;
import ptolemy.actor.Director;
import ptolemy.actor.IOPort;
import ptolemy.actor.NoTokenException;
import ptolemy.data.Token;
import ptolemy.domains.de.kernel.DEDirector;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.Nameable;

public class DEReceiver
extends AbstractReceiver {
    private DEDirector _director;
    private long _directorVersion = -1L;
    private LinkedList _tokens = new LinkedList();

    public DEReceiver() {
    }

    public DEReceiver(IOPort container) throws IllegalActionException {
        super(container);
    }

    @Override
    public void clear() {
        this._tokens.clear();
    }

    @Override
    public Token get() throws NoTokenException {
        if (this._tokens.isEmpty()) {
            throw new NoTokenException(this.getContainer(), "No more tokens in the DE receiver.");
        }
        return (Token)this._tokens.removeFirst();
    }

    @Override
    public final boolean hasRoom() {
        return true;
    }

    @Override
    public boolean hasRoom(int tokens) {
        return true;
    }

    @Override
    public boolean hasToken() {
        return !this._tokens.isEmpty();
    }

    @Override
    public boolean hasToken(int numberOfTokens) {
        return this._tokens.size() >= numberOfTokens;
    }

    @Override
    public void put(Token token) {
        try {
            DEDirector dir = this._getDirector();
            dir._enqueueTriggerEvent(this.getContainer());
            this._tokens.add(token);
        }
        catch (IllegalActionException ex) {
            throw new InternalErrorException(null, (Throwable)ex, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DEDirector _getDirector() throws IllegalActionException {
        IOPort port = this.getContainer();
        if (port != null) {
            if (this._directorVersion == port.workspace().getVersion()) {
                return this._director;
            }
            try {
                Director dir;
                port.workspace().getReadAccess();
                Actor actor = (Actor)((Object)port.getContainer());
                if (actor != null && (dir = !port.isInput() && actor instanceof CompositeActor && ((CompositeActor)actor).isOpaque() ? actor.getDirector() : actor.getExecutiveDirector()) != null) {
                    if (dir instanceof DEDirector) {
                        this._director = (DEDirector)dir;
                        this._directorVersion = port.workspace().getVersion();
                        DEDirector dEDirector = this._director;
                        return dEDirector;
                    }
                    throw new IllegalActionException((Nameable)this.getContainer(), "Does not have a DEDirector.");
                }
            }
            finally {
                port.workspace().doneReading();
            }
        }
        throw new IllegalActionException((Nameable)this.getContainer(), "Does not have a IOPort as the container of the receiver.");
    }
}

