/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.de.kernel;

import ptolemy.actor.IOPort;
import ptolemy.actor.TypedCompositeActor;
import ptolemy.domains.de.kernel.DEActor;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.KernelException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.PtolemyThread;

public abstract class DEThreadActor
extends DEActor
implements Runnable {
    private boolean _isWaiting = true;
    private static Object _monitor = new Object();
    private PtolemyThread _thread;

    public DEThreadActor(TypedCompositeActor container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fire() {
        this._isWaiting = false;
        Object object = _monitor;
        synchronized (object) {
            _monitor.notifyAll();
        }
        while (!this._isWaiting) {
            object = _monitor;
            synchronized (object) {
                try {
                    _monitor.wait();
                }
                catch (InterruptedException e) {
                    System.err.println(KernelException.stackTraceToString(e));
                }
            }
        }
    }

    @Override
    public void initialize() {
        this._thread = new PtolemyThread(this);
        this._isWaiting = true;
        this._thread.start();
    }

    @Override
    public abstract void run();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForNewInputs() {
        this._emptyPorts();
        this._isWaiting = true;
        Object object = _monitor;
        synchronized (object) {
            _monitor.notifyAll();
        }
        while (this._isWaiting) {
            object = _monitor;
            synchronized (object) {
                try {
                    _monitor.wait();
                }
                catch (InterruptedException e) {
                    System.err.println(KernelException.stackTraceToString(e));
                }
            }
        }
    }

    public void waitForNewInputs(IOPort[] ports) throws IllegalActionException {
        this._emptyPorts();
        block0: while (true) {
            this.waitForNewInputs();
            int i = 0;
            while (true) {
                if (i >= ports.length) continue block0;
                IOPort port = ports[i];
                for (int j = 0; j < port.getWidth(); ++j) {
                    if (!port.hasToken(j)) continue;
                    return;
                }
                ++i;
            }
            break;
        }
    }

    private void _emptyPorts() {
        for (IOPort port : this.inputPortList()) {
            for (int channel = 0; channel < port.getWidth(); ++channel) {
                try {
                    while (port.hasToken(channel)) {
                        port.get(channel);
                    }
                    continue;
                }
                catch (IllegalActionException ex) {
                    throw new InternalErrorException(this, (Throwable)ex, "Failed to empty ports?");
                }
            }
        }
    }
}

