/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.de.lib;

import ptolemy.actor.Actor;
import ptolemy.actor.Director;
import ptolemy.actor.TypedAtomicActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.actor.util.Time;
import ptolemy.data.BooleanToken;
import ptolemy.data.DoubleToken;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Workspace;

public class SingleEvent
extends TypedAtomicActor {
    public TypedIOPort output = new TypedIOPort(this, "output", false, true);
    public Parameter time = new Parameter((NamedObj)this, "time", new DoubleToken(0.0));
    public Parameter value;

    public SingleEvent(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.time.setTypeEquals(BaseType.DOUBLE);
        this.value = new Parameter((NamedObj)this, "value", new BooleanToken(true));
        this.output.setTypeSameAs(this.value);
    }

    @Override
    public void attributeTypeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.value) {
            Director director = this.getDirector();
            if (director != null) {
                director.invalidateResolvedTypes();
            }
        } else {
            super.attributeTypeChanged(attribute);
        }
    }

    @Override
    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        SingleEvent newObject = (SingleEvent)super.clone(workspace);
        newObject.output.setTypeSameAs(newObject.value);
        return newObject;
    }

    @Override
    public void fire() throws IllegalActionException {
        double eventTimeValue = ((DoubleToken)this.time.getToken()).doubleValue();
        Time eventTime = new Time(this.getDirector(), eventTimeValue);
        if (this.getDirector().getModelTime().equals(eventTime)) {
            this.output.send(0, this.value.getToken());
        }
        super.fire();
    }

    @Override
    public void initialize() throws IllegalActionException {
        super.initialize();
        double eventTime = ((DoubleToken)this.time.getToken()).doubleValue();
        if (eventTime >= 0.0) {
            Director director = this.getDirector();
            if (director != null) {
                director.fireAt((Actor)this, new Time(director, eventTime));
            } else {
                throw new IllegalActionException((Nameable)this, "No director.");
            }
        }
    }
}

