/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.de.lib;

import java.util.LinkedList;
import java.util.List;
import ptolemy.actor.IOPort;
import ptolemy.actor.TypedIOPort;
import ptolemy.data.BooleanToken;
import ptolemy.data.Token;
import ptolemy.data.UnionToken;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.data.type.UnionType;
import ptolemy.domains.de.kernel.DEActor;
import ptolemy.graph.Inequality;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.Port;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;

public class UnionMerge
extends DEActor {
    public TypedIOPort output = new TypedIOPort(this, "output", false, true);
    public Parameter discardEvents = new Parameter(this, "discardEvents");

    public UnionMerge(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.discardEvents.setExpression("false");
        this.discardEvents.setTypeEquals(BaseType.BOOLEAN);
        this._attachText("_iconDescription", "<svg>\n<polygon points=\"-10,20 10,10 10,-10, -10,-20\" style=\"fill:green\"/>\n</svg>\n");
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        boolean discard = ((BooleanToken)this.discardEvents.getToken()).booleanValue();
        Token firstAvailableToken = null;
        Object[] portArray = this.inputPortList().toArray();
        int size = portArray.length;
        for (int i = 0; i < size; ++i) {
            IOPort port = (IOPort)portArray[i];
            if (!port.hasToken(0)) continue;
            if (firstAvailableToken == null) {
                String label = port.getName();
                firstAvailableToken = port.get(0);
                UnionToken outputToken = new UnionToken(label, firstAvailableToken);
                this.output.send(0, outputToken);
                while (port.hasToken(0)) {
                    label = port.getName();
                    Token value = port.get(0);
                    outputToken = new UnionToken(label, value);
                    this.output.send(0, outputToken);
                }
                continue;
            }
            if (discard) {
                while (port.hasToken(0)) {
                    port.get(0);
                }
                continue;
            }
            this.getDirector().fireAtCurrentTime(this);
            break;
        }
    }

    @Override
    public List typeConstraintList() {
        Object[] portArray = this.inputPortList().toArray();
        int size = portArray.length;
        String[] labels = new String[size];
        Type[] types = new Type[size];
        for (int i = 0; i < size; ++i) {
            labels[i] = ((Port)portArray[i]).getName();
            types[i] = BaseType.UNKNOWN;
        }
        UnionType declaredType = new UnionType(labels, types);
        this.output.setTypeEquals(declaredType);
        LinkedList<Inequality> constraints = new LinkedList<Inequality>();
        UnionType outputType = (UnionType)this.output.getType();
        for (TypedIOPort inputPort : this.inputPortList()) {
            String label = inputPort.getName();
            Inequality inequality = new Inequality(inputPort.getTypeTerm(), outputType.getTypeTerm(label));
            constraints.add(inequality);
        }
        return constraints;
    }
}

