/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.fsm.kernel.ia;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ptolemy.actor.IOPort;
import ptolemy.actor.TypedIOPort;
import ptolemy.data.expr.Parameter;
import ptolemy.domains.fsm.kernel.FSMActor;
import ptolemy.domains.fsm.kernel.State;
import ptolemy.domains.fsm.kernel.ia.InterfaceAutomatonTransition;
import ptolemy.domains.fsm.kernel.ia.StatePair;
import ptolemy.kernel.ComponentPort;
import ptolemy.kernel.ComponentRelation;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.Port;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.Workspace;

public class InterfaceAutomaton
extends FSMActor {
    private static final String NAME_CONNECTOR = "_";
    private Set _inputNames;
    private Set _outputNames;
    private Set _internalNames;
    private Set _illegalStates;

    public InterfaceAutomaton() {
    }

    public InterfaceAutomaton(Workspace workspace) {
        super(workspace);
    }

    public InterfaceAutomaton(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
    }

    public void addPorts() {
        try {
            for (InterfaceAutomatonTransition transition : this.relationList()) {
                TypedIOPort port;
                String label = transition.getLabel();
                String name = label.substring(0, label.length() - 1);
                if (label.endsWith("?")) {
                    port = (TypedIOPort)this.getPort(name);
                    if (port != null) continue;
                    port = new TypedIOPort(this, name);
                    port.setInput(true);
                    continue;
                }
                if (!label.endsWith("!") || (port = (TypedIOPort)this.getPort(name)) != null) continue;
                port = new TypedIOPort(this, name);
                port.setOutput(true);
            }
        }
        catch (IllegalActionException exception) {
            throw new InternalErrorException("InterfaceAutomaton.addPorts: Cannot add port. " + exception.getMessage());
        }
        catch (NameDuplicationException exception) {
            throw new InternalErrorException("InterfaceAutomaton.addPorts: Cannot add port. " + exception.getMessage());
        }
    }

    public void combineInternalTransitions() {
        State initialState = (State)this.getEntity(this.initialStateName.getExpression());
        try {
            for (State state : this.entityList()) {
                ComponentPort inPort = state.incomingPort;
                List transitionList = inPort.linkedRelationList();
                InterfaceAutomatonTransition incomingTransition = null;
                if (transitionList.size() != 1 || (incomingTransition = (InterfaceAutomatonTransition)transitionList.get(0)).getType() != 2) continue;
                ComponentPort outPort = state.outgoingPort;
                transitionList = outPort.linkedRelationList();
                InterfaceAutomatonTransition outgoingTransition = null;
                if (transitionList.size() != 1 || (outgoingTransition = (InterfaceAutomatonTransition)transitionList.get(0)).getType() != 2 || state == initialState) continue;
                State sourceState = incomingTransition.sourceState();
                State destinationState = outgoingTransition.destinationState();
                String incomingLabel = incomingTransition.getLabel();
                String incomingName = incomingLabel.substring(0, incomingLabel.length() - 1);
                String outgoingLabel = outgoingTransition.getLabel();
                String newLabel = incomingName + NAME_CONNECTOR + outgoingLabel;
                String relationNamePrefix = incomingTransition.getName() + NAME_CONNECTOR + outgoingTransition.getName();
                this._removeStateAndTransitions(state);
                this._addTransition(this, relationNamePrefix, sourceState, destinationState, newLabel);
            }
        }
        catch (IllegalActionException exception) {
            throw new InternalErrorException("InterfaceAutomaton.combineInternalTransitions: " + exception.getMessage());
        }
        catch (NameDuplicationException exception) {
            throw new InternalErrorException("InterfaceAutomaton.combineInternalTransitions: " + exception.getMessage());
        }
    }

    public InterfaceAutomaton compose(InterfaceAutomaton automaton) throws IllegalActionException {
        return this.compose(automaton, false);
    }

    public InterfaceAutomaton compose(InterfaceAutomaton automaton, boolean considerTransient) throws IllegalActionException {
        this._check();
        automaton._check();
        this._checkComposability(automaton);
        this._computeTransitionNamesInComposition(automaton);
        InterfaceAutomaton composition = this._computeProduct(automaton, considerTransient);
        this._pruneIllegalStates();
        composition._removeUnreacheableStates();
        this._createPorts(composition);
        return composition;
    }

    public Set computeAlternatingSimulation(InterfaceAutomaton subAutomaton) throws IllegalActionException {
        this._check();
        subAutomaton._check();
        HashSet<StatePair> simulation = new HashSet<StatePair>();
        for (State superState : this.entityList()) {
            for (State subState : subAutomaton.entityList()) {
                if (!InterfaceAutomaton._condition1Satisfied(this, superState, subAutomaton, subState)) continue;
                StatePair pair = new StatePair(superState, subState);
                simulation.add(pair);
            }
        }
        HashSet<StatePair> toBeRemoved = new HashSet<StatePair>();
        do {
            toBeRemoved.clear();
            for (StatePair pair : simulation) {
                State subState;
                State superState = pair.first();
                if (InterfaceAutomaton._condition2Satisfied(this, superState, subAutomaton, subState = pair.second(), simulation)) continue;
                toBeRemoved.add(pair);
            }
            simulation.removeAll(toBeRemoved);
        } while (!toBeRemoved.isEmpty());
        return simulation;
    }

    public Set deadlockStates() throws IllegalActionException {
        if (!this.isClosed()) {
            throw new IllegalActionException("InterfaceAutomaton.deadlockStates: Deadlock can only be checked on closed interface automaton.");
        }
        HashSet<State> deadlockStates = new HashSet<State>();
        for (State state : this.entityList()) {
            ComponentPort outPort = state.outgoingPort;
            if (outPort.linkedRelationList().size() != 0) continue;
            deadlockStates.add(state);
        }
        return deadlockStates;
    }

    public Set epsilonClosure(State state) {
        HashSet<State> closure = new HashSet<State>();
        HashSet<State> frontier = new HashSet<State>();
        closure.add(state);
        frontier.add(state);
        while (!frontier.isEmpty()) {
            Iterator iterator = frontier.iterator();
            State current = (State)iterator.next();
            frontier.remove(current);
            ComponentPort outPort = current.outgoingPort;
            for (InterfaceAutomatonTransition transition : outPort.linkedRelationList()) {
                State destinationState;
                int transitionType = transition.getType();
                if (transitionType != 2 || closure.contains(destinationState = transition.destinationState())) continue;
                closure.add(destinationState);
                frontier.add(destinationState);
            }
        }
        return closure;
    }

    public Set externallyEnabledDestinations(State sourceState, String transitionLabel) {
        HashSet<State> destinations = new HashSet<State>();
        Set closure = this.epsilonClosure(sourceState);
        for (State source : closure) {
            ComponentPort outPort = source.outgoingPort;
            for (InterfaceAutomatonTransition transition : outPort.linkedRelationList()) {
                if (!transition.getLabel().equals(transitionLabel)) continue;
                State destination = transition.destinationState();
                destinations.add(destination);
            }
        }
        return destinations;
    }

    public Set externallyEnabledInputTransitionLabels(State state) {
        Set transitionLabels = this._transitionLabelsFrom(state, 0);
        Set closure = this.epsilonClosure(state);
        closure.remove(state);
        for (State nextState : closure) {
            Set labels = this._transitionLabelsFrom(nextState, 0);
            transitionLabels.retainAll(labels);
        }
        return transitionLabels;
    }

    public Set externallyEnabledOutputTransitionLabels(State state) {
        Set transitionLabels = this._transitionLabelsFrom(state, 1);
        Set closure = this.epsilonClosure(state);
        closure.remove(state);
        for (State nextState : closure) {
            Set labels = this._transitionLabelsFrom(nextState, 1);
            transitionLabels.addAll(labels);
        }
        return transitionLabels;
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
    }

    public String getInfo() {
        StringBuffer info = new StringBuffer(this.getFullName() + "\n");
        Set inputNames = this.inputNameSet();
        Set outputNames = this.outputNameSet();
        Set internalNames = this.internalTransitionNameSet();
        info.append("  " + this.entityList().size() + " states\n" + "  " + this.relationList().size() + " transitions\n" + "  " + inputNames.size() + " input names\n" + "  " + outputNames.size() + " output names\n" + "  " + internalNames.size() + " internal transition names\n" + "  Input Names:\n");
        Iterator iterator = inputNames.iterator();
        while (iterator.hasNext()) {
            info.append("    " + iterator.next().toString() + "\n");
        }
        info.append("  Output Names:\n");
        iterator = outputNames.iterator();
        while (iterator.hasNext()) {
            info.append("    " + iterator.next().toString() + "\n");
        }
        info.append("  Internal Transition Names:\n");
        iterator = internalNames.iterator();
        while (iterator.hasNext()) {
            info.append("    " + iterator.next().toString() + "\n");
        }
        return info.toString();
    }

    public Set inputNameSet() {
        HashSet<String> set = new HashSet<String>();
        for (Port port : this.inputPortList()) {
            set.add(port.getName());
        }
        return set;
    }

    public Set internalTransitionNameSet() {
        HashSet<String> set = new HashSet<String>();
        for (InterfaceAutomatonTransition transition : this.relationList()) {
            String label = transition.getLabel();
            if (!label.endsWith(";")) continue;
            String name = label.substring(0, label.length() - 1);
            set.add(name);
        }
        return set;
    }

    public boolean isClosed() {
        return this.portList().size() == 0;
    }

    public boolean isEmpty() {
        List states = this.entityList();
        return states.size() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ComponentRelation newRelation(String name) throws IllegalActionException, NameDuplicationException {
        try {
            InterfaceAutomatonTransition transition;
            this.workspace().getWriteAccess();
            InterfaceAutomatonTransition interfaceAutomatonTransition = transition = new InterfaceAutomatonTransition(this, name);
            return interfaceAutomatonTransition;
        }
        finally {
            this.workspace().doneWriting();
        }
    }

    public Set outputNameSet() {
        HashSet<String> set = new HashSet<String>();
        for (Port port : this.outputPortList()) {
            set.add(port.getName());
        }
        return set;
    }

    public void project(InterfaceAutomaton automaton) throws IllegalActionException {
        this._check();
        automaton._check();
        Set nameDifference = this.inputNameSet();
        nameDifference.addAll(this.outputNameSet());
        nameDifference.removeAll(automaton.inputNameSet());
        nameDifference.removeAll(automaton.outputNameSet());
        for (InterfaceAutomatonTransition transition : this.relationList()) {
            int type;
            String label = transition.getLabel();
            String name = label.substring(0, label.length() - 1);
            if (!nameDifference.contains(name) || (type = transition.getType()) != 0 && type != 1) continue;
            transition.label.setExpression(name + ";");
        }
        for (String portName : nameDifference) {
            Port port = this.getPort(portName);
            try {
                port.setContainer(null);
            }
            catch (NameDuplicationException nameDuplication) {
                throw new InternalErrorException("Cannot set container to null.");
            }
        }
    }

    public static Set reacheableAlternatingSimulation(Set alternatingSimulation, InterfaceAutomaton superAutomaton, InterfaceAutomaton subAutomaton) throws IllegalActionException {
        State subInitial;
        State superInitial = superAutomaton.getInitialState();
        StatePair pair = new StatePair(superInitial, subInitial = subAutomaton.getInitialState());
        if (!alternatingSimulation.contains(pair)) {
            return new HashSet();
        }
        HashSet<StatePair> reacheableSimulation = new HashSet<StatePair>();
        HashSet<StatePair> frontier = new HashSet<StatePair>();
        reacheableSimulation.add(pair);
        frontier.add(pair);
        while (!frontier.isEmpty()) {
            int transitionType;
            Iterator iterator = frontier.iterator();
            StatePair currentPair = (StatePair)iterator.next();
            frontier.remove(currentPair);
            State superState = currentPair.first();
            State subState = currentPair.second();
            ComponentPort superPort = superState.outgoingPort;
            for (InterfaceAutomatonTransition superTransition : superPort.linkedRelationList()) {
                State superDestination = superTransition.destinationState();
                String superLabel = superTransition.getLabel();
                transitionType = superTransition.getType();
                if (transitionType == 0 || transitionType == 1) {
                    ComponentPort subPort = subState.outgoingPort;
                    for (InterfaceAutomatonTransition subTransition : subPort.linkedRelationList()) {
                        State subDestination;
                        StatePair newPair;
                        String subLabel = subTransition.getLabel();
                        if (!superLabel.equals(subLabel) || !alternatingSimulation.contains(newPair = new StatePair(superDestination, subDestination = subTransition.destinationState())) || reacheableSimulation.contains(newPair)) continue;
                        reacheableSimulation.add(newPair);
                        frontier.add(newPair);
                    }
                    continue;
                }
                StatePair newPair = new StatePair(superDestination, subState);
                if (!alternatingSimulation.contains(newPair) || reacheableSimulation.contains(newPair)) continue;
                reacheableSimulation.add(newPair);
                frontier.add(newPair);
            }
            ComponentPort subPort = subState.outgoingPort;
            for (InterfaceAutomatonTransition subTransition : subPort.linkedRelationList()) {
                State subDestination;
                StatePair newPair;
                transitionType = subTransition.getType();
                if (transitionType != 2 || !alternatingSimulation.contains(newPair = new StatePair(superState, subDestination = subTransition.destinationState())) || reacheableSimulation.contains(newPair)) continue;
                reacheableSimulation.add(newPair);
                frontier.add(newPair);
            }
        }
        return reacheableSimulation;
    }

    public void renameTransitionLabels(Map nameMap) throws IllegalActionException, NameDuplicationException {
        for (InterfaceAutomatonTransition transition : this.relationList()) {
            int length;
            String oldLabel = transition.getLabel();
            String oldLabelName = oldLabel.substring(0, (length = oldLabel.length()) - 1);
            String newLabelName = (String)nameMap.get(oldLabelName);
            if (newLabelName == null) continue;
            String ending = oldLabel.substring(length - 1, length);
            String newLabel = newLabelName + ending;
            transition.label.setExpression(newLabel);
            if (ending.equals("?") || ending.equals("!")) {
                Port port = this.getPort(oldLabelName);
                if (port == null) continue;
                port.setName(newLabelName);
                continue;
            }
            if (ending.equals(";")) {
                Parameter param = (Parameter)this.getAttribute(oldLabelName);
                param.setName(newLabelName);
                continue;
            }
            throw new InternalErrorException("Transition label does not end with ?, !, or ;");
        }
        for (Port port : this.portList()) {
            String oldName = port.getName();
            String newName = (String)nameMap.get(oldName);
            if (newName == null) continue;
            port.setName(newName);
        }
    }

    @Override
    protected void _addRelation(ComponentRelation relation) throws IllegalActionException, NameDuplicationException {
        if (!(relation instanceof InterfaceAutomatonTransition)) {
            throw new IllegalActionException((Nameable)this, relation, "InterfaceAutomaton can only contain instances of InterfaceAutomatonTransition.");
        }
        super._addRelation(relation);
    }

    private State _addState(InterfaceAutomaton product, State stateInThis, State stateInArgument, HashMap frontier) throws IllegalActionException, NameDuplicationException {
        String name = stateInThis.getName() + NAME_CONNECTOR + stateInArgument.getName();
        State state = (State)product.getEntity(name);
        if (state == null) {
            state = new State(product, name);
            Triple triple = new Triple(state, stateInThis, stateInArgument);
            frontier.put(name, triple);
        }
        return state;
    }

    private void _addTransition(InterfaceAutomaton automaton, String relationNamePrefix, State sourceState, State destinationState, String label) throws IllegalActionException, NameDuplicationException {
        String name = automaton.uniqueName(relationNamePrefix);
        InterfaceAutomatonTransition transition = new InterfaceAutomatonTransition(automaton, name);
        sourceState.outgoingPort.link(transition);
        destinationState.incomingPort.link(transition);
        transition.label.setExpression(label);
    }

    private void _check() throws IllegalActionException {
        for (InterfaceAutomatonTransition transition : this.relationList()) {
            IOPort port;
            String label = transition.getLabel();
            String name = label.substring(0, label.length() - 1);
            if (label.endsWith("?")) {
                port = (IOPort)this.getPort(name);
                if (port != null && port.isInput()) continue;
                throw new IllegalActionException("InterfaceAutomaton._check: " + this.getFullName() + ": The transition " + label + " does not have a corresponding input port.");
            }
            if (label.endsWith("!")) {
                port = (IOPort)this.getPort(name);
                if (port != null && port.isOutput()) continue;
                throw new IllegalActionException("InterfaceAutomaton._check: " + this.getFullName() + ": The transition " + label + " does not have a corresponding output port.");
            }
            if (label.endsWith(";")) {
                Attribute attribute = this.getAttribute(name);
                if (attribute != null && attribute instanceof Parameter) continue;
                throw new IllegalActionException("InterfaceAutomaton._check: " + this.getFullName() + ": The transition " + label + " does not have a corresponding Parameter.");
            }
            throw new InternalErrorException("InterfaceAutomaton._check: The label " + label + " does not end with ?, !, or ;.");
        }
        Set inputNames = this.inputNameSet();
        Set outputNames = this.outputNameSet();
        inputNames.retainAll(outputNames);
        if (!inputNames.isEmpty()) {
            throw new IllegalActionException("InterfaceAutomaton._check: " + this.getFullName() + ": The names for input and output " + "transitions overlap.");
        }
        inputNames = this.inputNameSet();
        Set internalNames = this.internalTransitionNameSet();
        inputNames.retainAll(internalNames);
        if (!inputNames.isEmpty()) {
            throw new IllegalActionException("InterfaceAutomaton._check: " + this.getFullName() + ": The names for input and internal " + "transitions overlap.");
        }
        outputNames.retainAll(internalNames);
        if (!outputNames.isEmpty()) {
            throw new IllegalActionException("InterfaceAutomaton._check: " + this.getFullName() + ": The names for output and internal " + "transitions overlap.");
        }
    }

    private void _checkComposability(InterfaceAutomaton automaton) throws IllegalActionException {
        String message = "InterfaceAutomaton._checkComposability: " + this.getFullName() + " is not composable with " + automaton.getFullName() + " because ";
        Set thisInternals = this.internalTransitionNameSet();
        Set thatInputs = automaton.inputNameSet();
        Set thatOutputs = automaton.outputNameSet();
        Set thatInternals = automaton.internalTransitionNameSet();
        thatInputs.retainAll(thisInternals);
        thatOutputs.retainAll(thisInternals);
        thatInternals.retainAll(thisInternals);
        if (!(thatInputs.isEmpty() && thatOutputs.isEmpty() && thatInternals.isEmpty())) {
            throw new IllegalActionException(message + "the internal " + "transitions of the former overlaps with the transitions " + "of the latter.");
        }
        thatInternals = automaton.internalTransitionNameSet();
        Set thisInputs = this.inputNameSet();
        Set thisOutputs = this.outputNameSet();
        thisInternals = this.internalTransitionNameSet();
        thisInputs.retainAll(thatInternals);
        thisOutputs.retainAll(thatInternals);
        thisInternals.retainAll(thatInternals);
        if (!(thisInputs.isEmpty() && thisOutputs.isEmpty() && thisInternals.isEmpty())) {
            throw new IllegalActionException(message + "the internal " + "transitions of the latter overlaps with the transitions " + "of the former.");
        }
        thisInputs = this.inputNameSet();
        thatInputs = automaton.inputNameSet();
        thisInputs.retainAll(thatInputs);
        if (!thisInputs.isEmpty()) {
            throw new IllegalActionException(message + "the input " + "transitions of the two overlap.");
        }
        thisOutputs = this.outputNameSet();
        thatOutputs = automaton.outputNameSet();
        thisOutputs.retainAll(thatOutputs);
        if (!thisOutputs.isEmpty()) {
            throw new IllegalActionException(message + "the output " + "transitions of the two overlap.");
        }
    }

    private InterfaceAutomaton _computeProduct(InterfaceAutomaton automaton, boolean considerTransient) throws IllegalActionException {
        try {
            this._illegalStates = new HashSet();
            InterfaceAutomaton product = new InterfaceAutomaton();
            product.setName(this.getName() + NAME_CONNECTOR + automaton.getName());
            HashMap<String, Triple> frontier = new HashMap<String, Triple>();
            State stateInThis = this.getInitialState();
            State stateInArgument = automaton.getInitialState();
            String name = stateInThis.getName() + NAME_CONNECTOR + stateInArgument.getName();
            State stateInProduct = new State(product, name);
            product.initialStateName.setExpression(name);
            Triple triple = new Triple(stateInProduct, stateInThis, stateInArgument);
            frontier.put(name, triple);
            while (!frontier.isEmpty()) {
                Set destinationsInThis;
                State destinationInArgument;
                String inName;
                State destinationInProduct;
                Set destinationsInArgument;
                State destinationInProduct2;
                int transitionType;
                String transitionName;
                String transitionLabel;
                State destinationInThis;
                InterfaceAutomatonTransition transition;
                Iterator transitions;
                ComponentPort outPort;
                Iterator iterator = frontier.keySet().iterator();
                name = (String)iterator.next();
                triple = (Triple)frontier.remove(name);
                stateInProduct = triple._stateInProduct;
                stateInThis = triple._stateInThis;
                stateInArgument = triple._stateInArgument;
                boolean isStateInProductIllegal = false;
                if (!considerTransient || !InterfaceAutomaton._isTransient(stateInThis) && !InterfaceAutomaton._isTransient(stateInArgument)) {
                    String outName;
                    outPort = stateInThis.outgoingPort;
                    transitions = outPort.linkedRelationList().iterator();
                    while (transitions.hasNext() && !isStateInProductIllegal) {
                        transition = (InterfaceAutomatonTransition)transitions.next();
                        destinationInThis = transition.destinationState();
                        transitionLabel = transition.getLabel();
                        transitionName = transitionLabel.substring(0, transitionLabel.length() - 1);
                        transitionType = transition.getType();
                        if (transitionType == 0) {
                            if (this._inputNames.contains(transitionName)) {
                                destinationInProduct2 = this._addState(product, destinationInThis, stateInArgument, frontier);
                                this._addTransition(product, this.getName(), stateInProduct, destinationInProduct2, transitionLabel);
                                continue;
                            }
                            outName = transitionName + "!";
                            destinationsInArgument = this._getDestinationStates(stateInArgument, outName);
                            if (destinationsInArgument.isEmpty()) continue;
                            for (State destinationInArgument2 : destinationsInArgument) {
                                destinationInProduct = this._addState(product, destinationInThis, destinationInArgument2, frontier);
                                this._addTransition(product, this.getName() + NAME_CONNECTOR + automaton.getName(), stateInProduct, destinationInProduct, transitionName + ";");
                            }
                            continue;
                        }
                        if (transitionType == 1) {
                            if (this._outputNames.contains(transitionName)) {
                                destinationInProduct2 = this._addState(product, destinationInThis, stateInArgument, frontier);
                                this._addTransition(product, this.getName(), stateInProduct, destinationInProduct2, transitionLabel);
                                continue;
                            }
                            inName = transitionName + "?";
                            destinationsInArgument = this._getDestinationStates(stateInArgument, inName);
                            if (!destinationsInArgument.isEmpty()) continue;
                            this._illegalStates.add(stateInProduct);
                            isStateInProductIllegal = true;
                            continue;
                        }
                        if (transitionType == 2) {
                            destinationInProduct2 = this._addState(product, destinationInThis, stateInArgument, frontier);
                            this._addTransition(product, this.getName(), stateInProduct, destinationInProduct2, transitionLabel);
                            continue;
                        }
                        throw new InternalErrorException("InterfaceAutomaton._computeProduct: unrecognized transition type.");
                    }
                    outPort = stateInArgument.outgoingPort;
                    transitions = outPort.linkedRelationList().iterator();
                    while (transitions.hasNext() && !isStateInProductIllegal) {
                        transition = (InterfaceAutomatonTransition)transitions.next();
                        destinationInArgument = transition.destinationState();
                        transitionLabel = transition.getLabel();
                        transitionName = transitionLabel.substring(0, transitionLabel.length() - 1);
                        transitionType = transition.getType();
                        if (transitionType == 0) {
                            if (this._inputNames.contains(transitionName)) {
                                destinationInProduct2 = this._addState(product, stateInThis, destinationInArgument, frontier);
                                this._addTransition(product, automaton.getName(), stateInProduct, destinationInProduct2, transitionLabel);
                                continue;
                            }
                            outName = transitionName + "!";
                            destinationsInThis = this._getDestinationStates(stateInThis, outName);
                            if (destinationsInThis.isEmpty()) continue;
                            for (State destinationInThis2 : destinationsInThis) {
                                destinationInProduct = this._addState(product, destinationInThis2, destinationInArgument, frontier);
                                this._addTransition(product, this.getName() + NAME_CONNECTOR + automaton.getName(), stateInProduct, destinationInProduct, transitionName + ";");
                            }
                            continue;
                        }
                        if (transitionType == 1) {
                            if (this._outputNames.contains(transitionName)) {
                                destinationInProduct2 = this._addState(product, stateInThis, destinationInArgument, frontier);
                                this._addTransition(product, automaton.getName(), stateInProduct, destinationInProduct2, transitionLabel);
                                continue;
                            }
                            inName = transitionName + "?";
                            destinationsInThis = this._getDestinationStates(stateInThis, inName);
                            if (!destinationsInThis.isEmpty()) continue;
                            this._illegalStates.add(stateInProduct);
                            isStateInProductIllegal = true;
                            continue;
                        }
                        if (transitionType == 2) {
                            destinationInProduct2 = this._addState(product, stateInThis, destinationInArgument, frontier);
                            this._addTransition(product, automaton.getName(), stateInProduct, destinationInProduct2, transitionLabel);
                            continue;
                        }
                        throw new InternalErrorException("InterfaceAutomaton._computeProduct: unrecognized transition type.");
                    }
                    continue;
                }
                if (InterfaceAutomaton._isTransient(stateInThis) && InterfaceAutomaton._isTransient(stateInArgument)) {
                    throw new IllegalActionException("Cannot compute product since both states are transient: " + stateInThis.getName() + " and " + stateInArgument.getName());
                }
                if (InterfaceAutomaton._isTransient(stateInThis)) {
                    outPort = stateInThis.outgoingPort;
                    transitions = outPort.linkedRelationList().iterator();
                    while (transitions.hasNext() && !isStateInProductIllegal) {
                        transition = (InterfaceAutomatonTransition)transitions.next();
                        destinationInThis = transition.destinationState();
                        transitionLabel = transition.getLabel();
                        transitionName = transitionLabel.substring(0, transitionLabel.length() - 1);
                        transitionType = transition.getType();
                        if (transitionType == 0) {
                            throw new IllegalActionException("Transient state " + stateInThis.getName() + " in " + this.getName() + " has input " + "transition " + transitionLabel);
                        }
                        if (transitionType == 1) {
                            if (this._outputNames.contains(transitionName)) {
                                destinationInProduct2 = this._addState(product, destinationInThis, stateInArgument, frontier);
                                this._addTransition(product, this.getName(), stateInProduct, destinationInProduct2, transitionLabel);
                                continue;
                            }
                            inName = transitionName + "?";
                            destinationsInArgument = this._getDestinationStates(stateInArgument, inName);
                            if (!destinationsInArgument.isEmpty()) {
                                for (State destinationInArgument2 : destinationsInArgument) {
                                    destinationInProduct = this._addState(product, destinationInThis, destinationInArgument2, frontier);
                                    this._addTransition(product, this.getName() + NAME_CONNECTOR + automaton.getName(), stateInProduct, destinationInProduct, transitionName + ";");
                                }
                                continue;
                            }
                            this._illegalStates.add(stateInProduct);
                            isStateInProductIllegal = true;
                            continue;
                        }
                        if (transitionType == 2) {
                            destinationInProduct2 = this._addState(product, destinationInThis, stateInArgument, frontier);
                            this._addTransition(product, this.getName(), stateInProduct, destinationInProduct2, transitionLabel);
                            continue;
                        }
                        throw new InternalErrorException("InterfaceAutomaton._computeProduct: unrecognized transition type.");
                    }
                    continue;
                }
                outPort = stateInArgument.outgoingPort;
                transitions = outPort.linkedRelationList().iterator();
                while (transitions.hasNext() && !isStateInProductIllegal) {
                    transition = (InterfaceAutomatonTransition)transitions.next();
                    destinationInArgument = transition.destinationState();
                    transitionLabel = transition.getLabel();
                    transitionName = transitionLabel.substring(0, transitionLabel.length() - 1);
                    transitionType = transition.getType();
                    if (transitionType == 0) {
                        throw new IllegalActionException("Transient state " + stateInArgument.getName() + " in " + automaton.getName() + " has input transition " + transitionLabel);
                    }
                    if (transitionType == 1) {
                        if (this._outputNames.contains(transitionName)) {
                            destinationInProduct2 = this._addState(product, stateInThis, destinationInArgument, frontier);
                            this._addTransition(product, automaton.getName(), stateInProduct, destinationInProduct2, transitionLabel);
                            continue;
                        }
                        inName = transitionName + "?";
                        destinationsInThis = this._getDestinationStates(stateInThis, inName);
                        if (!destinationsInThis.isEmpty()) {
                            for (State destinationInThis2 : destinationsInThis) {
                                destinationInProduct = this._addState(product, destinationInThis2, destinationInArgument, frontier);
                                this._addTransition(product, this.getName() + NAME_CONNECTOR + automaton.getName(), stateInProduct, destinationInProduct, transitionName + ";");
                            }
                            continue;
                        }
                        this._illegalStates.add(stateInProduct);
                        isStateInProductIllegal = true;
                        continue;
                    }
                    if (transitionType == 2) {
                        destinationInProduct2 = this._addState(product, stateInThis, destinationInArgument, frontier);
                        this._addTransition(product, automaton.getName(), stateInProduct, destinationInProduct2, transitionLabel);
                        continue;
                    }
                    throw new InternalErrorException("InterfaceAutomaton._computeProduct: unrecognized transition type.");
                }
            }
            return product;
        }
        catch (NameDuplicationException exception) {
            throw new InternalErrorException("InterfaceAutomaton._computeProduct: name in product automaton clashes: " + exception.getMessage());
        }
    }

    private void _computeTransitionNamesInComposition(InterfaceAutomaton automaton) {
        Set shared = this.inputNameSet();
        Set thatOutputs = automaton.outputNameSet();
        shared.retainAll(thatOutputs);
        Set sharedOutputNameSet = this.outputNameSet();
        Set thatInputs = automaton.inputNameSet();
        sharedOutputNameSet.retainAll(thatInputs);
        shared.addAll(sharedOutputNameSet);
        this._inputNames = this.inputNameSet();
        this._inputNames.addAll(automaton.inputNameSet());
        this._inputNames.removeAll(shared);
        this._outputNames = this.outputNameSet();
        this._outputNames.addAll(automaton.outputNameSet());
        this._outputNames.removeAll(shared);
        this._internalNames = this.internalTransitionNameSet();
        this._internalNames.addAll(automaton.internalTransitionNameSet());
        this._internalNames.addAll(shared);
    }

    private static boolean _condition1Satisfied(InterfaceAutomaton superAutomaton, State superState, InterfaceAutomaton subAutomaton, State subState) {
        Set inputLabelsInSuper = superAutomaton.externallyEnabledInputTransitionLabels(superState);
        Set inputLabelsInSub = subAutomaton.externallyEnabledInputTransitionLabels(subState);
        if (!inputLabelsInSub.containsAll(inputLabelsInSuper)) {
            return false;
        }
        Set outputLabelsInSuper = superAutomaton.externallyEnabledOutputTransitionLabels(superState);
        Set outputLabelsInSub = subAutomaton.externallyEnabledOutputTransitionLabels(subState);
        return outputLabelsInSuper.containsAll(outputLabelsInSub);
    }

    private static boolean _condition2Satisfied(InterfaceAutomaton superAutomaton, State superState, InterfaceAutomaton subAutomaton, State subState, Set currentSimulation) {
        Set consideredTransitionLabels = superAutomaton.externallyEnabledInputTransitionLabels(superState);
        Set consideredOutputTransitionLabels = subAutomaton.externallyEnabledOutputTransitionLabels(subState);
        consideredTransitionLabels.addAll(consideredOutputTransitionLabels);
        for (String label : consideredTransitionLabels) {
            Set destinationsInSub = subAutomaton.externallyEnabledDestinations(subState, label);
            Set destinationsInSuper = superAutomaton.externallyEnabledDestinations(superState, label);
            for (State destinationInSub : destinationsInSub) {
                boolean inCurrentSimulation = false;
                for (State destinationInSuper : destinationsInSuper) {
                    StatePair pair = new StatePair(destinationInSuper, destinationInSub);
                    if (!currentSimulation.contains(pair)) continue;
                    inCurrentSimulation = true;
                    break;
                }
                if (inCurrentSimulation) continue;
                return false;
            }
        }
        return true;
    }

    private void _createPorts(InterfaceAutomaton composition) throws IllegalActionException {
        try {
            TypedIOPort port;
            for (String name : this._inputNames) {
                port = new TypedIOPort(composition, name);
                port.setInput(true);
            }
            for (String name : this._outputNames) {
                port = new TypedIOPort(composition, name);
                port.setOutput(true);
            }
        }
        catch (NameDuplicationException exception) {
            throw new InternalErrorException("InterfaceAutomaton._createPort: Cannot create ports due to name duplication: " + exception.getMessage());
        }
    }

    private Set _getDestinationStates(State state, String label) {
        HashSet<State> destinations = new HashSet<State>();
        ComponentPort outPort = state.outgoingPort;
        for (InterfaceAutomatonTransition transition : outPort.linkedRelationList()) {
            String transitionLabel = transition.getLabel();
            if (!transitionLabel.equals(label)) continue;
            destinations.add(transition.destinationState());
        }
        return destinations;
    }

    private static boolean _isTransient(State state) {
        String name = state.getName();
        return name.indexOf("t") != -1;
    }

    private void _pruneIllegalStates() {
        HashSet frontier = new HashSet();
        Iterator iterator = this._illegalStates.iterator();
        while (iterator.hasNext()) {
            frontier.add(iterator.next());
        }
        while (!frontier.isEmpty()) {
            iterator = frontier.iterator();
            State current = (State)iterator.next();
            frontier.remove(current);
            ComponentPort inPort = current.incomingPort;
            for (InterfaceAutomatonTransition transition : inPort.linkedRelationList()) {
                State sourceState;
                int transitionType = transition.getType();
                if (transitionType != 1 && transitionType != 2 || this._illegalStates.contains(sourceState = transition.sourceState())) continue;
                this._illegalStates.add(sourceState);
                frontier.add(sourceState);
            }
        }
        for (State state : this._illegalStates) {
            this._removeStateAndTransitions(state);
        }
    }

    private void _removeStateAndTransitions(State state) {
        try {
            ComponentPort inPort = state.incomingPort;
            for (ComponentRelation transition : inPort.linkedRelationList()) {
                transition.setContainer(null);
            }
            ComponentPort outPort = state.outgoingPort;
            for (ComponentRelation transition : outPort.linkedRelationList()) {
                transition.setContainer(null);
            }
            state.setContainer(null);
        }
        catch (IllegalActionException exception) {
            throw new InternalErrorException("InterfaceAutomaton._removeStateAndTransitions: IllegalActionException thrown when calling setContainer() with null argument: " + exception.getMessage());
        }
        catch (NameDuplicationException exception) {
            throw new InternalErrorException("InterfaceAutomaton._removeStateAndTransitions: NameDuplicationException thrown when calling setContainer() with null argument: " + exception.getMessage());
        }
    }

    private void _removeUnreacheableStates() {
        State initialState;
        try {
            initialState = this.getInitialState();
        }
        catch (IllegalActionException exception) {
            this.removeAllRelations();
            this.removeAllEntities();
            return;
        }
        HashSet<State> reacheableStates = new HashSet<State>();
        HashSet<State> frontier = new HashSet<State>();
        reacheableStates.add(initialState);
        frontier.add(initialState);
        while (!frontier.isEmpty()) {
            Iterator iterator = frontier.iterator();
            State current = (State)iterator.next();
            frontier.remove(current);
            ComponentPort outPort = current.outgoingPort;
            for (InterfaceAutomatonTransition transition : outPort.linkedRelationList()) {
                State destinationState = transition.destinationState();
                if (reacheableStates.contains(destinationState)) continue;
                reacheableStates.add(destinationState);
                frontier.add(destinationState);
            }
        }
        List states = this.entityList();
        HashSet unreacheableStates = new HashSet();
        for (Object state : states) {
            if (reacheableStates.contains(state)) continue;
            unreacheableStates.add(state);
        }
        for (Object state : unreacheableStates) {
            this._removeStateAndTransitions((State)state);
        }
    }

    private Set _transitionLabelsFrom(State state, int transitionType) {
        HashSet<String> labels = new HashSet<String>();
        ComponentPort outPort = state.outgoingPort;
        for (InterfaceAutomatonTransition transition : outPort.linkedRelationList()) {
            int type = transition.getType();
            if (type != transitionType) continue;
            String label = transition.getLabel();
            labels.add(label);
        }
        return labels;
    }

    private class Triple {
        private State _stateInProduct = null;
        private State _stateInThis = null;
        private State _stateInArgument = null;

        private Triple(State stateInProduct, State stateInThis, State stateInArgument) {
            this._stateInProduct = stateInProduct;
            this._stateInThis = stateInThis;
            this._stateInArgument = stateInArgument;
        }
    }
}

