/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.fsm.modal;

import ptolemy.actor.parameters.ParameterPort;
import ptolemy.actor.parameters.PortParameter;
import ptolemy.data.BooleanToken;
import ptolemy.domains.fsm.kernel.State;
import ptolemy.domains.fsm.kernel.Transition;
import ptolemy.domains.fsm.modal.ModalModel;
import ptolemy.domains.fsm.modal.Refinement;
import ptolemy.kernel.ComponentEntity;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Settable;
import ptolemy.kernel.util.StringAttribute;
import ptolemy.kernel.util.Workspace;

public class Case
extends ModalModel {
    public PortParameter control;
    protected State _state;
    protected Refinement _default;

    public Case(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this._init();
    }

    @Override
    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        Case newObject = (Case)super.clone(workspace);
        newObject._default = (Refinement)newObject.getEntity("default");
        return newObject;
    }

    @Override
    protected void _addEntity(ComponentEntity entity) throws IllegalActionException, NameDuplicationException {
        super._addEntity(entity);
        if (entity instanceof Refinement) {
            String controlValue = entity.getName();
            if (this._controller.getRelation(controlValue) == null) {
                Transition transition = (Transition)this._controller.newRelation(controlValue);
                transition.guardExpression.setExpression("control == " + controlValue);
                transition.refinementName.setExpression(controlValue);
                transition.preemptive.setToken(BooleanToken.TRUE);
                if (controlValue.equals("default")) {
                    transition.defaultTransition.setToken(BooleanToken.TRUE);
                }
                this._state.incomingPort.link(transition);
                this._state.outgoingPort.link(transition);
            }
            if (this._default != null) {
                this._default.moveToLast();
            }
        }
    }

    private void _init() throws IllegalActionException, NameDuplicationException {
        this._state = new State(this._controller, "State");
        this._controller.initialStateName.setExpression("State");
        this.directorClass.setVisibility(Settable.EXPERT);
        this.control = new PortParameter(this, "control");
        this.control.setExpression("true");
        ParameterPort port = this.control.getPort();
        StringAttribute controlCardinal = new StringAttribute(port, "_cardinal");
        controlCardinal.setExpression("SOUTH");
        this._default = new Refinement(this, "default");
    }
}

