/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.pn.kernel;

import ptolemy.actor.Actor;
import ptolemy.actor.TimedDirector;
import ptolemy.actor.util.CalendarQueue;
import ptolemy.actor.util.Time;
import ptolemy.actor.util.TimedEvent;
import ptolemy.domains.pn.kernel.PNDirector;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.Settable;
import ptolemy.kernel.util.Workspace;

public class TimedPNDirector
extends PNDirector
implements TimedDirector {
    protected CalendarQueue _eventQueue = new CalendarQueue(new TimedEvent.TimeComparator());
    private int _delayBlockCount = 0;

    public TimedPNDirector() throws IllegalActionException, NameDuplicationException {
        this.timeResolution.setVisibility(Settable.FULL);
    }

    public TimedPNDirector(Workspace workspace) throws IllegalActionException, NameDuplicationException {
        super(workspace);
        this.timeResolution.setVisibility(Settable.FULL);
    }

    public TimedPNDirector(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.timeResolution.setVisibility(Settable.FULL);
    }

    @Override
    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        TimedPNDirector newObject = (TimedPNDirector)super.clone(workspace);
        newObject._eventQueue = new CalendarQueue(new TimedEvent.TimeComparator());
        newObject._delayBlockCount = 0;
        return newObject;
    }

    @Override
    public synchronized void fireAt(Actor actor, Time newFiringTime) throws IllegalActionException {
        if (newFiringTime.compareTo(this.getModelTime()) < 0) {
            throw new IllegalActionException((Nameable)this, "The process wants to  get fired in the past!");
        }
        this._eventQueue.put(new TimedEvent(newFiringTime, actor));
        this._informOfDelayBlock();
        try {
            while (this.getModelTime().compareTo(newFiringTime) < 0) {
                this.wait();
            }
        }
        catch (InterruptedException e) {
            System.err.println(e.toString());
        }
    }

    @Override
    public void setModelTime(Time newTime) throws IllegalActionException {
        if (newTime.compareTo(this.getModelTime()) < 0) {
            throw new IllegalActionException((Nameable)this, "Attempt to set the time to past.");
        }
        super.setModelTime(newTime);
    }

    @Override
    protected synchronized boolean _areThreadsDeadlocked() {
        return this._readBlockedQueues.size() + this._writeBlockedQueues.size() + this._delayBlockCount >= this._getActiveThreadsCount();
    }

    protected synchronized void _informOfDelayBlock() {
        ++this._delayBlockCount;
        this.notifyAll();
    }

    protected synchronized void _informOfDelayUnblock() {
        --this._delayBlockCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean _resolveDeadlock() throws IllegalActionException {
        if (this._writeBlockedQueues.size() != 0) {
            this._incrementLowestWriteCapacityPort();
            return true;
        }
        if (this._delayBlockCount == 0) {
            return false;
        }
        TimedPNDirector timedPNDirector = this;
        synchronized (timedPNDirector) {
            if (this._eventQueue.isEmpty()) {
                throw new InternalErrorException("Inconsistency in number of actors blocked on delays count and the entries in the CalendarQueue");
            }
            TimedEvent event = (TimedEvent)this._eventQueue.take();
            this.setModelTime(event.timeStamp);
            this._informOfDelayUnblock();
            boolean sameTime = true;
            while (sameTime) {
                if (!this._eventQueue.isEmpty()) {
                    TimedEvent event2 = (TimedEvent)this._eventQueue.take();
                    Actor actor = (Actor)event2.contents;
                    Time newTime = event2.timeStamp;
                    if (newTime.equals(this.getModelTime())) {
                        this._informOfDelayUnblock();
                        continue;
                    }
                    this._eventQueue.put(new TimedEvent(newTime, actor));
                    sameTime = false;
                    continue;
                }
                sameTime = false;
            }
            this.notifyAll();
        }
        return true;
    }
}

