/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.rendezvous.lib;

import java.util.LinkedList;
import java.util.List;
import ptolemy.actor.TypedAtomicActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.actor.process.TerminateProcessException;
import ptolemy.data.IntToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.domains.rendezvous.kernel.RendezvousDirector;
import ptolemy.domains.rendezvous.kernel.RendezvousReceiver;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;

public class Buffer
extends TypedAtomicActor {
    public Parameter capacity;
    public TypedIOPort input;
    public TypedIOPort output;
    private List _buffer = new LinkedList();
    private IllegalActionException _exception;
    private boolean _postfireReturns = true;
    private Thread _readThread = null;

    public Buffer(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.capacity = new Parameter(this, "capacity");
        this.capacity.setTypeEquals(BaseType.INT);
        this.capacity.setExpression("1");
        this.input = new TypedIOPort(this, "input", true, false);
        this.output = new TypedIOPort(this, "output", false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        final Thread writeThread = Thread.currentThread();
        if (!(this.getDirector() instanceof RendezvousDirector)) {
            throw new IllegalActionException((Nameable)this, "Buffer actor can only be used with RendezvousDirector.");
        }
        final RendezvousDirector director = (RendezvousDirector)this.getDirector();
        this._postfireReturns = true;
        if (this._readThread == null) {
            this._readThread = new Thread(this.getFullName() + "_readThread"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public void run() {
                    try {
                        if (Buffer.this._debugging) {
                            Buffer.this._debug("** Starting read thread.");
                        }
                        Buffer.this._exception = null;
                        while (!Buffer.this._stopRequested) {
                            RendezvousDirector rendezvousDirector = director;
                            synchronized (rendezvousDirector) {
                                int capacityValue = ((IntToken)Buffer.this.capacity.getToken()).intValue();
                                while (Buffer.this._buffer.size() >= capacityValue && !Buffer.this._stopRequested) {
                                    if (Buffer.this._debugging) {
                                        Buffer.this._debug("** Waiting because buffer is full.");
                                    }
                                    try {
                                        director.threadBlocked(Buffer.this._readThread, null);
                                        RendezvousReceiver.waitForChange(director);
                                    }
                                    finally {
                                        director.threadUnblocked(Buffer.this._readThread, null);
                                    }
                                }
                                if (Buffer.this._stopRequested) {
                                    return;
                                }
                                if (Buffer.this._debugging) {
                                    Buffer.this._debug("** Waiting for input.");
                                }
                                Token token = Buffer.this.input.get(0);
                                Buffer.this._buffer.add(token);
                                if (Buffer.this._debugging) {
                                    Buffer.this._debug("** Received input. Buffer contents: " + Buffer.this._buffer);
                                }
                                director.threadUnblocked(writeThread, null);
                                director.notifyAll();
                            }
                        }
                        return;
                    }
                    catch (TerminateProcessException ex) {
                        Buffer.this._postfireReturns = false;
                        return;
                    }
                    catch (IllegalActionException ex) {
                        Buffer.this._exception = ex;
                        return;
                    }
                    finally {
                        director.removeThread(Buffer.this._readThread);
                        if (Buffer.this._debugging) {
                            Buffer.this._debug("** Ending read thread.");
                        }
                    }
                }
            };
            director.addThread(this._readThread);
            this._readThread.start();
        }
        RendezvousDirector rendezvousDirector = director;
        synchronized (rendezvousDirector) {
            if (this._exception != null) {
                throw this._exception;
            }
            while (this._buffer.size() == 0) {
                if (this._stopRequested || !this._postfireReturns) {
                    this._postfireReturns = false;
                    return;
                }
                if (this._debugging) {
                    this._debug("Buffer is empty. Waiting for it to fill.");
                }
                try {
                    director.threadBlocked(writeThread, null);
                    RendezvousReceiver.waitForChange(director);
                }
                catch (TerminateProcessException ex) {
                    this._postfireReturns = false;
                    return;
                }
                finally {
                    director.threadUnblocked(writeThread, null);
                }
                if (this._exception == null) continue;
                throw this._exception;
            }
            Token token = (Token)this._buffer.get(0);
            if (this._debugging) {
                this._debug("Sending token to output: " + token);
            }
            if (this._exception != null) {
                throw this._exception;
            }
            try {
                this.output.send(0, token);
            }
            catch (TerminateProcessException e) {
                this._postfireReturns = false;
                return;
            }
            if (this._exception != null) {
                throw this._exception;
            }
            this._buffer.remove(0);
            if (this._debugging) {
                this._debug("Buffer contents: " + this._buffer);
            }
            int capacityValue = ((IntToken)this.capacity.getToken()).intValue();
            if (this._buffer.size() == capacityValue - 1 && !this._stopRequested) {
                director.threadUnblocked(this._readThread, null);
                director.notifyAll();
            }
        }
    }

    @Override
    public void initialize() throws IllegalActionException {
        super.initialize();
        this._buffer.clear();
        this._exception = null;
        this._readThread = null;
        this._postfireReturns = true;
    }

    @Override
    public boolean postfire() {
        return this._postfireReturns;
    }
}

