/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.sdf.lib;

import ptolemy.data.DoubleMatrixToken;
import ptolemy.data.DoubleToken;
import ptolemy.data.IntToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.domains.sdf.lib.SDFConverter;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;

public class DoubleToMatrix
extends SDFConverter {
    public Parameter columns;
    public Parameter rows = new Parameter(this, "rows");
    private int _rows;
    private int _columns;

    public DoubleToMatrix(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.rows.setExpression("2");
        this.rows.setTypeEquals(BaseType.INT);
        this.columns = new Parameter(this, "columns");
        this.columns.setExpression("2");
        this.columns.setTypeEquals(BaseType.INT);
        this.input.setTypeEquals(BaseType.DOUBLE);
        this.output.setTypeEquals(BaseType.DOUBLE_MATRIX);
        this.input_tokenConsumptionRate.setExpression("rows * columns");
    }

    @Override
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.rows || attribute == this.columns) {
            this._rows = ((IntToken)this.rows.getToken()).intValue();
            this._columns = ((IntToken)this.columns.getToken()).intValue();
            if (this._rows <= 0 || this._columns <= 0) {
                throw new IllegalActionException((Nameable)this, "Number of rows and columns is required to be positive.");
            }
        } else {
            super.attributeChanged(attribute);
        }
    }

    @Override
    public final void fire() throws IllegalActionException {
        super.fire();
        double[][] result = new double[this._rows][this._columns];
        for (int i = 0; i < this._rows; ++i) {
            Token[] row = this.input.get(0, this._columns);
            for (int j = 0; j < this._columns; ++j) {
                result[i][j] = ((DoubleToken)row[j]).doubleValue();
            }
        }
        this.output.send(0, new DoubleMatrixToken(result, 1));
    }
}

