/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.sdf.lib;

import ptolemy.data.ArrayToken;
import ptolemy.data.IntToken;
import ptolemy.data.MatrixToken;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.ArrayType;
import ptolemy.data.type.BaseType;
import ptolemy.domains.sdf.lib.SDFTransformer;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;

public class MatrixSplit
extends SDFTransformer {
    public Parameter columnSplit;
    public Parameter rowSplit = new Parameter(this, "rowSplit");

    public MatrixSplit(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.rowSplit.setTypeEquals(new ArrayType(BaseType.INT));
        this.rowSplit.setExpression("{1}");
        this.columnSplit = new Parameter(this, "columnSplit");
        this.columnSplit.setTypeEquals(new ArrayType(BaseType.INT));
        this.columnSplit.setExpression("{1}");
        this.output_tokenProductionRate.setExpression("rowSplit.length() * columnSplit.length()");
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        if (!this.input.hasToken(0)) {
            return;
        }
        ArrayToken columns = (ArrayToken)this.columnSplit.getToken();
        ArrayToken rows = (ArrayToken)this.rowSplit.getToken();
        int[] columnsValue = new int[columns.length()];
        for (int i = 0; i < columnsValue.length; ++i) {
            columnsValue[i] = ((IntToken)columns.getElement(i)).intValue();
        }
        int[] rowsValue = new int[rows.length()];
        for (int i = 0; i < rowsValue.length; ++i) {
            rowsValue[i] = ((IntToken)rows.getElement(i)).intValue();
        }
        MatrixToken inputValue = (MatrixToken)this.input.get(0);
        MatrixToken[][] result = inputValue.split(rowsValue, columnsValue);
        for (int i = 0; i < result.length; ++i) {
            for (int j = 0; j < result[i].length; ++j) {
                this.output.send(0, result[i][j]);
            }
        }
    }
}

