/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import ptolemy.graph.Edge;
import ptolemy.graph.Element;
import ptolemy.graph.ElementList;
import ptolemy.graph.GraphConstructionException;
import ptolemy.graph.GraphElementException;
import ptolemy.graph.GraphException;
import ptolemy.graph.GraphWeightException;
import ptolemy.graph.Node;
import ptolemy.graph.analysis.Analysis;
import ptolemy.graph.analysis.SelfLoopAnalysis;
import ptolemy.graph.analysis.strategy.CachedStrategy;

public class Graph
implements Cloneable {
    private ArrayList _analysisList;
    private long _changeCount;
    private ElementList _edges;
    private HashSet _hiddenEdgeSet;
    private HashMap _incidentEdgeMap;
    private ElementList _nodes;
    private SelfLoopAnalysis _selfLoopAnalysis;

    public Graph() {
        this._nodes = new ElementList("node", this);
        this._edges = new ElementList("edge", this);
        this._initializeAnalyses();
        this._hiddenEdgeSet = new HashSet();
        this._incidentEdgeMap = new HashMap();
    }

    public Graph(int nodeCount) {
        this._nodes = new ElementList("node", this, nodeCount);
        this._edges = new ElementList("edge", this);
        this._initializeAnalyses();
        this._hiddenEdgeSet = new HashSet();
        this._incidentEdgeMap = new HashMap(nodeCount);
    }

    public Graph(int nodeCount, int edgeCount) {
        this._nodes = new ElementList("node", this, nodeCount);
        this._edges = new ElementList("edge", this, edgeCount);
        this._initializeAnalyses();
        this._hiddenEdgeSet = new HashSet();
        this._incidentEdgeMap = new HashMap(nodeCount);
    }

    public void addAnalysis(Analysis analysis) {
        if (analysis.graph() != this) {
            throw new IllegalArgumentException("Invalid associated graph.\nThe analysis:\n" + analysis + "\n");
        }
        if (this._analysisList.contains(analysis)) {
            throw new IllegalArgumentException("Attempt to add duplicate analysis.\nThe analysis:\n" + analysis);
        }
        this._analysisList.add(analysis);
    }

    public Edge addEdge(Node node1, Node node2, Object weight) {
        return this._addEdge(node1, node2, true, weight);
    }

    public Edge addEdge(Node node1, Node node2) {
        return this._addEdge(node1, node2, false, null);
    }

    public Collection addEdge(Object weight1, Object weight2, Object newEdgeWeight) {
        return this._addEdges(weight1, weight2, true, newEdgeWeight);
    }

    public Collection addEdge(Object weight1, Object weight2) {
        return this._addEdges(weight1, weight2, false, null);
    }

    public Edge addEdge(Edge edge) {
        if (!this.containsNode(edge.source())) {
            throw new GraphElementException(edge, this, "The source node is not in the graph.");
        }
        if (!this.containsNode(edge.sink())) {
            throw new GraphElementException(edge, this, "The sink node is not in the graph.");
        }
        if (this.containsEdge(edge)) {
            throw new GraphConstructionException("Attempt to add an edge that is already in the graph." + GraphException.elementDump(edge, this));
        }
        if (this.hidden(edge)) {
            throw new GraphConstructionException("Attempt to add an edge that is already hidden in the graph." + GraphException.elementDump(edge, this));
        }
        this._registerEdge(edge);
        return edge;
    }

    public void addEdges(Collection edgeCollection) {
        Iterator edges = edgeCollection.iterator();
        while (edges.hasNext()) {
            this.addEdge((Edge)edges.next());
        }
    }

    public boolean addGraph(Graph graph) {
        this.addNodes(graph.nodes());
        this.addEdges(graph.edges());
        return graph.nodeCount() + graph.edgeCount() > 0;
    }

    public Node addNode() {
        Node node = new Node();
        this._registerNode(node);
        return node;
    }

    public Node addNode(Node node) {
        if (this.containsNode(node)) {
            throw new GraphConstructionException("Attempt to add a node that is already contained in the graph." + GraphException.elementDump(node, this));
        }
        this._registerNode(node);
        return node;
    }

    public Node addNodeWeight(Object weight) {
        Node node = new Node(weight);
        this._registerNode(node);
        return node;
    }

    public Collection addNodeWeights(Collection weightCollection) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        Iterator weights = weightCollection.iterator();
        while (weights.hasNext()) {
            nodes.add(this.addNodeWeight(weights.next()));
        }
        return nodes;
    }

    public void addNodes(Collection nodeCollection) {
        Iterator nodes = nodeCollection.iterator();
        while (nodes.hasNext()) {
            this.addNode((Node)nodes.next());
        }
    }

    public long changeCount() {
        return this._changeCount;
    }

    public Object clone() {
        return this.cloneAs(this);
    }

    public Graph cloneAs(Graph graph) {
        Graph cloneGraph = graph._emptyGraph();
        Iterator nodes = this.nodes().iterator();
        while (nodes.hasNext()) {
            cloneGraph.addNode((Node)nodes.next());
        }
        Iterator edges = this.edges().iterator();
        while (edges.hasNext()) {
            cloneGraph.addEdge((Edge)edges.next());
        }
        return cloneGraph;
    }

    public Collection connectedComponents() {
        HashMap<Node, Node> componentMap = new HashMap<Node, Node>(this.nodeCount());
        HashSet<Node> components = new HashSet<Node>(this.nodeCount());
        for (Node node : this.nodes()) {
            ArrayList<Node> component = new ArrayList<Node>();
            component.add(node);
            Node container = new Node(component);
            componentMap.put(node, container);
            components.add(container);
        }
        for (Edge edge : this.edges()) {
            ArrayList sinkSet;
            Node sourceContainer = (Node)componentMap.get(edge.source());
            Node sinkContainer = (Node)componentMap.get(edge.sink());
            ArrayList sourceSet = (ArrayList)sourceContainer.getWeight();
            if (sourceSet == (sinkSet = (ArrayList)sinkContainer.getWeight())) continue;
            components.remove(sinkContainer);
            for (Node moveNode : sinkSet) {
                componentMap.put(moveNode, sourceContainer);
                sourceSet.add(moveNode);
            }
        }
        ArrayList<Object> result = new ArrayList<Object>(components.size());
        Iterator connectedComponents = components.iterator();
        while (connectedComponents.hasNext()) {
            result.add(((Node)connectedComponents.next()).getWeight());
        }
        return result;
    }

    public boolean containsEdge(Edge edge) {
        return this._edges.contains(edge) && !this.hidden(edge);
    }

    public boolean containsEdgeWeight(Object weight) {
        return this._edges.containsWeight(weight);
    }

    public boolean containsNode(Node node) {
        return this._nodes.contains(node);
    }

    public boolean containsNodeWeight(Object weight) {
        return this._nodes.containsWeight(weight);
    }

    public Edge edge(Object weight) {
        return (Edge)this._edges.element(weight);
    }

    public Edge edge(int label) {
        return (Edge)this._edges.get(label);
    }

    public int edgeCount() {
        return this._edges.size() - this._hiddenEdgeSet.size();
    }

    public int edgeLabel(Edge edge) {
        return this._edges.label(edge);
    }

    public int edgeLabel(Object weight) {
        return this._edges.label(this.edge(weight));
    }

    public Object edgeWeight(int label) {
        return ((Edge)this._edges.get(label)).getWeight();
    }

    public Collection edges() {
        if (this.hiddenEdgeCount() == 0) {
            return Collections.unmodifiableList(this._edges);
        }
        int visibleEdgeCount = this._edges.size() - this.hiddenEdgeCount();
        ArrayList<Edge> result = new ArrayList<Edge>(visibleEdgeCount);
        if (visibleEdgeCount == 0) {
            return Collections.unmodifiableList(result);
        }
        for (Edge edge : this._edges) {
            if (this.hidden(edge)) continue;
            result.add(edge);
        }
        return Collections.unmodifiableList(result);
    }

    public Collection edges(Object weight) {
        return this._edges.elements(weight);
    }

    public Collection edges(Collection collection) {
        ArrayList edges = new ArrayList();
        Iterator weights = collection.iterator();
        while (weights.hasNext()) {
            edges.addAll(this.edges(weights.next()));
        }
        return Collections.unmodifiableCollection(edges);
    }

    public boolean equals(Object graph) {
        if (graph == null) {
            return false;
        }
        if (graph.getClass() != this.getClass()) {
            return false;
        }
        Graph argumentGraph = (Graph)graph;
        if (argumentGraph.nodeCount() != this.nodeCount() || argumentGraph.edgeCount() != this.edgeCount()) {
            return false;
        }
        Iterator argumentNodes = argumentGraph.nodes().iterator();
        while (argumentNodes.hasNext()) {
            if (this.containsNode((Node)argumentNodes.next())) continue;
            return false;
        }
        Iterator argumentEdges = argumentGraph.edges().iterator();
        while (argumentEdges.hasNext()) {
            if (this.containsEdge((Edge)argumentEdges.next())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int code = this.getClass().getName().hashCode();
        Iterator nodes = this.nodes().iterator();
        while (nodes.hasNext()) {
            code += nodes.next().hashCode();
        }
        Iterator edges = this.edges().iterator();
        while (edges.hasNext()) {
            code += edges.next().hashCode();
        }
        return code;
    }

    public boolean hidden(Edge edge) {
        return this._hiddenEdgeSet.contains(edge);
    }

    public int hiddenEdgeCount() {
        return this._hiddenEdgeSet.size();
    }

    public Collection hiddenEdges() {
        return Collections.unmodifiableCollection(this._hiddenEdgeSet);
    }

    public boolean hideEdge(Edge edge) {
        if (!this.containsEdge(edge)) {
            return false;
        }
        if (this._hiddenEdgeSet.add(edge)) {
            this._disconnectEdge(edge);
            return true;
        }
        return false;
    }

    public int incidentEdgeCount(Node node) {
        GraphElementException.checkNode(node, this);
        return this._incidentEdgeList(node).size();
    }

    public Collection incidentEdges(Node node) {
        GraphElementException.checkNode(node, this);
        return Collections.unmodifiableList(this._incidentEdgeList(node));
    }

    public Collection neighborEdges(Node node1, Node node2) {
        Collection edgeCollection = this.incidentEdges(node1);
        GraphElementException.checkNode(node2, this);
        Iterator edges = edgeCollection.iterator();
        ArrayList<Edge> commonEdges = new ArrayList<Edge>();
        while (edges.hasNext()) {
            Edge edge = (Edge)edges.next();
            if (edge.source() == node2) {
                commonEdges.add(edge);
                continue;
            }
            if (edge.sink() != node2) continue;
            commonEdges.add(edge);
        }
        return commonEdges;
    }

    public Collection neighbors(Node node) {
        Collection incidentEdgeCollection = this.incidentEdges(node);
        Iterator incidentEdges = incidentEdgeCollection.iterator();
        ArrayList<Node> result = new ArrayList<Node>(incidentEdgeCollection.size());
        while (incidentEdges.hasNext()) {
            Edge edge = (Edge)incidentEdges.next();
            Node sink = edge.sink();
            Node source = edge.source();
            if (source == node) {
                if (result.contains(sink)) continue;
                result.add(sink);
                continue;
            }
            if (sink != node || result.contains(source)) continue;
            result.add(source);
        }
        return result;
    }

    public Node node(Object weight) {
        return (Node)this._nodes.element(weight);
    }

    public Node node(int label) {
        return (Node)this._nodes.get(label);
    }

    public int nodeCount() {
        return this._nodes.size();
    }

    public int nodeLabel(Node node) {
        return this._nodes.label(node);
    }

    public int nodeLabel(Object weight) {
        return this._nodes.label(this.node(weight));
    }

    public Object nodeWeight(int label) {
        return ((Node)this._nodes.get(label)).getWeight();
    }

    public Collection nodes() {
        return Collections.unmodifiableList(this._nodes);
    }

    public Collection nodes(Object weight) {
        return this._nodes.elements(weight);
    }

    public Collection nodes(Collection collection) {
        ArrayList nodes = new ArrayList();
        Iterator weights = collection.iterator();
        while (weights.hasNext()) {
            nodes.addAll(this.nodes(weights.next()));
        }
        return Collections.unmodifiableCollection(nodes);
    }

    public boolean removeEdge(Edge edge) {
        if (!this._edges.contains(edge)) {
            return false;
        }
        this._edges.remove(edge);
        if (this.hidden(edge)) {
            this._hiddenEdgeSet.remove(edge);
        } else {
            this._disconnectEdge(edge);
        }
        return true;
    }

    public boolean removeNode(Node node) {
        if (!this._nodes.contains(node)) {
            return false;
        }
        Object[] incidentEdgeArray = this.incidentEdges(node).toArray();
        this._nodes.remove(node);
        for (int i = 0; i < incidentEdgeArray.length; ++i) {
            this.removeEdge((Edge)incidentEdgeArray[i]);
        }
        this._incidentEdgeMap.remove(node);
        this._registerChange();
        return true;
    }

    public boolean restoreEdge(Edge edge) {
        if (this._hiddenEdgeSet.remove(edge)) {
            if (!this.containsNode(edge.source())) {
                throw new GraphElementException(edge, this, "Source node is not in the graph.");
            }
            if (!this.containsNode(edge.sink())) {
                throw new GraphElementException(edge, this, "Sink node is not in the graph.");
            }
            this._connectEdge(edge);
            return true;
        }
        return false;
    }

    public int selfLoopEdgeCount() {
        return this.selfLoopEdges().size();
    }

    public int selfLoopEdgeCount(Node node) {
        return this.selfLoopEdges(node).size();
    }

    public Collection selfLoopEdges() {
        return this._selfLoopAnalysis.edges();
    }

    public Collection selfLoopEdges(Node node) {
        ArrayList<Edge> result = new ArrayList<Edge>();
        for (Edge edge : this.incidentEdges(node)) {
            if (!edge.isSelfLoop()) continue;
            result.add(edge);
        }
        return result;
    }

    public Graph subgraph(Collection collection) {
        Graph subgraph = this._emptyGraph();
        Iterator nodes = collection.iterator();
        while (nodes.hasNext()) {
            subgraph.addNode((Node)nodes.next());
        }
        for (Node node : collection) {
            if (!this.containsNode(node)) {
                throw new GraphElementException(node, this, "Attempt to form an induced subgraph containing a node that is not in the 'parent' graph.");
            }
            for (Edge edge : this.incidentEdges(node)) {
                if (!subgraph.containsNode(edge.source()) || !subgraph.containsNode(edge.sink()) || subgraph.containsEdge(edge)) continue;
                subgraph.addEdge(edge);
            }
        }
        return subgraph;
    }

    public Graph subgraph(Collection nodeCollection, Collection edgeCollection) {
        Graph subgraph = this._emptyGraph();
        for (Node node : nodeCollection) {
            if (this.containsNode(node)) continue;
            throw new GraphElementException(node, this, "Attempt to form a subgraph containing a node that is not in the 'parent' graph.");
        }
        for (Edge edge : edgeCollection) {
            if (this.containsEdge(edge)) continue;
            throw new GraphElementException(edge, this, "Attempt to form a subgraph containing an edge that is not in the 'parent' graph.");
        }
        subgraph.addNodes(nodeCollection);
        subgraph.addEdges(edgeCollection);
        return subgraph;
    }

    public String toString() {
        StringBuffer result = new StringBuffer("{" + this.getClass().getName() + "\n");
        result.append("Node Set:\n" + this._nodes.toString("\n", true) + "\n");
        result.append("Edge Set:\n" + this._edges.toString("\n", true) + "\n}\n");
        return result.toString();
    }

    public boolean validEdgeWeight(Object object) {
        return true;
    }

    public boolean validNodeWeight(Object object) {
        return true;
    }

    public boolean validateWeight(Edge edge) {
        Object weightArgument;
        if (edge == null) {
            throw new NullPointerException("Attempt to validate the weight of a null graph edge.");
        }
        if (!this.containsEdge(edge)) {
            throw new GraphElementException(edge, this, "The specified edge is not in the graph.");
        }
        Object object = weightArgument = edge.hasWeight() ? edge.getWeight() : null;
        if (!this.validEdgeWeight(weightArgument)) {
            throw new GraphWeightException(weightArgument, edge, this, "Invalid weight associated with an edge in the graph.\n");
        }
        boolean changed = this._edges.changeWeight(edge);
        if (changed) {
            this._registerChange();
        }
        return changed;
    }

    public boolean validateWeight(Edge edge, Object oldWeight) {
        Object newWeight;
        if (!this.containsEdge(edge)) {
            throw new GraphElementException(edge, this, "The specified edge is not in the graph.");
        }
        Object object = newWeight = edge.hasWeight() ? edge.getWeight() : null;
        if (!this.validEdgeWeight(newWeight)) {
            throw new GraphWeightException(newWeight, edge, this, "Invalid weight associated with an edge in the graph.");
        }
        boolean changed = this._edges.validateWeight(edge, oldWeight);
        if (changed) {
            this._registerChange();
        }
        return changed;
    }

    public boolean validateWeight(Node node) {
        Object weightArgument;
        if (node == null) {
            throw new NullPointerException("Attempt to validate the weight of a null graph node.");
        }
        if (!this.containsNode(node)) {
            throw new GraphElementException(node, this, "The specified node is not in the graph.");
        }
        Object object = weightArgument = node.hasWeight() ? node.getWeight() : null;
        if (!this.validNodeWeight(weightArgument)) {
            throw new GraphWeightException(weightArgument, node, this, "Invalid weight associated with a node in the graph.");
        }
        boolean changed = this._nodes.changeWeight(node);
        if (changed) {
            this._registerChange();
        }
        return changed;
    }

    public boolean validateWeight(Node node, Object oldWeight) {
        Object newWeight;
        if (!this.containsNode(node)) {
            throw new GraphElementException(node, this, "The specified node is not in the graph.");
        }
        Object object = newWeight = node.hasWeight() ? node.getWeight() : null;
        if (!this.validNodeWeight(newWeight)) {
            throw new GraphWeightException(newWeight, node, this, "Invalid weight associated with a node in the graph.");
        }
        boolean changed = this._nodes.validateWeight(node, oldWeight);
        if (changed) {
            this._registerChange();
        }
        return changed;
    }

    public static Object[] weightArray(Collection elementCollection) {
        if (elementCollection == null) {
            return new Object[0];
        }
        Element element = null;
        Object[] result = new Object[elementCollection.size()];
        Iterator elements = elementCollection.iterator();
        try {
            for (int i = 0; i < elementCollection.size(); ++i) {
                element = (Element)elements.next();
                if (element == null) {
                    throw new NullPointerException("Null graph element specified.\n");
                }
                result[i] = element.getWeight();
            }
        }
        catch (ClassCastException exception) {
            throw new GraphElementException("Illegal graph element (neither a Node nor an Edge) specified.\nThe element's type is: " + element.getClass().getName() + ".\n");
        }
        return result;
    }

    protected Edge _addEdge(Node node1, Node node2, boolean weighted, Object weight) {
        if (!this.containsNode(node1)) {
            throw new GraphElementException(node1, this, "The specified first node is not in the graph.");
        }
        if (!this.containsNode(node2)) {
            throw new GraphElementException(node2, this, "The specified second node is not in the graph.");
        }
        if (weighted && weight == null) {
            throw new NullPointerException("Attempt to assign a null weight to an edge. The first node:\n" + node1 + "\nThe second node:\n" + node2 + "\nThe graph: \n" + this);
        }
        Edge edge = null;
        edge = weighted ? new Edge(node1, node2, weight) : new Edge(node1, node2);
        this._registerEdge(edge);
        return edge;
    }

    protected void _connect(Edge edge, Node node) {
        if (this._incidentEdgeList(node).contains(edge)) {
            throw new GraphConstructionException("Attempt to connect the same edge multiple times." + GraphException.elementDump(edge, this));
        }
        this._incidentEdgeList(node).add(edge);
    }

    protected void _connectEdge(Edge edge) {
        this._connect(edge, edge.source());
        if (!edge.isSelfLoop()) {
            this._connect(edge, edge.sink());
        }
        this._edges.registerWeight(edge);
        this._registerChange();
    }

    protected void _disconnect(Edge edge, Node node) {
        this._incidentEdgeList(node).remove(edge);
    }

    protected void _disconnectEdge(Edge edge) {
        this._disconnect(edge, edge.source());
        this._disconnect(edge, edge.sink());
        this._edges.cancelWeight(edge);
        this._registerChange();
    }

    protected Graph _emptyGraph() {
        Graph graph = null;
        try {
            graph = (Graph)this.getClass().newInstance();
        }
        catch (Exception exception) {
            throw new GraphConstructionException("Could not create an empty graph from this one.\n" + exception + "\n" + GraphException.graphDump(this));
        }
        return graph;
    }

    protected void _initializeAnalyses() {
        this._analysisList = new ArrayList();
        this._selfLoopAnalysis = new SelfLoopAnalysis(this);
        this._changeCount = 0L;
    }

    protected void _registerChange() {
        if (this._changeCount == Long.MAX_VALUE) {
            for (Analysis analysis : this._analysisList) {
                if (!(analysis.analyzer() instanceof CachedStrategy)) continue;
                ((CachedStrategy)analysis.analyzer()).reset();
            }
            this._changeCount = 0L;
        } else {
            ++this._changeCount;
        }
    }

    protected void _registerEdge(Edge edge) {
        Object weight;
        Object object = weight = edge.hasWeight() ? edge.getWeight() : null;
        if (!this.validEdgeWeight(weight)) {
            throw new GraphWeightException(weight, edge, this, "Invalid edge weight.");
        }
        this._edges.add(edge);
        this._connectEdge(edge);
    }

    protected void _registerNode(Node node) {
        Object weight;
        Object object = weight = node.hasWeight() ? node.getWeight() : null;
        if (!this.validNodeWeight(weight)) {
            throw new GraphWeightException(weight, node, this, "Invalid node weight.");
        }
        this._nodes.add(node);
        this._incidentEdgeMap.put(node, new ArrayList());
        this._nodes.registerWeight(node);
        this._registerChange();
    }

    private Collection _addEdges(Object weight1, Object weight2, boolean weighted, Object weight) {
        if (weight1 == null) {
            throw new NullPointerException("Null source node weight");
        }
        if (weight2 == null) {
            throw new NullPointerException("Null sink node weight");
        }
        Iterator nodes1 = this.nodes(weight1).iterator();
        Edge newEdge = null;
        ArrayList<Edge> newEdges = new ArrayList<Edge>();
        while (nodes1.hasNext()) {
            Node node1 = (Node)nodes1.next();
            Iterator nodes2 = this.nodes(weight2).iterator();
            while (nodes2.hasNext()) {
                newEdge = this._addEdge(node1, (Node)nodes2.next(), weighted, weight);
                newEdges.add(newEdge);
            }
        }
        if (newEdges.isEmpty()) {
            throw new GraphConstructionException("No edge can be added based on the specified source and sink node weights.\nWeight1:\n" + weight1 + "\nWeight2:\n" + weight2 + "\n" + GraphException.graphDump(this));
        }
        return newEdges;
    }

    private ArrayList _incidentEdgeList(Node node) {
        return (ArrayList)this._incidentEdgeMap.get(node);
    }
}

